/**
 *  @author Priyanshi Sharma
 */
Ext.define('Academia.view.hostel.hostelapplication.HostelApplicationApplicantListGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.hostelapplicationapplicantlistgrid',
	store : 'hostel.hostelapplication.HostelApplicationApplicantStore',
	title: getHostelTranslation('HOSTEL_APPLICATIONS'),
	border: true,
	reserveScrollbar:true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	//renderTo: Ext.getBody(),
    /*selModel: {
        selType: 'checkboxmodel'
    },*/
	selType:'checkboxmodel',
    selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
    headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'hostelapplicationsstructure':1
		}
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.hostelapplication.HostelApplicationApplicantStore',
			emptyMsg :getHostelTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnApplyRule',
		text: getCommonTranslation('APPLY_RULE')
	},{
		xtype: 'button',
		itemId: 'btnAllotRoom',
		text: getHostelTranslation('ALLOT_ROOM')
	},{
		xtype: 'button',
		itemId: 'btnRejectApplication',
		text: getHostelTranslation('CANCEL_APPLICATION'),
		disabled:true
	},{
		xtype : 'splitbutton',
		itemId:'spBtnMoreActions',
		text : getCommonTranslation('MOREACTIONS'),
		menu:[{
			text: getHostelTranslation('ISSUE_OFFER_LETTER'),
			itemId: 'sendOfferLetter',
			disabled:true
		},{
			text:getHostelTranslation('CANCEL_OFFER_LETTER'),
			itemId:'cancelOfferLetter',
			disabled:true
		},{
			text:getHostelTranslation('ACCEPT_OFFER_LETTER'),
			itemId:'acceptOfferLetter',
			disabled:true
		},{
			text:getCommonTranslation('ALLOCATE_HOSTEL'),
			itemId:'allocatedApplicationHostel',
			disabled:true
		},{
			text:getCommonTranslation('CANCEL_HOSTEL_ALLOCATION'),
			itemId:'cancelApplicationHostel',
			disabled:true
		}],
		listeners: { click: function() { this.showMenu(); } }
	}],
	columns: [{
		header : getCommonTranslation('Applicant ID'),
		dataIndex : 'applicantCode',
		flex:1
	},{
		header : getCommonTranslation('APPLICANT_NAME'),
		dataIndex : 'applicantName',
		flex:1
	},{
		header : getCommonTranslation('ACADEMY_LOCATION'),
		dataIndex : 'academyLocationName',
		flex:1
	},{
		header : getCBTranslation('activity'),
		dataIndex : 'hostelStatus',
		flex:1,
		renderer : function(value) {
			var val = '';
			if(value == 'AVAILABLE') {
				val = '<span style="color:Green;">' +'Available'+ '</span>';
			}else if(value == 'NOT_AVAILABLE') {
				val = '<span style="color:red;">' +'Not Available'+ '</span>';
			}else if(value == 'REJECTED') {
				val = '<span style="color:red;">' +'Rejected'+ '</span>';
			}else if(value == 'PENDING') {
				val = '<span style="color:red;">' +'Pending'+ '</span>';
			}
			return val;
		}
		
	},{
		header : getFeeAndPaymentCommonTranslation('SETTLEMENT_STATUS'),
		dataIndex : 'billStatus',
		flex:1,
		renderer : function(value) {
			var val = '';
			if(value == 'SETTLED') {
				val = 'Settled';
			}else if(value == 'REVERSED') {
				val = 'Reversed';
			}else if(value == 'PARTLY_SETTLED') {
				val = 'Pending';
			}else if(value == 'FULLY_PENDING') {
				val = 'Pending';
			}else if(value == 'CANCELLED') {
				val = 'Cancelled';
			}else if(value == 'PENDING') {
				val = 'Pending';
			}
			return val;
		}
	},{
		header : getCommonTranslation('APPLICATION_TYPE'),
		dataIndex : 'applicationType',
		flex:1,
		renderer:function(value){
			if(value == 'WAITING_LIST_SETUP'){
				return  getFeeAndPaymentCommonTranslation('WAITING_LIST_APPLICATION');
			}else if(value == 'HOSTEL_GENERAL_SETUP'){
				return getFeeAndPaymentCommonTranslation('GENERAL_APPLICATION');
			}else {
				return '';
			}
		}
	},{
		header : getFeeAndPaymentCommonTranslation('WAITING_LIST_ID_NAME'),
		dataIndex : 'hostelApplicationSetupName',
		flex:1
	},{
		header : getCommonTranslation('LOCATION'),
		dataIndex : 'locationName',
		flex:1
	},{
		header : getCommonTranslation('YEAR'),
		dataIndex : 'year',
		flex:1
	},{
		header : getCommonTranslation('APPLICATION_STATUS'),
		dataIndex : 'applicationStatus',
		flex:1,
		renderer : function(value) {
			var val = '';
			if(value == 'SUBMITTED') {
				val = 'Submitted';
			}else if(value == 'REVOKED') {
				val = 'Revoked';
			}else if(value == 'CANCELLED') {
				val = 'Cancelled';
			}else if(value == 'OFFER_LETTER_ACCEPTED') {
				val = 'Offer letter Accepted';
			}else if(value == 'OFFER_LETTER_ISSUED') {
				val = 'Offer Letter Issued';
			}else if(value == 'OFFER_LETTER_DECLINED') {
				val = 'Offer Letter Declined';
			}else if(value == 'OFFER_LETTER_DUE') {
				val = 'Offer Letter Due';
			}else if(value == 'OFFER_LETTER_REVOKED') {
				val = 'Offer Letter Cancelled';
			}else if(value == 'OFFER_LETTER_EXPIRED') {
				val = 'Offer letter Expired';
			}else if(value == 'ALLOCATED') {
				val = 'Allocated';
			}else if(value == 'UNALLOCATED') {
				val = 'Unallocated';
			}
			return val;
		}
	},{
		header : getCommonTranslation('APPLICATION_DATE'),
		dataIndex : 'applicationDate',
		flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('WAITING_LIST_RANKING'),
		dataIndex : 'ranking',
		flex:1
	},{
		header : getCommonTranslation('HOSTEL_PREFERENCE_CHOICES'), 
		dataIndex : 'hostelPreferenceChoices',
		flex:1,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(value) && value == "HOSTEL_GENERAL_SETUP") {
				return '<a href=#>'+getCommonTranslation('VIEW')+'</a>';
			}                        
		}
	},{
		header : getCommonTranslation('OFFER_ISSUE_DATE'),
		dataIndex : 'offerIssueDate',
		flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('OFFER_EXPIRY_DATE'),
		dataIndex : 'offerExpiryDate',
		flex:1,
		renderer:function(date) {
			return dateRender(date);
		}
	},{
		header : getCommonTranslation('POSITION_OF_WAITING_LIST'),
		dataIndex : 'positionOfWaitingList',
		flex:1,
		renderer:function(value, meta, rec) {
			return rec.data.positionOnWaitingList;
		}
	},
	{
		header : getCommonTranslation('ALLOCATED_HOSTEL'),
		dataIndex : 'allocatedHostelName',
		flex:1
	},{
		header : getCommonTranslation('RESTRICTION_TYPE'),
		dataIndex : 'restrictionType',
		flex:1
	},
	{
		header : getCommonTranslation('WARDEN'),
		dataIndex : 'warden',
		flex:1
	},
	{
		header : getCommonTranslation('HOSTEL_CATEGORY'),
		dataIndex : 'hostelCategory',
		flex:1,
		renderer:function(value) {
			if(value == 'CATERED'){
				return  'Catered';
			}else if(value == 'SELF_CATERED'){
				 return 'Self-catered';	
			}else {
				return '';
			}
		}
	},
	{
		header : getCommonTranslation('CLUSTER_CODE'),
		dataIndex : 'clusterCode',
		flex:1
	},
	{
		header : getCommonTranslation('HOSTEL_TYPE'),
		dataIndex : 'hostelType',
		flex:1
	},
	{
		header : getCommonTranslation('HOSTEL_LEVEL'),
		dataIndex : 'hostelLevel',
		flex:1
	},{
		header : getCommonTranslation('DEPOSIT_CATEGORY'),
		dataIndex : 'depositCategoryName',
		flex:1
	},{
		header : getCommonTranslation('REJECTED_REASON'),
		dataIndex : 'rejectedReason',
		flex:1
	},{
		header : getCommonTranslation('REJECTED_BY'),
		dataIndex : 'rejectedBy',
		flex:1
	},{
		header : getCommonTranslation('CANCELLATION_REASON'),
		dataIndex : 'applicantCancellationReason',
		flex:1
	}]
});