/**
 *  @author Suraj Chouhan
 */
Ext.define('Academia.view.hostel.hostelapplication.HostelApplicationsSearch', {
	extend: 'Ext.form.Panel',
	alias: 'widget.hostelapplicationssearch',
	autoScroll: false,
	frame: false,
	//cls:'customSearchPanel',
	standardSubmit: false,
	plugins : "formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
         	xtype: 'customcombobox',
            name: 'applicantionType',
            itemId:'applicantionType',
            fieldLabel:getCommonTranslation('APPLICATION_TYPE'),
            store: Ext.create('Academia.store.hostel.hostelapplication.HostelApplicationTypeStore'),
            displayField:'value',
            valueField:'id',
            forceSelection:true,
	        editable: false
		},		
		{			
			xtype : 'customcombobox',
			cls:'commonAutoHeightMultiselectField',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),
			autoloadStore: false,
			name : 'year',
			itemId : 'YearId',      	   
			displayField : 'value',
			valueField : 'id',
			typeAhead : true,
			forceSelection : true,
			hidden : false,
			store:Ext.create('Academia.store.common.BulkStatusUpdateYearStore'),
			editable: false
		},
		{
			xtype: 'customcombobox',
			name: 'locationIdName',
			itemId: 'locationNameItemId',
			fieldLabel: getCommonTranslation('LOCATION'),
			store:Ext.create('Academia.store.hostel.managehostel.hostel.LocationCodeName'),
			displayField: 'value',
			valueField: 'id',
			editable: false,
			forceSelection:true
		}]
	
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			name: 'studentName',
			itemId: 'studentNameItemId',
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: Ext.create('Academia.view.hostel.hostelapplication.StudentListStore'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'studentCode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			//disabled:true,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		},{
         	xtype: 'customcombobox',
            name: 'programGroupId',
            itemId:'programGroupId',
            fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
            store: Ext.create('Academia.view.hostel.hostelapplication.ProgramGroupStore'),
            valueField: 'id',
			displayField: 'value',
            forceSelection:true,
	        editable: false
		
		},
		{
       	 xtype: 'customcombobox',
			name:'PROGRAM_NAME',
			store:Ext.create('Academia.store.program.ProgramSortedSequenceWiseStore'),
			itemId:'programItemId',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'qry',
			minChars:3,
			allowBlank: true,
			typeAhead:false,
			disabled:true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                        '{code} / {value}'+ 
	                    '</div>';
	                }
	            }
		
     }]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
            xtype: 'customcombobox',
            name: 'BATCH_NAME',
            itemId: 'batchItemId',
            fieldLabel: getCommonTranslation('INTAKE'),
            editable: false,
            queryMode: 'local',
            displayField: 'value',
            disabled:true,
            valueField: 'id',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
                    combo.bindStore(store);
                }
            }
        },{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			store:Ext.create('Academia.view.hostel.hostelapplication.IntakeYearStore'),
			valueField:'id',
			width:226,
			forceSelection:true,
			editable: false
		},{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('SEAT_TYPE'),
			name: 'SEAT_TYPE',
			itemId: 'seatTypeItemId',
			editable: false,
			autoload: false,
			disabled:true,
			store:Ext.create('Academia.store.common.SeatTypesByBatchId'),
			valueField: 'seatTypeId',
			displayField: 'seatTypeName',
			queryMode : 'local'
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			name: 'hostelCodeName',
			itemId: 'hostelCodeName',
			fieldLabel: getHostelTranslation('HOSTEL_CODE_NAME'),
//			store : 'hostel.managehostel.hostel.ManageHostelCodeName',
			store:Ext.create('Academia.view.hostel.hostelapplication.HostelCodeNameStore'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'hostelnameorcode',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			//disabled:true,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		
		},
		{
			xtype: 'customcombobox',
			name: 'hstlWaitingList',
			itemId:'hstlWaitingList',
			fieldLabel: getCommonTranslation('HOSTEL_CONFIGURATION_ID_NAME'),
			store:Ext.create('Academia.view.hostel.hostelapplication.WaitingListNameStore'),
			valueField: 'id',
			displayField: 'value',
			editable: false,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'applicationStatusName',
			itemId:'applicationStatusItemId',
			fieldLabel: getCommonTranslation('APPLICATION_STATUS'),
			store: Ext.create('Academia.view.hostel.hostelapplication.ApplicationStore'),
			valueField: 'id',
			displayField: 'value',
			editable: false,
			forceSelection:true
		}]
	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls : 'windowBtnPos',
		style:{'margin-top':'20px'},
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SEARCH'),
			itemId : 'searchButtonItemId',
			buttonAlign : 'left',
			ui : 'CustomBtnSubmit',
//			formBind:true,
			scale: CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text : getCommonTranslation('RESET'),
			itemId : 'resetButtonItemId',
			buttonAlign : 'left',
			ui : 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		} ]
	}]
});