/**
 *  @author Deepak Sharma
 */
Ext.define('Academia.view.hostel.hostelapplication.HostelStudentSearch', {
	extend: 'Ext.form.Panel',
	alias: 'widget.hostelstudentsearch',
	autoScroll: false,
	frame: false,
	//cls:'customSearchPanel',
	standardSubmit: false,
	plugins : "formlabelrequired",
	items: [{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			name: 'academyLocationId',
			itemId: 'academyLocationItemId',
			fieldLabel: getCommonTranslation('ACADEMY_LOCATION'),
			store: 'user.UserAcademyLocationStore',
			displayField: 'value',
			valueField: 'id',
			queryParam: 'qry',
			width: 460,
			typeAhead: true,
			forceSelection: true,
			hideTrigger: false,
			allowBlank: false,
			triggerAction: 'all',
			minChars: 3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
         	xtype: 'customcombobox',
            name: 'applicantType',
            itemId:'applicantType',
            fieldLabel: getCommonTranslation('APPLICANT_TYPE'),
            store: 'hostel.hostelapplication.HostelApplicationApplicantTypeStore',
            displayField:'name',
            valueField:'value',
            forceSelection:true,
	        editable: false
		},{
			xtype: 'customcombobox',
			name: 'studentName',
			itemId: 'studentName',
			fieldLabel: getFeeAndPaymentCommonTranslation('STUDENT_CODE_NAME'),
			store: Ext.create('Academia.store.program.StudentsByAcademyLocationIdStore'),
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'term',
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			enableKeyEvents  : 'true',
			minChars:3,
			//disabled:true,
			typeAhead:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			triggerAction: '',
			hideTrigger:false,
			listConfig: {
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				},
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				}
			}
		},{
			xtype: 'customcombobox',
			name:'APPICANT_PRINT_NAME',
			itemId:'HstlApplicationsApplicantName',
			store:Ext.create('Academia.store.admission.applications.applicantProfileBase.ApplicantSmartSearchStore'),
			fieldLabel:getAdmissionTranslation('APPLICANT_ID_NAME'),
			width:226,
			valueField: 'code',
			displayField: 'printName',
			queryParam:'codeOrName',
			minChars:3,
			hidden:true,
			typeAhead:false,
			hideTrigger:false,
			triggerCls: Ext.baseCSSPrefix + 'form-search-trigger',
			triggerAction: '',
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            forceSelection:true,
			  listConfig: {
				  listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
	                loadingText: getCommonTranslation('SEARCHING'),
	                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
	                getInnerTpl: function() {
	                    return '<div class="search-item">' +
	                    '{code}/{printName}'  +
	                    '</div>';
	                }
	            }
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
         	xtype: 'customcombobox',
            name: 'programGroupId',
            itemId:'programGroupId',
            fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
            store: Ext.create('Academia.store.personinfo.common.personalinfo.AttendanceReportProgramGroupStore'),
            displayField:'value',
            valueField:'id',
            forceSelection:true,
	        editable: false
		},{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('INTAKE_YEAR'),
			name : 'intakeYear',
			itemId : 'intakeYear',
			displayField:'value',
			store:'common.IntakeYearStore',
			valueField:'id',
			width:226,
			forceSelection:true,
			editable: false
		},
		{
			xtype : 'customcombobox',
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTerm',
			displayField : 'value',
			valueField : 'id',
			store:'common.AcademicTermStore',
			editable: false,
			forceSelection : true,
			hidden : false
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			name:'programId',
			store: Ext.create('Academia.store.program.ProgramByGroupIdStore'),
			itemId:'programId',
			fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
			displayField:'valueCode',
			valueField:'id',
			queryParam:'qry',
			minChars:3,
			allowBlank: true,
			typeAhead:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			forceSelection:true,
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}'+ 
					'</div>';
				}
			}

		},{
			xtype: 'customcombobox',
			name: 'batchId',
			itemId: 'batchId',
			fieldLabel: getPersonModuleTranslation('BATCH'),
			disabled:true,
			editable: false,
			queryMode: 'local',
			displayField: 'value',
			valueField: 'id',
			listeners: {
				render: function(combo) {
					var store = Ext.create('Academia.store.program.programbatchdetail.BatchStore');
					combo.bindStore(store);
				}
			}
		},{
            xtype: 'customcombobox',
            itemId:'periodId',
            disabled:true,
            editable: false,
            displayField: 'value',
            valueField: 'id',
            queryMode: 'local',
            fieldLabel: getPersonModuleTranslation('PERIOD'),
            name: 'periodId',
            listeners: {
                render: function(combo) {
                    var store = Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod');
                    combo.bindStore(store);
                }
            }
        }]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
			xtype: 'customcombobox',
			fieldLabel: getAdmissionTranslation('SEAT_TYPE'), //Seat Type
			name: 'seatType',
			itemId: 'seatType',
			editable: false,
			autoload: false,
			store: Ext.create('Academia.store.enquiry.SeatTypeStore'),
			disabled:true,
			displayField: 'value',
			valueField: 'id',
			queryMode : 'local'
		},{
			xtype: 'customcombobox',
			name: 'sectionId',
			itemId: 'sectionId',
			fieldLabel: getPersonModuleTranslation('SECTION'),
			editable: false,
			queryMode: 'local',
			disabled:true,
			valueField: 'sectionId',
			displayField: 'sectionCode',
			listeners: {
				render: function(combo) {
					 var store = Ext.create('Academia.store.attendance.SectionAndFacultyByPeriodID');
                    combo.bindStore(store);
				}
			}
		},
		{
			xtype: 'customcombobox',
			name: 'settlementStatus',
			itemId:'settlementStatus',
			fieldLabel: getFeeAndPaymentCommonTranslation('SETTLEMENT_STATUS'),
			store: 'hostel.hostelapplication.HostelSattlementStatusStore',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			forceSelection:true
		},{
			xtype: 'customcombobox',
			name: 'waitingList',
			itemId:'waitingList',
			fieldLabel: getCommonTranslation('APPLIED_FOR_WAITING_LIST'),
			store: 'hostel.hostelapplication.HostelWaitingListStore',
			valueField: 'id',
			displayField: 'itemValue',
			editable: false,
			forceSelection:true
		}]
	},{
		xtype : 'fieldcontainer',
		width : 'auto',
		cls : 'windowBtnPos',
		items : [ {
			xtype : 'button',
			text : getCommonTranslation('SEARCH'),
			itemId : 'searchButtonId',
			buttonAlign : 'left',
			ui : 'CustomBtnSubmit',
			formBind:true,
			scale: CONSTANTS.BUTTONSIZE
		}, {
			xtype: 'button',
			text : getCommonTranslation('RESET'),
			itemId : 'resetButtonId',
			buttonAlign : 'left',
			ui : 'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE
		} ]
	}]
});
