/**
 *  @author Dharmendra.p
 */
Ext.define('Academia.view.hostel.manageallocation.manageallocationuserwise.ManageUserWiseList', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.manageuserwiselist',
	store :'hostel.manageallocation.manageallocationuserwise.ManageUserWiseList',
	title: getHostelTranslation('LIST_OF_ROOMS'),
	border: true,
	refreshStoreData:true,
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	selType:'checkboxmodel',
    selModel: {
		multiSelect :true,
		mode:'SIMPLE',
		checkOnly : false
	},
	isGridConfigurable: true,
	enableColumnHide: false,
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.manageallocation.manageallocationuserwise.ManageUserWiseList',
			emptyMsg :getHostelTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;    
		grid.addExportToolBarItems(grid);
		this.callParent(arguments); 
	},
	tbar: [/*{
		xtype: 'button',
		itemId: 'btnAllotRoom',
		text: getHostelTranslation('ALLOT_ROOM')
	},*/{
		xtype: 'button',
		itemId: 'btnCancelAllotment',
		text: getHostelTranslation('CANCEL_ALLOTMENT')
	},{
		xtype: 'button',
		itemId: 'btnCheckIn',
		text: getHostelTranslation('CHECK_IN')
	},{
		xtype: 'button',
		itemId: 'btnCancelCheckIn',
		disabled:true,
		text: getHostelTranslation('CANCEL_CHECK_IN')
	},{
		xtype: 'button',
		itemId: 'btnCheckOut',
		disabled:true,
		text: getHostelTranslation('CHECK_OUT')
	},{
        xtype: 'button',
        itemId: 'sendMessageBtn',
        text:getCommonTranslation('SEND_MESSAGE')
    },{
        xtype: 'button',
        itemId: 'manageDocument',
        disabled:true,
        text:getHostelTranslation('MANAGE_DOCUMENT')
    }],
	columns: [{
		header : getHostelTranslation('OCCUPANT'),
		dataIndex : 'userName',
		flex:1,
		renderer:function(value){
			if(!isNullOrEmpty(value)){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},
	{
		header : getHostelTranslation('STUDENT_ID'),
		dataIndex : 'studentCode',
		flex:1
	},
	{
		header : getHostelTranslation('HOSTEL_CODE_NAME'),
		dataIndex : 'hostelCode',
		flex:1,
		 renderer:function(value,record){
			 var hostelCodeName='';
			 if(!isNullOrEmpty(record.record.get("hostelCode") )){
				 var hostelCode = record.record.get("hostelCode");
				 var hostelName = record.record.get("hostelName");
				 hostelCodeName = hostelCode+ '/' +hostelName;
			 }
			 return  hostelCodeName;			 
		}
	},{
		header : getHostelTranslation('BUILDING_CODE_NAME'),
		dataIndex : 'buildingCode',
		flex:1,
		 renderer:function(value,record){
			 var buildingCodeName='';
			 if(!isNullOrEmpty(record.record.get("buildingCode") )){
				 var buildingCode = record.record.get("buildingCode");
				 var buildingName = record.record.get("buildingName");
				 buildingCodeName = buildingCode+ '/' +buildingName;
			 }
			 return  buildingCodeName;			 
		}
	},{
		header : getHostelTranslation('FLOOR_NO'),
		dataIndex : 'floorNo',
		flex:1
	},{
		header : getHostelTranslation('ROOM_NO'),
		dataIndex : 'roomNo',
		flex:1
	},{
		header : getHostelTranslation('ROOM_TYPE'),
		dataIndex : 'roomType',
		flex:1
	},{
		header : getHostelTranslation('TOTAL_NO_OF_BEDS'),
		dataIndex : 'noOfBeds',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getHostelTranslation('OCCUPIED_BEDS'),
		dataIndex : 'noOfOccupiedBeds',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	},{
		header : getHostelTranslation('AVAILABLE_BEDS'),
		dataIndex : 'noOfAvailableBeds',
		flex:1,
		renderer:function(value){
			if(value>0){
				return  '<a href="#">'+value+'</a>';
			}else{
				return value;
			}
		}
	}/*,{
		header : getHostelTranslation('AVAILABLE_FROM'),
		dataIndex : 'availableFrom',
		flex:1
	}*/,{
		header : getHostelTranslation('CURRENT_STATUS'),
		dataIndex : 'currentStatus',
		flex:1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'ALLOTTED' || value == 'Allotted'){
					return  getHostelTranslation('ALLOTTED');
				}else{
					return getHostelTranslation('CHECKED_IN');
				} 
			}
		}
	},{
		header : getHostelTranslation('BED_NO'),
		dataIndex : 'bedNo',
		flex:1
	},{
        header: getCommonTranslation('DOCUMENT'),
        dataIndex: 'documentId',
        sortable:true,
        flex: 1,
        renderer:function(value){
			
			 if(!isNullOrEmpty(value)){
				 return  '<a href="#">' + getCommonTranslation("VIEW_DETAILS") +'</a>';
			 }else
				 return "";
        }
    },{
		header : getHostelTranslation('CHECKED_IN_DATE'),
		dataIndex : 'checkInDate',
		flex:1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header : getHostelTranslation('EXPECTED_CHECK_OUT'),
		dataIndex : 'expectedCheckOutDate',
		flex:1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header : getHostelTranslation('CHECK_IN_REMARK'),
		dataIndex : 'checkInRemark',
		flex:1,
		hidden:true,
		renderer: function(value,record){
			if(!isNullOrEmpty(value)){
				record.tdAttr = 'data-qtip="' + Ext.htmlEncode(value) + '"';
				record.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 6;-webkit-box-orient: vertical;line-height: 15px;max-height: 103px;';
	    		return value;
			}
		}
	},{
		header : getHostelTranslation('FINANCIAL_CHECK_IN_DATE'),
		dataIndex : 'financialCheckInDate',
		flex:1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header : getHostelTranslation('FINANCIAL_EXPECTED_CHECK_OUT_DATE'),
		dataIndex : 'financialExpectedCheckOutDate',
		flex:1,
		renderer: function(date) {
			return dateRender(date);
		}
	},{
		header : getHostelTranslation('AMOUNT_TO_BE_PAID'),
		dataIndex : 'amountToBePaid',
		flex:1
	},{
		header : getHostelTranslation('NUMBER_OF_DAYS'),
		dataIndex : 'numberOfDays',
		flex:1
	},{
		header : getHostelTranslation('FINANCIAL_ACTUAL_CHECK_OUT_DATE'),
		dataIndex : 'financialActualCheckOutDate',
		flex:1,
		renderer: function(date) {
			return dateRender(date);
		}
	},
	/*,{
		header : getHostelTranslation('STATUS'),
		dataIndex : 'status',
		flex : 1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'ACTIVE' || value == 'Active'){
					return '<span style="color:green;">' + getHostelTranslation('ACTIVE') + '</span>';
				}else{
					return '<span style="color:red;">' + getHostelTranslation('IN_ACTIVE') + '</span>';
				} 
			}
		}
	}*/]
});