/**
 * @author Dharmendra.p
 */
Ext.define('Academia.view.hostel.managehostel.ManageHostelSearch', {   
	extend : 'Ext.form.FormPanel',
	alias : 'widget.managehostelsearch',
	autoScroll: false,
	frame: false,
	cls:'customSearchPanel',
	method : 'POST',
	standardSubmit : false,
	plugins : "formlabelrequired",
	items: [{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			items:[{
				xtype : 'radiogroup',
				itemId:'hostelType',
				labelAlign : 'top',
				defaults: {
					flex: 1
				},
				items : [{
					boxLabel : getHostelTranslation('HOSTEL'),
					name : 'hostelType',
					inputValue : 'HOSTEL',
					checked : true
				},{
					boxLabel : getHostelTranslation('BUILDING'),
					name : 'hostelType',
					inputValue : 'BUILDING'

				},{
					boxLabel : getHostelTranslation('FLOOR'),
					name : 'hostelType',
					inputValue : 'FLOOR'
				},{
					boxLabel : getHostelTranslation('ROOM'),
					name : 'hostelType',
					inputValue : 'ROOM'
				}]
			}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype: 'customcombobox',
				name: 'hostelCodeName',
				itemId: 'hostelCodeName',
				fieldLabel: getHostelTranslation('HOSTEL_CODE_NAME'),
				store:'hostel.managehostel.hostel.HostelCodeName',
				displayField:'value',
				valueField:'id',
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'buildingCodeName',
				itemId: 'buildingCodeName',
				fieldLabel: getHostelTranslation('BUILDING_CODE_NAME'),
				store:'hostel.managehostel.building.BuildingCodeName',
				displayField:'value',
				valueField:'id',
				hidden:true,
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'status',
				itemId:'statusId',
				fieldLabel: getHostelTranslation('STATUS'),
				store: 'scholarships.Status',
				valueField: 'id',
				displayField: 'Status',
				forceSelection:true,
	            editable: false
			}]
		},{	
			xtype:'fieldcontainer',
			width: '100%',
			layout : 'hbox',
			defaults: {
				labelAlign:'top',
				width:226
			},
			items:[{
				xtype: 'customcombobox',
				name: 'floorCodeNo',
				itemId: 'floorCodeNo',
				fieldLabel: getHostelTranslation('FLOOR_CODE_NO'),
				store:'hostel.managehostel.floor.FloorCodeName',
				displayField:'value',
				valueField:'id',
				hidden:true,
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'roomType',
				itemId: 'roomType',
				fieldLabel: getHostelTranslation('ROOM_TYPE'),
				store:'hostel.manageroomtype.RoomType',
				displayField:'roomType',
				valueField:'id',
				hidden:true,
				typeAhead:true,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				name: 'roomNo',
				itemId: 'roomNo',
				fieldLabel: getHostelTranslation('ROOM_NO'),
				store:'hostel.managehostel.floor.RoomCodeName',
				displayField:'value',
				valueField:'id',
				hidden:true,
				typeAhead:true,
				forceSelection:true
			}]
		},{
			xtype: 'fieldcontainer',
			width: '100%',
			items:[{  
				xtype: 'button',
				itemId: 'searchBtn',
				text: getCommonTranslation('SEARCH'),
				ui:'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				itemId: 'resetBtn',
				text: getCommonTranslation('RESET'),
				ui:'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE
			}]	
		}]
	});
