/**
 * Dharmendra.p 
 */
Ext.define('Academia.view.hostel.managehostel.floor.EditFloorDetails',{
	extend : 'Ext.form.FormPanel',
	alias : 'widget.editfloordetails',
	autoScroll : true,
	frame:true,
	modal : true,
	title : getHostelTranslation('EDIT_FLOOR_DETAILS'),
	method : 'POST',
	standardSubmit : false,
	plugins : "formlabelrequired",
	style:{
    	marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
    },
	items : [{
		xtype:'hidden',
		name:'id'
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'textfield',
			itemId:'hostelCodeName',
			name : 'hostelCodeName',
			fieldLabel : getHostelTranslation('HOSTEL_CODE_NAME'),
 			readOnly : true
		},{
			xtype : 'textfield',
			itemId:'buildingCodeName',
			name : 'buildingCodeName',
			fieldLabel : getHostelTranslation('BUILDING_CODE_NAME'),
 			readOnly : true
		
		},{
			xtype : 'textfield',
			itemId:'floorNumber',
			name : 'floorNumber',
			fieldLabel : getHostelTranslation('FLOOR_NO')
		
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 226,
			labelAlign : 'top'
		},
		items : [{
			xtype : 'textfield',
			itemId: 'noOfRooms',
			name : 'noOfRooms',
			readOnly:true,
			fieldLabel : getHostelTranslation('NO_OF_ROOMS')
		},{
			xtype : 'customcombobox',
			name : 'restrictionType',
			itemId : 'restrictionType',
			fieldLabel : getHostelTranslation('RESTRICTION_TYPE'),
			store : 'hostel.managehostel.hostel.RestrictionType',
			valueField : 'id',
			displayField : 'value',
			editable : false
			},{
				xtype : 'customcombobox',
				name : 'status',
				fieldLabel : getHostelTranslation('STATUS'),
				store:'scholarships.Status',
				valueField : 'id',
				displayField : 'Status',
				editable : false,
	            selectOnFocus: true,
	            forceSelection: false,
//	            allowBlank:false
	            
			}]
	},{
            xtype: 'fieldcontainer',
            labelAlign: 'top',
            layout: {
                type: 'hbox'
            },
            defaults: {
                labelAlign: 'top',
                width: 452
            },
            items: [ {
                xtype: 'textarea',
                fieldLabel: getHostelTranslation('REMARKS'), 
                name: 'remarks',
                itemId: 'remarks'
    		}]
        },{
		xtype:'fieldcontainer',
		width:'100%',
		layout : {
			type : 'hbox'
		},
		items : [{
			xtype : 'button',
			text : getCommonTranslation('SAVE'),
			itemId : 'saveBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}/*,{
			xtype : 'button',
			text : getCommonTranslation('CANCEL'),
			itemId : 'cancelBtn',
			ui : 'CustomBtnCancel',
			scale : CONSTANTS.BUTTONSIZE
		}*/]
	} ]
});