/**
 * Dharmendra.p
 */
Ext.define('Academia.view.hostel.managehostel.floor.RoomCountList', {
	extend: 'Ext.grid.Panel',
    alias : 'widget.roomcountlist',
    store : 'hostel.managehostel.floor.RoomCountList',
    border: true,
    viewConfig : {
    	stripeRows : CONSTANTS.STRIPEROWS
    },
    dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.managehostel.floor.RoomCountList',
			emptyMsg :getHostelTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
    columns : [{
		header :getHostelTranslation('ROOM_NO'),
		dataIndex : 'code',
		flex:1
	},{
		header : getHostelTranslation('TOTAL_NO_OF_BEDS'),
		dataIndex : 'count',
		flex:1
	},{
		header : getHostelTranslation('AVAILABLE_BEDS'),
		dataIndex : 'availableBeds',
		flex:1
	},{
		header : getHostelTranslation('STATUS'),
		dataIndex : 'status',
		flex:1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'ACTIVE' || value == 'Active'){
					return '<span style="color:green;">' + getHostelTranslation('ACTIVE') + '</span>';
				}else{
					return '<span style="color:red;">' + getHostelTranslation('IN_ACTIVE') + '</span>';
				} 
			}
		}
		
	}]
});
