
Ext.define('Academia.view.hostel.managehostel.hostel.NoOfBuildingsGrid', {
	extend: 'Ext.grid.Panel',
    alias : 'widget.noofbuildingsgrid',
    store : 'hostel.managehostel.hostel.NoOfBuildingsGrid',
    border: true,
    viewConfig : {
    	stripeRows : CONSTANTS.STRIPEROWS
    },
    dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hostel.managehostel.hostel.NoOfBuildingsGrid',
			emptyMsg :getHostelTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
    columns : [{
		header :getHostelTranslation('BUILDING_CODE'),
		dataIndex : 'code',
		flex:1
	},{
		header : getHostelTranslation('BUILDING_NAME'),
		dataIndex : 'name',
		flex:1
	},{
		header : getHostelTranslation('TOTAL_FLOORS'),
		dataIndex : 'count',
		flex:1
	},{
		header : getHostelTranslation('STATUS'),
		dataIndex : 'status',
		flex:1,
		renderer:function(value){
			if (!isNullOrEmpty(value)) {
				if(value == 'ACTIVE' || value == 'Active'){
					return '<span style="color:green;">' + getHostelTranslation('ACTIVE') + '</span>';
				}else{
					return '<span style="color:red;">' + getHostelTranslation('IN_ACTIVE') + '</span>';
				} 
			}
		}
	}]
});
