/**
 * @author Priyanshi Sharma
 */
Ext.define('Academia.view.hostel.manageroomtype.ChargeableNonChargeableDaysScheduleGrid', {
	extend: 'Ext.grid.Panel',
	alias: 'widget.chargeablenonchargeabledaysschedulegrid',
	store: 'hostel.manageroomtype.ChargeableNonChargeableDaysScheduleAddGridStore',
	title: getHostelTranslation("CHARGEABLE_NON_CHARGEABLE_DAY_SCHEDULE"),
	border: true,
	frame:false,
	refreshStoreData:true,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getHostelTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getHostelTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'button',
		itemId: 'copyScheduleFrom',
		cls: 'CustomBodyBtnSettings',
		text: getHostelTranslation('COPY_SCHEDULE_FROM'),
		tooltip: getHostelTranslation("COPY_SCHEDULE_FROM"),
	}],
	columns: [{
		header:  getHostelTranslation("DATE"),
		dataIndex:'date',
		flex:.1,
		sortable:true,
		renderer: function(value, metadata, record) {
			return dateRender(value);
		}
	},{
		header:  getHostelTranslation("DAY"),
		dataIndex:'day',
		flex:.1,
		sortable:true
	},{
		header:  getHostelTranslation("PER_DAY_TARIFF"),
		dataIndex: 'perDayTariff',
		flex:.1,
		sortable:true,
	}]
});
