/**
 * @author Amit Gupta
 */
var booleanValue=null;
Ext.define('Academia.view.hrRecruitmentProcess.jobPosting.JobPostingSetupConfigureScreenGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.jobpostingsetupconfigurescreengrid',
	store : 'hrRecruitmentProcess.jobPosting.JobPostingSetupConfigureScreenStore',
	border: true,
	autoScroll: false,
	selType:'checkboxmodel',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	selModel: {
		showHeaderCheckbox: true,
		checkOnly : true,
		allowDeselect: false,
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnSaveJobPosting',
		text:'Save',
	}],
	columns : [{
		header : getCommonTranslation('SCREENNAME'),
		dataIndex : 'screenName',
		flex:1
	},{
		header : getCommonTranslation('SCREENMODE'),
		dataIndex : 'screenMode',
		flex:1
	},{
		header : getCommonTranslation('FIELD_DISPLAY_NAME'),
		dataIndex : 'fieldDisplayName',
		flex:1
	},{
		header : getCommonTranslation('DEFAULT_LABEL'),
		dataIndex : 'defaultLabel',
		flex:1
	},{

		header : getCommonTranslation('FIELD_TYPE'),
		dataIndex : 'fieldType',
		flex:1
	},{
		header : getCommonTranslation('IS_FORM_LOCKED'),
		dataIndex : 'isFieldLocked',
		flex:1,
		renderer: function (value) {
			if(value == true){
				return value = getCommonTranslation('GRID_FIELD_LOCKED');
			}else{
				return value = getCommonTranslation('GRID_FIELD_UNLOCKED');
			}
		}
	},{
		header : getCommonTranslation('FIELD_MAND_OPTIONAL'),
		dataIndex : 'isMandatory',
		flex:1,
		editor : {
			xtype: 'customcombobox',
			name:'fieldMandatoryAP',
			store:Ext.create('Academia.store.dynamicformrendering.configurescreen.OptionalMandatoryStore'),
			valueField : 'id',
			displayField : 'value',
			editable: false,
			listeners: {
				focus: function(combo, eOpt) {
					if(combo.getValue() == true || combo.getValue() == 'true') {
						combo.setRawValue(getCommonTranslation("GRID_FIELD_MANDATORY"));
					}else{
						combo.setRawValue(getCommonTranslation("GRID_FIELD_OPTIONAL"));
					}
				},
				/* blur: function(combo, r) {
                    combo.setValue(combo.getValue());
                },*/
				render: function(combo) {
					combo.getStore().load();
				},
				/*change: function(combo, eOpt) {
                	 if(combo.getValue() == true || combo.getValue() == 'true') {
         				combo.setValue(getCommonTranslation("GRID_FIELD_MANDATORY"));
         			}else{
         				combo.setValue(getCommonTranslation("GRID_FIELD_OPTIONAL"));
         			}
                }*/
			}
		},
		renderer: function (value) {
			if(value == true || value == 'true') {
				return getCommonTranslation('GRID_FIELD_MANDATORY');
			}else{
				return getCommonTranslation('GRID_FIELD_OPTIONAL');
			}
		}
	},{
		header : getCommonTranslation('FIELD_VISIBILITY'),
		dataIndex : 'isVisible',
		flex:1,
		editor : {
			xtype: 'customcombobox',
			name:'fieldVisibilityAP',
			store:Ext.create('Academia.store.common.YesNoDynamicFormCombo'),
			valueField : 'name',
			displayField : 'value',
			editable: false,
			/*listeners:{
		    	beforeactivate:function(obj){
		    		console.log('in before active');
		    		obj.setValue(booleanValue);
		    	}
		    }*/
		},
		/*renderer: function (value) {
			    if(value == 'false' || value == false){
			    	return 'No';
			    }else if(value == null || value == 'true' || value == true ){
			    	return 'Yes';
			    }
			}*/
	},{
		header : getCommonTranslation('NEW_LABEL_NAME'),
		dataIndex : 'newLabel',
		flex:1,
		editor : {
			xtype: 'textfield',
			itemId:'newLableNameId',
			name:'newLableName'
		}
	/*renderer:function(value,metaData){
			  if(isNullOrEmpty(value)){
				 return metaData.record.data.defaultLabel;
			  }else{
				  return value;
			  }
			  if(isNullOrEmpty(value)){
				  meta.tdCls='gridInputCustomStyle';
				  return getExaminationTranslation('CLICK_TO_ENTER');
			  }else{
				  return value;
			  }
		  }*/
	},{
		header : getCommonTranslation('HELP_TEXT'),
		dataIndex : 'helpText',
		flex:1,
		renderer: function (value,metaData) {
			//if(value==null|| value==undefined || value==""){
			//if(metaData.record.data.isFieldLocked){
			return '<a href="#">'+getCommonTranslation('HELP_TEXT')+'</a>';				
			//}
			//}else{
			//return value;
			//}

		}
	},{
		header : getCommonTranslation('DEF_VALUE'),
		dataIndex : 'defaultValue',
		flex:1,
		editor : {
			xtype: 'textfield',
			itemId:'defaultValueId',
			name:'defaultValue'
		}
	}],
	plugins: [{
		ptype : 'cellediting',
		clicksToEdit: 1,
		listeners:{
			edit:function(editor, context){
				context.column.field.setValue('true');
			},
			beforeedit: function(editor, context){
				var rowData=context.record.data;
				/*if(context.field == 'newLabel'){
             		if(!rowData.isFieldLocked){
             			return false;
             		}
             	}*/
				if(context.field == 'isVisible'){
					//booleanValue='Yes';
					if(rowData.isFieldLocked){
						return false;
					}
				}

				if(context.field == 'defaultValue'){
					if(rowData.isFieldLocked){
						return false;
					}
				}

				if(context.field == 'isMandatory'){
					if(rowData.isFieldLocked || (rowData.fieldType == 'checkbox' 
						|| rowData.fieldType == 'checkboxfield' 
							|| rowData.fieldType == 'radiogroup' 
								|| rowData.fieldType == 'radiofield' 
									|| (rowData.fieldType == 'fieldcontainer' && context.store.data.items[0].data.screenName != "Student Enquiry Details" && context.store.data.items[0].data.screenName != "Manage Enquiry") 
									|| rowData.fieldType == 'fieldset' 
										|| (rowData.fieldType == 'filefield' && context.store.data.items[0].data.screenName != "Applicant Details") 
										|| rowData.fieldType == 'button')
										|| rowData.isDefaultMandatory) {   
						return false;
					}
				}
			}         
		}
	}]
});
