/**
 * @ author Kamini Birla
*/
Ext.define('Academia.view.hrm.ICAttendanceAndPaymentReport.ICAttendanceAndPaymentDetailedReportGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.icattendanceandpaymentdetailedreportgrid',
	store: 'hrm.report.ICAttendanceAndPaymentDetailedReportGridStore',
	title: getCommonTranslation('IC_ATTENDANCE_AND_PAYMENT_DETAILED_REPORT'),
	border: true,
	frame:false,
	isGridConfigurable: true,
	enableColumnHide: false,
	viewConfig: {    
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'hrm.report.ICAttendanceAndPaymentDetailedReportGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	columns: [{
		header : getCommonTranslation('EMPLOYEE_NUMBER'),
		dataIndex : 'employeeId',
		flex : 1
	},
	{
		header : getCommonTranslation('EMPLOYEE_FIRST_NAME'),
		dataIndex : 'empFirstName',
		flex : 1
	},
	{
		header : getCommonTranslation('EMPLOYEE_SURNAME'),
		dataIndex : 'empSurName',
		flex : 1
	},{
		header : getCommonTranslation('NAME_SURNAME'),
		dataIndex : 'empFullName',
		flex : 1
	},{
		header : getCommonTranslation('EMAIL_ADDRESS'),
		dataIndex : 'emailAddress',
		flex : 1
	},{
		header : getCommonTranslation('COMPONENT_DESCRIPTION'),
		dataIndex : 'componentDescription',
		flex : 1
	},{
		header : getCommonTranslation('INPUT_TYPE'),
		dataIndex : 'inputType',
		flex : 1
	},{
		header : getCommonTranslation('MONTH'),
		dataIndex : 'month',
		flex:1
	},{
		header : getCommonTranslation('DATE'),
		dataIndex : 'date',
		flex:1,
	   renderer: function (value) {
		        if (!value) return '';
		        return Ext.Date.format(new Date(value), 'd/m/Y');
	   }
	},{
		header : getCommonTranslation('SESSION_START'),
		dataIndex : 'sessionStart',
		flex:1,
		renderer: function (value) {
	        if (!value) return '';
	        if (Ext.isNumber(value)) {
	            return Ext.Date.format(new Date(value), 'h:i:s A');
	        }
	        return value;
	    }
	},{
		header : getCommonTranslation('SESSION_END'),
		dataIndex : 'sessionEnd',
		flex : 1,
		renderer: function (value) {
	        if (!value) return '';
	        if (Ext.isNumber(value)) {
	            return Ext.Date.format(new Date(value), 'h:i:s A');
	        }
	        return value;
	    }
	},{
		header : getCommonTranslation('INPUT_VALUE'),
		dataIndex : 'inputValue',
		flex : 1
	},{
		header : getCommonTranslation('PAY_RATE'),
		dataIndex : 'payRate',
		flex : 1
	},{
		header : getCommonTranslation('MODULE_SERVICE'),
		dataIndex : 'moduleService',
		flex : 1
	},{
		header : getCommonTranslation('TOTAL_PAYMENT'),
		dataIndex : 'totalPayment',
		flex : 1
	},{
		header : getCommonTranslation('COST_CENTER'),
		dataIndex : 'costCenter',
		flex : 1
	},{
		header : getCommonTranslation('MAX_DAILY_HOURS'),
		dataIndex : 'maxDailyHours',
		flex : 1
	},{
		header : getCommonTranslation('CAP_REACHED'),
		dataIndex : 'capReached',
		flex : 1
	}]
});
