/**
 * @author Kamini Birla
 */
Ext.define('Academia.view.hrm.ICAttendanceAndPaymentReport.ICAttendanceAndPaymentReportFilter',{
	extend:'Ext.form.FormPanel',
	alias:'widget.icattendanceandpaymentreportfilter',
	autoScroll:false,
	frame:false,
	standardSubmit:false,
	cls:'customSearchPanel',
	layout: 'vbox',
	plugins:"formlabelrequired",
	items:[{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:226
			},
			items:[{
					xtype : 'customcombobox',
					fieldLabel : getCommonTranslation('REPORT_TYPE'),		
					name : 'reportType',
					itemId : 'reportTypeId',
					displayField : 'value',
					valueField : 'id',
					store : 'common.ReportTypeStore',
					typeAhead : true,
					width : 234,
					forceSelection : true,
					allowBlank: true,
					hidden : false
				},{
					xtype: 'multiselectcombofield',
					name: 'month',
					itemId:'monthId',
					fieldLabel: getCommonTranslation('MONTH'),
					store:'common.MonthStore',
					valueField: 'value',
					displayField: 'value',
					queryParam:'searchQuery',
					minChars:3,
					width : 234,
					typeAhead:true,
					enableKeyEvents  : 'true',
					hideTrigger:false,
					cls:'commonAutoHeightMultiselectField',
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND')
					}
				},{
					xtype: 'multiselectcombofield',
					name: 'module',
					itemId:'moduleId',
					fieldLabel: getCommonTranslation('MODULE_SERVICE'),
					store:'common.ModuleAndServiceStore',
					valueField: 'value',
					displayField: 'value',
					queryParam:'searchQuery',
					minChars:3,
					width : 234,
					typeAhead:true,
					enableKeyEvents  : 'true',
					hideTrigger:false,
					cls:'commonAutoHeightMultiselectField',
					forceSelection:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
					listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
						loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND')
					}
				}]
		
		},{
			xtype:'fieldcontainer',
			width:'100%',
			layout:'hbox',
			defaults:{
				labelAlign:'top',
				width:226	
			},
			items:[{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('EMPLOYEE_NUMBER'),		
				name : 'employeeId',
				itemId : 'employeeId',
				store:'common.UserShortNameStore',
				displayField : 'value',
				valueField : 'value',
				width : 234,
				typeAhead : true,
				forceSelection : true,
				allowBlank: true,
				hidden : false
			},{
				xtype : 'customcombobox',
				fieldLabel : getCommonTranslation('NAME_SURNAME'),		
				name : 'name',
				itemId : 'name',
				displayField : 'value',
				valueField : 'id',
				width : 234,
				typeAhead : true,
				forceSelection : true,
				allowBlank: true,
				hidden : false
			},{
				xtype: 'multiselectcombofield',
				name: 'costCenter',
				itemId:'costCenterId',
				fieldLabel: getCommonTranslation('COST_CENTER'),
				store:'common.CostCenterStore',
				valueField: 'id',
				displayField: 'value',
				queryParam:'searchQuery',
				minChars:3,
				width : 234,
				typeAhead:true,
				enableKeyEvents  : 'true',
				hideTrigger:false,
				cls:'commonAutoHeightMultiselectField',
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND')
				}
			}]
		},{
			xtype : 'fieldcontainer',
			width : 'auto',
			cls : 'windowBtnPos',
			items: [{
				xtype: 'button',
				text: getCommonTranslation('SEARCH'),
				itemId: 'searchBtn',
				buttonAlign: 'left',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind : true
			},{
				xtype: 'button',
				text: getCommonTranslation('RESET'),
				itemId: 'resetBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE   
			}]	
		}]
});