/**
 */
Ext.define('Academia.view.hrm.employeePortal.HRMMyPunchLogGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.hrmmypunchloggrid',
    store: 'hrm.report.HRMAttendancePunchLogReportGridStore',
    title: getPersonModuleTranslation('HRM_PUNCH_LOG_REPORT'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    dockedItems: [{
        itemId: 'dockedItemsItemId',
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'hrm.report.HRMAttendancePunchLogReportGridStore',
            emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
            displayInfo: true
        }]
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    columns: [{
        header: getCommonTranslation('DATE'),
        dataIndex: 'punchDate',
        flex: 1,
        sortable: true,
        renderer:function(value){
        	if(!isNullOrEmpty(value)){
        		return dateRender(value);
        	}
        	else{
        		return '';
        	}
        }
    }, {
        header: getCommonTranslation('DAY'),
        dataIndex: 'punchDay',
        flex: 1
    }, {
        header: getPersonModuleTranslation('HRM_PUNCH_LOG_TIME'),
        dataIndex: 'punchTime',
        flex: 1,
        renderer:function(value){
        	if(!isNullOrEmpty(value)){
        		return timeRender(value);
        	}
        	else{
        		return '';
        	}
        }
    }],
});