/**
 * @author Deepak Sharma
 */
Ext.define('Academia.view.leavemanagement.leavegeneralsetting.LeaveCombinationGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.leavecombinationgrid',
    store: 'leavemanagement.leavegeneralsetting.LeaveCombinationStore',
    title: getPersonModuleTranslation('LEAVE_GENERAL_SETTING_ENTRY_TABLE'),
    border: true,
    autoScroll: false,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        deferEmptyText: false,
        markDirty:false,
		emptyText: getCommonTranslation('NORESULTSNMESSAGE')
    },
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	},{
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
    columns: [{
        header: getPersonModuleTranslation('LEAVE_GENERAL_SETTING_SERIAL_NO'),
        dataIndex: 'serialNo',
        flex: 0.4,
        sortable: true
    }, {
        header: getPersonModuleTranslation('LMAS_LEAVE_TYPE'),
        dataIndex: 'leaveTypeName',
        flex: 0.7,
        sortable: true
    },{
        header: getPersonModuleTranslation('LEAVE_GENERAL_SETTING_COMBINE_WITH'),
        dataIndex: 'leaveCombineWith',
        flex: 0.7,
        sortable: true
    }]
});
