/**
 * Student List Bulk Reset Password Form
 * @author vidhi.shah
 */
Ext.define('Academia.view.login.StudentBulkResetPasswordWindow', {
	extend : 'Ext.window.Window',
	alias : 'widget.studentbulkresetpasswordwindow',
	title:getCommonTranslation('RESET_PASSWORD'),
	modal: true,
	width: 620,
    height: 515,
    autoScroll:true,
    resizable: true,
	items : [{
		xtype : 'form',
		height: 'auto',
		standardSubmit: false,
	    plugins: "formlabelrequired",
	    defaults:{
			labelAlign: 'top',
			width: 260
		},
	items : [{
		xtype:'hidden',
		name: 'resetPasswordFilterdata',
		ItemId:'resetPasswordFilterdataItemId'
	},{
		xtype:'hidden',
		name: 'isForAll',
		ItemId:'isForAllItemId'
	},{
		xtype:'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 260,
			labelAlign: 'top'
		},
        items : [{
        	xtype: 'customcombobox',
        	fieldLabel: getAdmissionTranslation('ACADEMY_LOCATION'),
        	name: 'ACAD_LOC_ID',
        	itemId:'academyLocationCombo',
        	allowBlank: false,
        	store: 'user.UserAcademyLocationStore',
        	displayField: 'value',
        	valueField: 'id',
        	typeAhead : false,
        	forceSelection:true,
        	queryParam: 'qry',
        	minChars:3,
        	width: 260,
        	emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
        	listConfig: {
			  listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
                loadingText: getCommonTranslation('SEARCHING'),
                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
                getInnerTpl: function() {
                    	return '<div class="search-item">' +
                    	'{value}'  +
                    '</div>';
                }
        	}
        },{
			xtype: 'multiselectcombofield',
			name: 'PROGRAM',
			width: 260,
			itemId: 'program',
			fieldLabel: getAdmissionTranslation('PROGRAM'),
			store:Ext.create('Academia.store.program.ProgramByGroupIdStore'),
			displayField:'valueCode',
			valueField:'id',
			allowBlank: false,
			disabled:true,
			typeAhead:true,
			forceSelection:true,
			autoloadStore: false,
			hidden : false,
			cls:'resetPasswordMultiselect',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
        	}]
	},{
		xtype:'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 260,
			labelAlign: 'top'
		},
        items : [{
			xtype: 'multiselectcombofield',
			name: 'BATCH',
			width: 260,
			itemId: 'batch',
			fieldLabel: getAdmissionTranslation('BATCH'),
			store: Ext.create('Academia.store.common.BatchesByProgramId'),
			displayField:'value',
			valueField:'id',
			allowBlank: false,
			typeAhead:true,
			forceSelection:true,
			autoloadStore: false,
			disabled:true,
			hidden : false,
			cls:'resetPasswordMultiselect'
        	},{
        	xtype: 'multiselectcombofield',
			name: 'PERIOD_NAME',
			width: 260,
			itemId: 'period',
			fieldLabel:  getPersonModuleTranslation('PERIOD'),
			store: Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.ProgramCoursePeriod'),
			displayField:'value',
			valueField:'id',
			typeAhead:true,
			forceSelection:true,
			autoloadStore: false,
			allowBlank: false,
			disabled:true,
			hidden : false,
			cls:'resetPasswordMultiselect'
		}]
    },{
    	xtype:'fieldcontainer',
		width: 'auto',
		layout: 'hbox',
		defaults: {
			width: 260,
			labelAlign: 'top',
		},
		style: {
    		marginTop: '20px',
    	},
        items : [{
	    	xtype: 'radiogroup',
	    	itemId: 'passwordTypeItemId',
	    	width: 550,
	    	defaults: {
	    		flex: .1
	    	},
	    	items: [{
	    		boxLabel: getCommonTranslation('COMMON_PASSWORD'),
	    		name: 'passwordType',
	    		inputValue: true,
	    		checked: true
	    	},{
	    		boxLabel: getCommonTranslation('RANDOM_PASSWORD'),
	    		name: 'passwordType',
	    		inputValue: false
	    	}]
        }]
    },{
    	xtype:'fieldcontainer',
		width: 'auto',
		layout: 'vbox',
		defaults: {
			width: 260,
			labelAlign: 'top'
		},
		style: {
    		marginTop: '20px',
    	},
        items : [{
		    xtype : 'textfield',
		    allowBlank: false,
		    inputType : 'password',
		    name: 'resetPassword',
		    itemId: 'resetPassword',
		    invalidCls:Ext.baseCSSPrefix + 'form-invalid',
	   	    msgTarget:'under',
		    fieldLabel : getCommonTranslation('NEW_PASSWORD')
        },{
		    xtype : 'textfield',
		    allowBlank: false,
		    inputType : 'password',
		    name: 'confirmedPassword',
		    itemId : 'confirmedPassword',
		    fieldLabel : getCommonTranslation('CONFIRM_PASSWORD'),
		    vtype: 'passwordAndPolicyMatch',
		    initialPassField: 'resetPassword'
        }]
	},{
    	xtype:'fieldcontainer',
    	style: {
    		marginTop: '10px',
    	},
        items: [{
				xtype: 'button',
				formBind: true,
				text : getCommonTranslation('SUBMIT'),
				itemId: 'submitBtn',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE    			
        	},{
				xtype: 'button',				
				text : getCommonTranslation('CANCEL'),
				itemId: 'cancelBtn',
				ui: 'CustomBtnCancel',
				scale: CONSTANTS.BUTTONSIZE				
        	}]
		},{
			xtype:'fieldcontainer',
	        items : [{
				xtype : 'fieldset',
				collapsible : true,
				collapsed : true,
				title : getCommonTranslation('PASSWORD_POLICY'),
				titleCollapse : true,
				defaults : {
					labelAlign : 'top',
					width : 260
				},
				style : {
					marginTop : '40px!important',
				},
				items : [ {
					xtype : 'dataview',
					itemId : 'passwordPolicyTemplate',
					tpl : new Ext.XTemplate('<tpl></tpl>')
				}, {
					xtype : 'displayfield',
					height : 30
				} ]
			}]
		}]
    }]
});
