/**
 * @author Deepak.Nigam
 */
Ext.define('Academia.view.manageDetention.MappedEventGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.mappedeventgrid',
    store : 'manageDetention.DetentionMappedEventStore',
    title : getExaminationTranslation('MAPPED_EVENTS'),
    border: true,
    frame:false,
	selType:'checkboxmodel',
    viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	 dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [ {
	    	    xtype : 'custompagingtoolbar',
	    	    plugins:['pagesize'],
	    	    store :  'manageDetention.DetentionMappedEventStore',
	    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	    displayInfo : true
	    	} ]
	}],
	initComponent: function() {

		var grid=this;                   
		grid.scrollable = true;
		grid.height = 450;
		grid.cls = 'sticky-grid-header';
		grid.addExportToolBarItems(grid);

		this.callParent(arguments);     

	},
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    },/* {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    },{
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('ADD'),
        iconCls: 'view-icon'
    }, */{
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }/*,{
	 	xtype : 'splitbutton',
        itemId:'spBtnMoreActions',
        text : getCommonTranslation('MOREACTIONS'),
        menu:[{
            text:getExaminationTranslation('APPLY_TO'),
            itemId:'applyToBtn'
        },{
			text:getExaminationTranslation('DETAIN_STUDENT'),
			itemId:'detainStudentBtn'
		}]
    }*/],
    columns: [{
		  	header : getExaminationTranslation('PROGRAM'),
		  	dataIndex : 'programName',
		  	flex:1
       },{
            header : getExaminationTranslation('BATCH'),
	        dataIndex : 'batchName', 
	        flex:1
       },{
            header : getExaminationTranslation('PERIOD'),
	        dataIndex : 'periodName',
	        flex:1
	    },{
		  	header : getExaminationTranslation('COURSE_VARIANT'),
		  	dataIndex : 'courseVariantName',
		  	flex:1
       },{
		  	header : getExaminationTranslation('DETAILED_SEQUENCE'),
		  	dataIndex : 'eventName',
		  	flex:1
       }]
});