/**
 * @author Harshit patidar
 */
Ext.define('Academia.view.managetarget.ManageTargetByStaffApplicationForecastGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.managetargetbystaffapplicationforecastgrid',
    store: 'managetarget.ManageTargetByStaffApplicationForecastGridStore',
    title: getCommonTranslation('APPLICATION_FORECAST_TARGET'),
    border: true,
    autoScroll: false,
    refreshStoreData:true,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    features: [{
        ftype: 'summary',
        showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
    }],
    tbar: [{
		xtype: 'fieldcontainer',
		width: 'auto',
		items: [{
			xtype: 'button',
			text: getTransportTranslation('SAVE'),
			itemId: 'SaveBtn',
			ui: 'CustomBtnSubmit',
			disabled:true,
			scale: CONSTANTS.BUTTONSIZE
		}]
	},'->'],
    headerFix:{
        headerFix: true,
        portalIdsWithStructure: {
            'managetargetbystafftabstructure':1
        }
    },
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid, false);
        this.callParent(arguments);
    },
    columns: [{
        header: getCommonTranslation('ACADEMY'),
        dataIndex: 'academyName',
        flex: 1,
        sortable: true
    },{
        header: getCommonTranslation('LOCATION'),
        dataIndex: 'locationName',
        flex: 1,
        sortable: true
    },{
        header: getCommonTranslation('INTAKE_YEAR'),
        dataIndex: 'intakeYearName',
        flex: 1,
        sortable: true,
    },{
		header:  getCommonTranslation('MODE_OF_DELIVERY'),
		dataIndex: 'modeOfDeliveryValue',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('REGISTRATION_TYPE'),
		dataIndex: 'registrationTypeValue',
		flex:1,
		sortable:true,
	}, {
        header: getCommonTranslation('OFFER_STATUS'),
        dataIndex: 'currentStatus',
        flex: 1,
        sortable: true
    },{
		header:  getCommonTranslation('PROGRAM_GROUP'),
		dataIndex: 'programGroupName',
		flex:1,
		sortable:true
	}, {
        header: getCommonTranslation('CONV_FORECAST_PROGRAM_GROUP'),
        dataIndex: 'convForecastProgramGroup',
        flex: 1,
        sortable: true,
        summaryType: 'sum',
        editor: {
            xtype: 'textfield',
            name: 'forecastProgramGrp',
            itemId: 'forecastProgramGrpId',
            maxLength:4,
            hideTrigger: true,
            keyNavEnabled: false,
            mouseWheelEnabled: false,
            regex: /^(0|[1-9][0-9]?|100)%$/,

        },
        renderer: function(val, rec) {
            if (isNullOrEmpty(val)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                return val;
            }
        }
    }, {
        header: getCommonTranslation('FORECAST_REGS'),
        dataIndex: 'forecastRegs',
        flex: 1,
        sortable: true,
        summaryType: 'sum',
        editor: {
            xtype: 'numberfield',
            name: 'forecastRegs',
            itemId: 'forecastRegsId',
            maxLength: 5,
            minValue:0,
            maxValue:99999,
            enforceMaxLength: true,
            hideTrigger: true,
            keyNavEnabled: false,
            mouseWheelEnabled: false,
            allowExponential: false,
            allowDecimals: false,
            
        },
        renderer: function(val, rec) {
            if (isNullOrEmpty(val)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                return val;
            }
        }
    }],
    plugins: [{
        ptype: 'cellediting',
        clicksToEdit: 1,
        listeners: {
            beforeedit: function(obj, editor, context) {
                return true;
            }
        }
    }]
});
var cellEditing = Ext.create('Ext.grid.plugin.CellEditing', {
    clicksToEdit: 1,
    listeners: {
        beforeedit: function(editor, context, e) {}
    }
});
