/**
 * @author Bhartendu Bhaskar
 * 
 */
Ext.define('Academia.view.managetarget.ManageTargetFilter', {
    extend: 'Ext.form.Panel',
    alias: 'widget.managetargetfilter',
    autoScroll: false,
    frame: false,
    cls: 'customSearchPanel',
    method: 'POST',
    standardSubmit: false,
    plugins: "formlabelrequired",
    items: [{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [ {
                xtype: 'customcombobox',
                name: ' viewTargetBy',
                itemId: 'viewTargetBy',
                fieldLabel: getCommonTranslation('VIEW_TARGETS_BY'),
                store: Ext.create('Academia.store.managetarget.ViewTargetByStore'),
                valueField: 'id',
                displayField: 'value',
                allowBlank: false,
                editable: false,
            },{
                xtype: 'customcombobox',
                name: 'intakeYearId',
                itemId: 'intakeYearItemId',
                fieldLabel: getCommonTranslation('INTAKE_YEAR'),
                store: Ext.create('Academia.store.common.IntakeYearStore'),
                valueField: 'id',
                displayField: 'value',
                allowBlank: false,
                forceSelection: true,
                editable: false,
            }]
        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 226
            },
            items: [{
			xtype: 'multiselectcombofield',
			width: 960,
			height:58,
			name: 'multiselectAcademy',
			itemId: 'multiselectAcademyId',
			allowBlank : false,
			//fieldLabel : getCommonTranslation('ACADEMIES'),
			fieldLabel : getCommonTranslation('ACADEMY_LOCATION'),
			displayField:'value',
			valueField:'id',
			matchFieldWidth:true,
			maxLength:15000,
			autoloadStore: false,
			queryMode:'local',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			},
        	listeners  :{
        		render : function(combo){
        			//var store=Ext.create('Academia.store.common.AcademyByUserStore');
        			var store=Ext.create('Academia.store.user.UserAcademyLocationStore');
        			combo.bindStore(store)
        		}
        	}
        },{
			xtype: 'multiselectcombofield',
			width: 960,
			height:58,
			name: 'multiselectAcademyWise',
			itemId: 'multiselectAcademyWiseId',
			allowBlank : false,
			fieldLabel : getCommonTranslation('ACADEMY'),
			displayField:'value',
			valueField:'id',
			matchFieldWidth:true,
			maxLength:15000,
			autoloadStore: false,
			hidden:true,
			queryMode:'local',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			},
        	listeners  :{
        		render : function(combo){
        			var store=Ext.create('Academia.store.common.AcademyByUserStore');
        			combo.bindStore(store)
        		}
        	}
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
            xtype: 'customcombobox',
            name: ' programGroupId',
            itemId: 'programGroupItemId',
            fieldLabel: getCommonTranslation('PROGRAM_GROUP'),
            store: Ext.create('Academia.store.committee.committee.CommitteeProgramGroupSmartComboStore'),
            //store: 'program.ProgramGroupStore',
            valueField: 'id',
            displayField: 'value',
            forceSelection: true,
            editable: false,
        },{
			xtype: 'multiselectcombofield',
			width: 960,
			height:58,
			name: 'programGroupWise',
			itemId: 'programGroupWiseId',
			allowBlank : false,
			fieldLabel : getCommonTranslation('PROGRAM_GROUP'),
			displayField:'value',
			valueField:'id',
			matchFieldWidth:true,
			hidden:true,
			maxLength:15000,
			autoloadStore: false,
			hidden:true,
			queryMode:'local',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code}' +
					'</div>';
				}
			},
        	listeners  :{
        		render : function(combo){
        			var store=Ext.create('Academia.store.committee.committee.CommitteeProgramGroupSmartComboStore');
        			combo.bindStore(store)
        		}
        	}
        },{
            xtype: 'customcombobox',
            name: ' programId',
            itemId: 'programItemId',
            fieldLabel: getCommonTranslation('PROGRAM_CODE_OR_NAME'),
            store: 'program.ProgramByGroupIdStore',
            valueField: 'id',
            displayField: 'valueCode',
            typeAhead:true,
			forceSelection:true,
			queryParam:'qry',
			minChars:3,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{code} / {value}' +
					'</div>';
				}
			}
        },{
            xtype: 'customcombobox',
            name: 'batchId',
            itemId: 'batchItemId',
            fieldLabel: getCommonTranslation('BATCH'),
            store: 'common.BatchesByProgramId',
            valueField: 'id',
            displayField: 'value',
            forceSelection: true,
            editable: false,
            disabled: true,
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchBtnManageTargetFilterItemId',
            buttonAlign: 'left',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            itemId: 'resetBtnManageTargetFilterItemId',
            text: getCommonTranslation('RESET'),
            ui: 'CustomBtnCancel',
            scale: CONSTANTS.BUTTONSIZE
        }]
    }]
});