/**
 */

Ext.define('Academia.view.mangeElections.candidate.CandidateInfoWin',{
	extend: 'Ext.window.Window',
	alias: 'widget.candidateinfowin',
	title: getCommonTranslation('CANDIDATES_INFORMATION'),
	frame: true,
	autoScroll:true,
	//cls: 'electionCandidateInfoWincls',
	modal:true,
	layout : {
	    type  : 'hbox',
	    pack  : 'center',
	    align : 'middle'
	},
	method: 'POST',
	items: [{
		xtype: 'idgeneratorformwin',
		itemId:'candidateinfowin',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width:226,
			 
			 
		},
		standardSubmit: false,
		items: [{
			xtype: 'hidden',
			name: 'id',
			itemId: 'id'
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'customcombobox',
				name: 'candidateListName',
				itemId:'candidateListNameItemId',
				store: 'election.election.ElectionCandiateListStore',
				fieldLabel: getCommonTranslation('CANDIDATE_LIST_NAME'),
				allowBlank: false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				displayField: 'value',
				valueField: 'id',
				maxLength:100,
				enforceMaxLength : true,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				}
			},{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation("CANDIDATE_TYPE"),
				name: 'candidateType',
				itemId:'candidateType',
				editable: true,
				store: 'election.election.VootingPoolStore',
				displayField: 'value',
				valueField: 'id',
				minChars:3,
				editable : false,
				typeAhead:true,
				forceSelection :true,
				queryParam:'qry',
				allowBlank:false,
				
				
			},{
				xtype: 'customcombobox',
				name: 'studentId',
				itemId:'studentItemId',
				fieldLabel: getCommonTranslation('NAME'),
				store: 'feeandpayment.managebill.Student',
				allowBlank: false,
				valueField: 'personId',
				hidden:true,
				displayField: 'valueCode',
				queryParam:'studentNameOrCode',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				}
			},{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('NAME'),
			name: 'employee',
			itemId:'employeeId',
			store:'election.election.ElectionStudentNameCode',
			valueField: 'id',
			displayField: 'valueCode',
			queryParam:'codeOrName',
			minChars:3,
			typeAhead:false,
			
			hideTrigger:true,
			forceSelection:true,
			hidden:true,
			//allowBlank:false,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
						picker.width = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
		},{
			xtype:'textfield',
			name: 'externalUserId',
			fieldLabel: getCommonTranslation('NAME'),
			itemId:'externalUserId',
			
			maxLength:255,
			allowBlank: false
		}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[ {
				xtype: 'fieldcontainer',
				itemId:'appointmentCellFieldContainerId',
				name : 'appointmentCellFieldContainerId',
				fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO'),
				layout : {
					type : 'hbox'
				},
				items : [ {
					xtype : 'hidden',
					name : 'id',
					itemId : 'id',
				},{
					xtype : 'customcombobox',
					name : 'mobileCountryCode',
					itemId : 'cellCountryCode',
					valueField : 'isdCode',
					displayField : 'isdCode',
					store:Ext.create('Academia.store.common.CountryStore'),
					triggerAction : 'all',
					editable : false,
					forceSelection:true ,
					width:  70,
					emptyText: 'Code',
				    minChars: 1
				}, {
					xtype : 'numberfield',
					name : 'mobileNo',
					itemId:'mobileNo',
					minLength: 0,
					maxLength: 11,
					enforceMaxLength : true,
					hideTrigger: true,
					keyNavEnabled: false,
					mouseWheelEnabled: false,
					allowExponential:false,
					width : 145,
					emptyText: 'Mobile Number',
				}]
			},{
				xtype:'textfield',	
				fieldLabel:getCommonTranslation('EMAIL'),
				name:'emailId',
				itemId:'emailId',
				vtype: 'email',
				allowBlank: false
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype:'customcombobox',
				fieldLabel:getCommonTranslation('DEPARTMENT'),
				name:'department',
				itemId : 'departmentId',		
				store: 'department.ParentDepartmentByAccesibleStore',
				valueField: 'id',
			//	 readOnly:true,
				allowBlank: false,
				displayField: 'name',
				//editable: false,
				
				hidden:false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
							picker.width = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{value}' +
						'</div>';
					}
				}
			},{
	            xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('PROGRAM'),
//				translationKey : 'PROGRAM',
	            name: 'program',
	            itemId:'program',
	            store: 'program.ProgramByGroupIdStore',
	            displayField: 'value',
	            valueField: 'id',
	            width:226,
	            //typeAhead : true,
	            forceSelection:true,
	            hideTrigger:false,
				//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				queryMode: 'remote',
				queryParam:'programName',
				triggerAction: 'all',
	            minChars:3,
	            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
	            listConfig: {
					  listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
							}
						},
		                loadingText: getCommonTranslation('SEARCHING'),
		                emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		                getInnerTpl: function() {
		                    return '<div class="search-item">' +
		                    '{value}'  +
		                    '</div>';
		                }
		            }
	        },{
				xtype : 'filefield',
				itemId : 'imageUploadField',
				name : 'imageUploadField',
				 ui: 'CustomBtnSubmit',
		            name: 'file',
		            fieldLabel: getPersonModuleTranslation('UPLOAD_LOGO'),
		            buttonText: getPersonModuleTranslation('UPLOAD'),
				
			}]
		},{
			xtype:'fieldcontainer',
			layout:'hbox',
			width: 'auto',
			defaults: {
				width: 226,
				labelAlign: 'top'
			},
			items:[{
				xtype: 'textarea',
				name:'candidateStatement',
				itemId:'candidateStatement',
				width: 460,
				maxLength : 255,
				fieldLabel: getCommonTranslation('CANDIDATE_STATEMENT')
			}]
		},{
			xtype:'fieldcontainer',
			items: [{
				xtype: 'button',
				action: 'Submit',
				text: getFeeAndPaymentCommonTranslation('SAVE'),
				formBind: true,
				itemId: 'SubmitBtnCandidateInfo',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE
			},{
				xtype: 'button',
				text: getFeeAndPaymentCommonTranslation('CANCEL'),
				ui: 'CustomBtnCancel',
				itemId: 'CancelBtnCandidateInfo',
				scale: CONSTANTS.BUTTONSIZE
			}]
		}]	
	}]
});