/**
 *  @author Ramkrishna Yadav
 */

Ext.define('Academia.view.mangeElections.candidate.ExternalUserVoterPoolGrid', {
	//extend : 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.externaluservoterpoolgrid',
	store : 'election.election.ElectionExternalUserVoterPoolGridStore',
	border: true,
	autoScroll: false,
	selType:'checkboxmodel',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [{
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'election.election.ElectionExternalUserVoterPoolGridStore',
			emptyMsg :getFeeAndPaymentCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		iconCls: 'view-icon'
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	},{
		xtype: 'button',
		itemId: 'captureBollotVotesBtn',
		tooltip: getCommonTranslation('CAPTURE_BALLOT_VOTES'),
		text: getCommonTranslation('CAPTURE_BALLOT_VOTES'),
	},{
		xtype: 'button',
		itemId: 'sendMessageBtn',
		tooltip: getCommonTranslation('SEND_MESSAGE'),
		 text: getCommonTranslation('SEND_MESSAGE'),
		
	  },{
		 xtype:'textfield',
		 emptyText: getCommonTranslation('ENTER_THREE_CHAR_BY_NAME_EMAIL'),
		 width: 300,
		 name:'extUserVoterPoolGridSearch',
		 itemId:'extUserVoterPoolGridSearch',
		 cls: 'SearchTextFieldWithSmallHeader'
	},'->',{
		xtype: 'button',
		itemId: 'changeWeightage',
		tooltip: getCommonTranslation('CHANGE_WEIGHTAGE'),
		 text: getCommonTranslation('CHANGE_WEIGHTAGE'),
		
			}],
	columns: [{
		header : getCommonTranslation('NAME'),
		dataIndex : 'name',
		flex:1
	},{
		header : getCommonTranslation('EMAIL_ID'),
		dataIndex : 'emailId',
		flex:1,
		
	},{
		header :getCommonTranslation('PHONE_NUMBER'),
		dataIndex : 'phoneNumber',
		flex:1,
            renderer : function(value, metadata, record) {
			
			var val = value;
			if(record.data.phoneCountryCode!=null) {
				val = record.data.phoneCountryCode+ "-" + value;
			}
			return val;
		}
	},{
		header :getCommonTranslation('DESCRIPTION'),
		dataIndex : 'description',
		flex:1,
		renderer: function(value, metadata, record) {
			var msg ;
			if (!isNullOrEmpty(value) && !isNullOrEmpty(value)) {
				msg = '<a href="#">' + "View" + '</a>';
			}
			return msg;
		}
	},{
		header :getCommonTranslation('VOTING_STATUS'),
		dataIndex : 'votingAction',
		flex:1,
        renderer:function(value) {
        	if(!isNullOrEmpty(value)){
        		var val;
    			if(value == 'VOTED') {
    				val = '<span  style="color:Green;">' +getCommonTranslation("VOTED")+ '</span>';
    			}else if(value == 'NOT_VOTED') {
    				val = '<a href="#" style="color:red;">' +getCommonTranslation("NOT_VOTED")+ '</a>';
    			}else{
    				val = value;
    			}
    			return val;
        	}else{
        		return '-';
        	}
		}
	},{
		header :getCommonTranslation('VOTE_WEIGHTAGE'),
		dataIndex : 'weightage',
		flex:1,
		
	},{
		header :getCommonTranslation('ELECTION_LINK'),
		dataIndex : 'electionVoterPoolUrl',
		flex:1,
		hidden:true,
		renderer: function(value, metadata, record) {
			var link ;
			if (!isNullOrEmpty(value) && !isNullOrEmpty(value)) {
				link = '<a href="#">' + "View" + '</a>';
			}
			return link;
		},
	}],
});