/**
 * @author Ramkrishna Yadav
 * 
 */
Ext.define('Academia.view.mangeElections.mangeElections.ElectionForm',{
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias : 'widget.electionform',
	 formCode:'electionform',
	    itemId: 'electionform',
	    plugins: "formlabelrequired",
	autoScroll: true,
	bodyPadding:'10 10 10 11',
	frame:true,
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	method: 'POST',
	defaults: {
		labelAlign: 'top',
	},
	plugins : "formlabelrequired",
	items : [{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 240,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'hidden',
			itemId:'idItemId',
			name: 'id'
		}, {
			xtype : 'textfield',
			name : 'electionCode',
			itemId:'electionCodeItemId',
			fieldLabel : getCommonTranslation("ELECTION_CODE"),
			emptyText: getCommonTranslation('ID_AUTOGENERATE'),
		   readOnly:true,
			
			
		},{
			xtype : 'textfield',
			name : 'electionName',
			itemId:'electionNameItemId',
			fieldLabel : getCommonTranslation("ELECTION_NAME"),
			allowBlank:false,
			maxLength: 100,
			cls:'electionNameCls'
		},
		]

	},
	{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 240,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'hidden',
			itemId:'idItemId',
			name: 'id'
		}, {
			xtype : 'textfield',
			name : 'electionNameInOtherLang',
			itemId:'electionNameInOtherLangItemId',
			fieldLabel : getCommonTranslation("ELECTION_NAME_IN_AFRIKAANS"),
			
			
		},{
			xtype : 'customcombobox',
			//width: 226,
			fieldLabel : getCommonTranslation('ACADEMIC_TERM'),		
			name : 'academicTerm',
			itemId : 'academicTerm',
			displayField : 'value',
			store:Ext.create('Academia.store.common.AcademicTermStoreForIntakeYearId'),
			valueField : 'id',
			allowBlank:false,
			//triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			minChars:3,
			//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			typeAhead : true,
			//editable : false
			/*listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}*/
		},
		{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation("ELECTION_TYPE"),
			name: 'electionType',
			itemId:'electionType',
			editable: true,
			store: 'election.election.ElectionTypeStore',
			displayField: 'value',
			valueField: 'id',
			minChars:3,
			editable : false,
			typeAhead:true,
			forceSelection :true,
			queryParam:'qry',
			allowBlank:false,
			
		}]

	} ,{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 240,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'fieldset',
			width: 240,
			cls: 'customTwoFieldContainerCls',
			title: getCommonTranslation('VOTING_START_DATE_TIME') + ': <span class="required" style="color:red"> *</span>',
			name: 'votingStartDateTime',
			itemId:'votingStartDateTime',
			layout: 'hbox',
			items: [{
				xtype: 'datefield',
				name: 'votingStartDate',
				itemId:'votingStartDateItemId',
				endDateField:'votingEndDateItemId',
				vtype: 'daterange',
				width:115,
				allowBlank:false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}}
			},{
				xtype : 'timefield',
				name:'votingStartTime',
			
				itemId:'votingStartTime',
				width:115,
				allowBlank:false,
				format:CONSTANTS.DISPLAY_TIME_FORMAT,
				vtype: 'timerange',
				
				listeners: {
					renderer: function(time) {        	
			            return timeRender(time);
			        }
				}
			}]
		},{
			xtype: 'fieldset',
			width: 240,
			cls: 'customTwoFieldContainerCls',
			title: getCommonTranslation('VOTING_END_DATE_TIME') + ': <span class="required" style="color:red"> *</span>',
			layout: 'hbox',
			style: 'margin-left: 10px !important;',
			name: 'votingEndDateTime',
			itemId:'votingEndDateTime',
			items: [{
				xtype: 'datefield',
				name: 'votingEndDate',
				itemId:'votingEndDateItemId',
				allowBlank:false,
				width:115,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}, {
				xtype : 'timefield',
				name:'votingEndTime',
			    itemId:'votingEndTime',
				allowBlank:false,
				width:115,
				format:CONSTANTS.DISPLAY_TIME_FORMAT,
				vtype: 'timerange',
			   listeners: {
					renderer: function(time) {        	
			            return timeRender(time);
			        }
				}
			}]
		},{
			xtype: 'fieldset',
			width: 240,
			//height:'60px',
			cls: 'customTwoFieldContainerCls',
			title: getCommonTranslation('VOTING_POOL') + ': <span class="required" style="color:red"> *</span>',
			name : 'extendedDateFieldSet',
			itemId:'extendedDateFieldSet',
			layout: 'hbox',
			style: 'margin-left: 10px !important;',
			items: [{
				xtype : 'multiselectcombofield',
				name : 'votingPool',
				itemId : 'votingPool',
				allowBlank:false,
				
				store:'election.election.VootingPoolStore',
				valueField: 'id',
				displayField: 'value',
				typeAhead : true,
				width: 200,
				editable: false,
				  cls:'multiBrandCampusCls',
				
			
			}]
		}]
	},{
		xtype:'fieldcontainer',
		layout:'hbox',
		width:'100%',
		defaults: {
			width: 240,
			labelAlign: 'top'
		},
		items:[{
            xtype: 'radiogroup',
            itemId: 'isAdminCapture',
            name: 'isAdminCapture',
            fieldLabel: getCommonTranslation('ADMIN_CAPTURE_VOTES'),
            columns: 2,
           // width: '250px',
            //labelWidth: 'auto',
            vertical: false,
            layout: {
            	type: 'hbox'
            },
            items: [{
                boxLabel: getCommonTranslation('YES'),
                name: 'isAdminCaptureVote',
                itemId: 'yesItemId',
               width: 120,
                inputValue: true,
            }, {
                boxLabel: getCommonTranslation('NO'),
                name: 'isAdminCaptureVote',
                itemId: 'NoItemId',
                width: 90,
               inputValue: false ,
                checked: true
            }]
		},
		{
			xtype: 'fieldset',
			width: 240,
			cls: 'customTwoFieldContainerCls',
			title: getCommonTranslation('ADMIN_CAPTURE_START_DATE') + ': <span class="required" style="color:red"> *</span>',
			layout: 'hbox',
			name: 'adminCapStartDateAndTIme',
			itemId:'adminCapStartDateAndTIme',
			disabled:true,
			items: [{
				xtype: 'datefield',
				name: 'adminCaptureStartDate',
				itemId:'adminCaptureStartDateItemId',
				endDateField:'adminCaptureEndDate',
				vtype: 'daterange',
				width:115,
				allowBlank:false,
				//disabled:true,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
			}
			},{
				xtype : 'timefield',
				name:'adminCaptureStartTime',
				itemId:'adminCaptureStartTime',
				//disabled:true,
				allowBlank:false,
				width:115,
				vtype: 'timerange',
				listeners: {
					renderer: function(time) {        	
			            return timeRender(time);
			        }
				}
			}]
		},{
			xtype: 'fieldset',
			width: 240,
			cls: 'customTwoFieldContainerCls',
			title: getCommonTranslation('ADMIN_CAPTURE_END_DATE') + ': <span class="required" style="color:red"> *</span>',
			name: 'adminCapEndDateAndTIme',
			itemId:'adminCapEndDateAndTIme',
			disabled:true,
			layout: 'hbox',
			style: 'margin-left: 10px !important;',
			items: [{
				xtype: 'datefield',
				name: 'adminCaptureEndDate',
				itemId:'adminCaptureEndDate',
				width:115,
				//disabled:true,
				allowBlank:false,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}}
			}, {
				xtype : 'timefield',
				name:'adminCaptureEndTime',
				allowBlank:false,
				itemId:'adminCaptureEndTime',
			//	disabled:true,
				width:115,
				vtype: 'timerange',
			   listeners: {
					renderer: function(time) {        	
			            return timeRender(time);
			        }
				}
			}]
		}]
	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 300,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'hidden',
			itemId:'idItemId',
			name: 'id'
		}, {
            xtype: 'radiogroup',
            itemId: 'referendum1',
            name: 'referendum1',
            fieldLabel: getCommonTranslation('REFERENDUM_ONE'),
            columns: 2,
            width:240,
            vertical: false,
            layout: {
            	type: 'hbox'
            },
            items: [{
                boxLabel: getCommonTranslation('YES'),
                name: 'isReferendumOne',
                itemId: 'isReferendumOneItemId',
                width:100,
                inputValue: true,
               //checked: true
            }, {
                boxLabel: getCommonTranslation('NO'),
                name: 'isReferendumOne',
               width:100,
                itemId: 'Noreferendum1ItemIdItemId',
                inputValue: false,
                checked: true
            }]
		},{
			xtype : 'textfield',
			name : 'referendumOneQuestionInEnglish',
			itemId:'referendumOneQuestionInEnglish',
			fieldLabel : getCommonTranslation("REFERENDUM_ONE_QUESTION_ENG"),
			disabled:true,
			
		},{
			xtype : 'textfield',
			name : 'referendumOneQuestionInOtherLang',
			itemId:'referendumOneQuestionInOtherLang',
			fieldLabel : getCommonTranslation("REFERENDUM_ONE_QUESTION_AFR"),
			disabled:true,
			
		}]

	},{
		xtype : 'fieldcontainer',
		width : '100%',
		layout : {
			type : 'hbox'
		},
		defaults : {
			width : 300,
			labelAlign : 'top'
		},
		items : [{
			xtype: 'hidden',
			itemId:'idItemId',
			name: 'id'
		}, {
            xtype: 'radiogroup',
            itemId: 'referendumTwo',
            name: 'referendumTwo',
            fieldLabel: getCommonTranslation('REFERENDUM_TWO'),
            columns: 2,
            width:240,
            vertical: false,
            layout: {
            	type: 'hbox'
            },
            items: [{
                boxLabel: getCommonTranslation('YES'),
                name: 'isReferendumTwo',
                width:100,
                itemId: 'referendumYes2ItemId',
                inputValue: true,
               //checked: true
            }, {
                boxLabel: getCommonTranslation('NO'),
                name: 'isReferendumTwo',
                width:100,
                itemId: 'Noreferendum2ItemIdItemId',
                inputValue: false,
                checked: true
            }]
		},{
			xtype : 'textfield',
			name : 'referendumTwoQuesInEng',
			itemId:'referendumTwoQuesInEng',
			fieldLabel : getCommonTranslation("REFERENDUM_TWO_QUESTION_ENG"),
			disabled:true,
			
		},{
			xtype : 'textfield',
			name : 'referendumTwoQuesInOtherLang',
			itemId:'referendumTwoQuesInOtherLang',
			fieldLabel : getCommonTranslation("REFERENDUM_TWO_QUESTION_AFR"),
			disabled:true,
			
		}]

	},{
		xtype: 'fieldcontainer',
		layout: {
			type: 'hbox'
		},
		defaults: {
			width: 460,
			labelAlign: 'top'
		},
		items:[{
			xtype: 'textarea',
			name:'electionDesInEng',
			itemId:'electionDesInEng',
			width: 460,
			maxLength : 5000,
			allowBlank:false,
			fieldLabel: getCommonTranslation('ELECTION_DESCRIPTION')
		},{
			xtype: 'textarea',
			name:'electionDescriptionInOtherLang',
			itemId:'electionDescriptionInOtherLang',
			width: 460,
			maxLength : 5000,
			fieldLabel: getCommonTranslation('ELECTION_DESCRIPTION_IN_AFR')
		}]
	},{
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			width: 226,
			labelAlign: 'top'
		},
		items: [{
            xtype: 'radiogroup',
            itemId: 'status',
            name: 'status',
            fieldLabel: getCommonTranslation('IS_ACTIVE'),
            columns: 2,
            width: '250px',
            //labelWidth: 'auto',
            vertical: false,
            layout: {
            	type: 'hbox'
            },
            items: [{
                boxLabel: getCommonTranslation('YES'),
                name: 'isActive',
                itemId: 'statusYesItemId',
                width: 100,
                inputValue: true,
               checked: true
            }, {
                boxLabel: getCommonTranslation('NO'),
                name: 'isActive',
                itemId: 'statusNoItemId',
                width: 100,
                inputValue: false,
                
            }]
		}]
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'hbox'
		},
		width:'auto',
		items : [{
			xtype : 'button',
			text : getCommonTranslation("SAVE") ,
			itemId : 'submitBtn',
			ui : 'CustomBtnSubmit',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		},{
			xtype: 'button',
			itemId: 'resetBtn',
			text: getCommonTranslation("RESET"),
			ui:'CustomBtnCancel',
			scale: CONSTANTS.BUTTONSIZE,
			/*listeners: {
				click: function(object) {
					var form = object.up('form').getForm();
					form.findField('user').reset();
					form.reset();
				}
			}*/
		}]
	}]
});
