/**
 * @author sohan chouhan
 * 
 */
Ext.define('Academia.view.organization.academylocations.AcademyLocationAddOtherInfoWin', {
    extend: 'Ext.window.Window',
    alias: 'widget.academylocationaddotherinfowin',
    modal: true,
    resizable: false,
    title: getCommonTranslation('ADD_OTHER_INFORMATION'),
    items: [{
    	 xtype: 'idgeneratorformwin',
         itemId:'academylocationaddotherinfowin',
         plugins: "formlabelrequired",
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
        	xtype : 'hidden',
        	name: 'id',
        	itemId: 'academyLocationId'
        },{
        	xtype : 'hidden',
        	name: 'existingFilePath',
        	itemId: 'existingFilePath'
        },{
        	xtype : 'hidden',
        	name: 'catalogueDocument',
        	itemId: 'document_hidden_field'
        },{
        	xtype: 'textfield',
        	name: 'code',
        	itemId: 'academyLoctionDisplayName',
        	fieldLabel: getCommonTranslation('ACADEMY_LOCATION_DISPLAY_NAME'),
        	editable: false,
        	readOnly: true
        }, {
            xtype: 'filefield',
            fieldLabel: getCommonTranslation('UPLOAD_IMAGE_FOR_CATALOGUE'),
            buttonText: getPersonModuleTranslation('UPLOAD'),
            itemId: 'imageUploadField',
            ui: 'CustomBtnSubmit',
            name: 'file'
        }, {
        	xtype:'image',
        	itemId: 'organizationLogo',
        	border: 1,
        	style: {
        		borderColor: 'black',
        		borderStyle: 'solid'
        	},
        	width: 130,
        	height: 150
        },{
        	xtype: 'textfield',
        	name: 'videoURLCatalogue',
        	itemId: 'videoURLCatalogueId',
        	fieldLabel: getCommonTranslation('VIDEO_URL_FOR_CATALOGUE'),
        },{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('VENUE_UKPRN'),
			store: 'organization.academylocations.VenueUkprnStore',
			itemId: 'venueukprnItemId',
			name: 'venueukprn',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			hidden: true
        },{
    		xtype: 'checkboxfield',
    		width: 'auto',
    		labelAlign: 'right',
    		boxLabel: getCommonTranslation('PUBLISH_IN_CATALOGUE'),
    		name: 'whetherPublicCatalogue',
    		itemId: 'whetherPublicCatalogueId',
    		inputValue : true,
    		uncheckedValue: false

    	},{
        	xtype: 'fieldcontainer',
        	width: '100%',
        	items: [{
        		xtype: 'button',
        		itemId: 'btnSaveALCatalogue',
        		text: getCommonTranslation('SAVE'),
        		ui: 'CustomBtnSubmit',
        		scale: CONSTANTS.BUTTONSIZE,
        		formBind: true
        	}, {
        		xtype: 'button',
        		itemId: 'btnCancel',
        		text: getCommonTranslation('CANCEL'),
        		ui: 'CustomBtnCancel',
        		scale: CONSTANTS.BUTTONSIZE,
        		listeners: {
        			click: function() {
        				this.up('window').close();
        			}
        		}
        	}]
        }]
    }]

});