/**
 * @author prathamesh.sheth
 * 
 * This component is used for to show Academy Location Purpose Details Dialog Box
 */
Ext.define('Academia.view.organization.academylocations.AcademyLocationPurposeFormWindow',
		{
			extend : 'Ext.window.Window',
			alias : 'widget.academylocationpurposeformwindow',
			modal : true,
			resizable:false,
			margin:0,
			title : getCommonTranslation('PURPOSE_DETAILS'),//Purpose Details
			items : [{
				xtype: 'form',				
				itemId:'academyLocationPurposeForm',
			    method : 'POST',			    
				bodyPadding:'10 10 10 10',
			    standardSubmit : false,
			    defaults:{
					labelAlign:'top'
				},
				plugins : "formlabelrequired",
			    items : [ 
			    	{
						xtype : 'hidden',
						itemId:'hidAcademyPurposeField',
						name : 'id' 
					},{
						xtype : 'hidden',
						itemId:'versionId_hidden_field',
						name : 'version'
					},{
						xtype : 'hidden',
						itemId:'hidAcademyLocationField',
						name : 'academyLocation'
					},{
				    	xtype: 'fieldcontainer',
					    width: 'auto',
					    defaults: {
					    	labelAlign: 'top',
					    	width: 226
					    },
					    layout: {
					    	type: 'hbox'
					    },
						items: [{
							xtype : 'customcombobox',
							name : 'purpose',						
							fieldLabel : getCommonTranslation('PURPOSE'),//Purpose
							itemId:'cmbPurposeName',
							store : 'organization.academylocations.PurposesStore',
							valueField : 'id',
							displayField : 'purpose',
							editable:false,
							emptyText:getCommonTranslation('SELECT_PURPOSE'),//Select a purpose
							queryMode: 'local',
							triggerAction:'all',
							forceSelection :true,
							allowBlank:false	
						}, {
							xtype : 'customcombobox',
							name : 'calendar',			
							itemId : 'cmbPurposeCalendar',			
							fieldLabel : getCommonTranslation('CALENDAR'),//Calendar
							store : 'calendar.ActiveCalendarStore',
							valueField : 'id',
							displayField : 'value',
							editable:false,
							emptyText:getCommonTranslation('SELECT_CALENDAR'),//Select a calendar							
							triggerAction:'all',
							forceSelection :true,
							allowBlank:false
						}]
				},{
			    	xtype: 'fieldcontainer',
				    width: 'auto',
				    defaults: {
				    	labelAlign: 'top',
				    	width: 226
				    },
				    layout: {
				    	type: 'hbox'
				    },
					items: [{
						xtype : 'customcombobox',
						name : 'owner',			
						itemId : 'cmbOwner',			
						fieldLabel : getCommonTranslation('OWNER'),//Owner						
						store : 'common.UsersComboStore',
						valueField : 'id',
						displayField : 'value',
						editable:false,
						emptyText:getCommonTranslation('SELECT_OWNER'),//Select a owner
						queryMode: 'local',
						triggerAction:'all',
						forceSelection :true,
						allowBlank:false
					}, {
						xtype : 'customcombobox',
						name : 'year',			
						itemId : 'cmbAcademicYear',			
						fieldLabel : getCommonTranslation('ACADEMY_YEAR'),//Academic Year
						store : 'organization.academylocations.AcademicYearStore',
						valueField : 'id',
						displayField : 'yearName',
						editable:false,
						emptyText:getCommonTranslation('SELECT_ACADEMY_YEAR'),//Select a academic year
						queryMode: 'local',
						triggerAction:'all',
						forceSelection :true,
						//disabled:true,
						allowBlank:false
					}]
				 },{
				    	xtype: 'fieldcontainer',
					    width: 'auto',
					    defaults: {
					    	labelAlign: 'top',
					    	width: 226
					    },
					    layout: {
					    	type: 'hbox'
					    },
						items: [{
							xtype : 'customcombobox',
							name : 'year_tenure',			
							itemId : 'cmbAcademicYearTenure',			
							fieldLabel : getCommonTranslation('CURRENT_YEAR_TENURE'),//Current Academic Year Tenure
							store : 'organization.academylocations.AcademicTenureStore',
							valueField : 'id',
							displayField : 'tenureName',
							editable:false,
							emptyText:getCommonTranslation('SELECT_YEAR_TENURE'),//Select a academic year tenure
							queryMode: 'local',
							triggerAction:'all',
							forceSelection :true,
							//disabled:true,
							allowBlank:false
						},{
							xtype : 'customcombobox',
							name : 'faculty_fee',			
							itemId : 'cmbFacultyFeePlan',			
							fieldLabel :getCommonTranslation('FACULTY_FEE_PLAN'),//Faculty Fee Plan
							store : 'organization.academylocations.FacultyFeePlanStore',
							valueField : 'id',
							displayField : 'planName',
							editable:false,
							emptyText: getCommonTranslation('SELECT_FEE_PLAN'),//Select a faculty fee plan
							queryMode: 'local',
							triggerAction:'all',
							forceSelection :true,
							//disabled:true,
							//allowBlank:false
						}]
				},{
			    	xtype: 'fieldcontainer',
				    width: 'auto',
				    defaults: {
				    	labelAlign: 'top',
				    	width: 226
				    },
				    layout: {
				    	type: 'hbox'
				    },
					items: [{
						xtype : 'datefield',
						name : 'startDate',						
						itemId : 'dateStartDate',
						vtype: 'daterange',
						endDateField:'dateTillDate',
						listeners: {
							render: function(field) {
								return dateFormatRender(field);
							}
						},
						//--submitFormat: CONSTANTS.DATE_FORMAT,
						fieldLabel : getCommonTranslation('START_DATE'),//Start Date
						editable:false,
						emptyText:getCommonTranslation('SELECT_START_DATE'),//Select start date
						allowBlank:false
					}, {
						xtype : 'datefield',
						name : 'tillDate',
						itemId : 'dateTillDate',
						vtype: 'daterange',
						startDateField: 'dateStartDate',
						listeners: {
							render: function(field) {
								return dateFormatRender(field);
							}
						},
						//--submitFormat: CONSTANTS.DATE_FORMAT,
						fieldLabel : getCommonTranslation('END_DATE'),//End Date
						editable:false,
						emptyText:getCommonTranslation('SELECT_END_DATE'),//Select end date
						allowBlank:false
					   }]
				},{
		        	xtype:'fieldcontainer',
		        	width:'100%',
		        	cls:'windowBtnPos',
		            items: [{
						xtype : 'button',						
						itemId : 'btnSaveAcademyLocationPurposeForm',
						text : getCommonTranslation('SUBMIT'), //Submit
						ui: 'CustomBtnSubmit',
		                scale: CONSTANTS.BUTTONSIZE,
		                formBind : true
					}, {
						xtype : 'button',
						itemId : 'btnCancelAcademyLocationPurposeForm',
						text : getCommonTranslation('CANCEL'), //Cancel
						ui: 'CustomBtnCancel',
		                scale: CONSTANTS.BUTTONSIZE											
					}]
				}]
			}]
		});
