/**
 * @author Trupti.Paoneker
 
 * This component is used for to show bank master grid details.
 */
Ext.define('Academia.view.othermasters.bankmaster.BankMasterGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.bankmastergrid',
    store: 'othermasters.bankmaster.BankMasterStore',
    title: getCommonTranslation('BANK_MASTER'), // Bank Master
    collapsible: false,
    style:{'z-index':'99'},
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'bankmaster':1
		}
	},
    columns: [{
        header: getCommonTranslation('ACADEMY'), //Academy
        dataIndex: 'academy',
        sortable: false,
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, 'value');
        }
    }, {
        header: getCommonTranslation('LOCATION'), //Location
        dataIndex: 'location',
        sortable: false,
        flex: .2,
        renderer: function(obj) {
            return columnObjRender(obj, 'value');
        }
    }, {
        header: getCommonTranslation('BANK_CODE'), //Bank code
        dataIndex: 'bankCode',
        sortable: false,
        flex: .2

    }, {
        header: getCommonTranslation('BANK_IFSC_CODE'), //Status
        dataIndex: 'ifscCode',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('BANK_ACC_NO'), //Bank Account Number
        dataIndex: 'accountNo',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('BANK_NAME'), //Bank name
        dataIndex: 'bankName',
        sortable: false,
        flex: .2

    }, {
        header: getCommonTranslation('BRANCH_NAME'), //Branch name
        dataIndex: 'branchName',
        sortable: false,
        flex: .2

    }, {
        header: getCommonTranslation('BRANCH_ADDRESS'), //Branch name
        dataIndex: 'branchAddress',
        sortable: false,
        flex: .2

    }, {
        header: getCommonTranslation('STATUS'), //Status
        dataIndex: 'bankStatus',
        sortable: false,
        flex: .2,
        renderer: function(value) {
            if (value == 'on') {
                return getCommonTranslation('ACTIVE');
            } else {
                return getCommonTranslation('INACTIVE');
            }
        }

    },
    {
        header: getCommonTranslation('IS_DEFAULT_BANK_ACCOUNT_COLUMN'), //defaultAccount
        dataIndex: 'defaultBank',
        sortable: false,
         flex: .4,
        renderer: function(value) {
            if (value == true) {
                return getCommonTranslation('YES');
            } else {
                return getCommonTranslation('NO');
            }
        }

    },
    {
        header: getCommonTranslation('MERCHANT_ID'), //defaultAccount
        dataIndex: 'merchantId',
        sortable: false,
        flex: .3,
		hidden:true,

    }],
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'), //Add Bank
        glyph: ICONGLYPH.ADDGLYPH
        //text : getCommonTranslation('ADD')
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'), //Edit Bank
        glyph: ICONGLYPH.EDITGLYPH
        //text : getCommonTranslation('EDIT')
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'), //View Bank
        iconCls: 'view-icon'
        //text : getCommonTranslation('VIEW')
    }],
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'othermasters.bankmaster.BankMasterStore',
            emptyMsg:'<span id="manageAccountingGridId" style="margin-top: 60px !important">'+ getCommonTranslation('NO_BANK_TO_DISPLAY')+'</span>', //No Bank to display
            displayInfo: true
        }]
    }]
});