/**
 * @author priyanshi sharma
 */
Ext.define('Academia.view.personinfo.common.ProFormaInvoice.ProFormaInvoiceGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.proformainvoicegrid',
    title: getPersonModuleTranslation('PRO_FORMA_INVOICE'),
    border: true,
    autoScroll: true,
    viewConfig: {
    	stripeRows : CONSTANTS.STRIPEROWS
    },
    initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     
	},
    columns: [{
        header: getFeeAndPaymentCommonTranslation('INVOICE_NUMBER'),
        dataIndex: 'proformaInvoiceNo',
        sortable: false,
        flex: .2
    },  {
        header: getCommonTranslation('PROGRAM'),
        dataIndex: 'programName',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('BATCH'),
        dataIndex: 'batchName',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('ACADEMIC_TERM'),
        dataIndex: 'academicYear',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('PERIOD'),
        dataIndex: 'periodName',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('AMOUNT'),
        dataIndex: 'invoiceAmount',
        sortable: false,
        flex: .2
    }, {
        header: getCommonTranslation('INVOICE'),
        dataIndex: 'documentName',
        sortable: false,
        flex: .2,
		renderer:function(value) {
			if (value) {
	            var nameWithoutExt = value.replace(/\.[^/.]+$/, "");
	            return '<a href="#">' + nameWithoutExt + '</a>';
	        }
	        return '';
		}
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.ProFormaInvoice.ProFormaInvoiceGridStore');
    }

});