/**
 * @author Bhanu PS
 */
Ext.define('Academia.view.personinfo.common.course.ExaminationDutyPaperSatterGrid', {
	//extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.examinationdutypapersattergrid',
	store: 'examinationcenters.roomallocation.ExaminationDutyGridStore',
    title: getPersonModuleTranslation('FACULTY_EXAMINATION_DUTY_GRID'),
    border: true,
	autoScroll: false,
	frame:false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	 dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [{
	    	    xtype : 'custompagingtoolbar',
	    	    plugins:['pagesize'],
	    	    store : 'examinationcenters.roomallocation.ExaminationDutyGridStore',
	    	    emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    	    displayInfo : true
	    	} ]
	}],
	initComponent: function() {

		var grid=this;                   
		grid.addExportToolBarItems(grid);
		this.callParent(arguments);     

	},
    columns: [{
		header:  getExaminationTranslation('EVALUATION_GROUP'),
		dataIndex: 'evaluationGroupCode',
		flex:.1,
		sortable:true
	},{
		header: getExaminationTranslation('CENTER'),
		dataIndex: 'centerName',
		flex:.1,
		sortable:true,
	},
	{
		header:getCommonTranslation('DATES'),
		dataIndex: 'scheduleDate',
		flex:.1,
		sortable:true,
		renderer: function(date) {
            return dateRender(date);
        }
	},{
		header:getCommonTranslation('TIME_SLOT'),
		dataIndex: 'batchName',
		flex:.1,
		sortable:true,
		renderer:function(value, record){
        	return timeRender(record.record.data.timeFrom)+" - "+(timeRender(record.record.data.timeTo));
        }
	},
	{
        header: getExaminationTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex:.1,
        sortable:true
    },{
        header: getExaminationTranslation('BATCH'),
        dataIndex: 'programBatchName',
        flex:.1,
        sortable:true
    },{
		header: getExaminationTranslation('PERIOD'),
		dataIndex: 'periodName',
		flex:.1,
		sortable:true,
	},{
		header:getExaminationTranslation('SECTION'),
		dataIndex: 'sectionName',
		flex:.1,
		sortable:true,
	},{
		header:getExaminationTranslation("COURSE"),
		dataIndex: 'courseName',
		flex:.1,
		sortable:true,
	},{
		header:getExaminationTranslation('COURSE_VARIANT'),
		dataIndex: 'courseVariantName',
		flex:.1,
		sortable:true,
	},{
		header:getExaminationTranslation('DETAILED_SEQUENCE'),
		dataIndex: 'eventName',
		flex:.1,
		sortable:true,
	}]
});