/**
 *   @author Nishant Jain
      
 */
Ext.define('Academia.view.personinfo.common.course.StudentProgramDetailsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentprogramdetailsgrid',
	store: 'program.programDetails.programBatches.courseParameter.StudentProgramDetailsStore',
	title: getCommonTranslation('STUDENT_PROGRAM_DETAILS'),
	border: true,
	frame:false,
	isGridConfigurable: true,
	enableColumnHide: false,
	headerFix:{
		headerFix: true,
		portalIdsWithStructure: {
			'programdetails': 3
		}
	},
	
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},

	plugins: [{
        ptype: 'cellediting',
        clicksToEdit: 1
    }],
            dockedItems: [{
	    	xtype : 'toolbar',
	    	dock : 'bottom',
	    	items : [ {
	    		xtype : 'custompagingtoolbar',
	    		plugins:['pagesize'],
	    		store : 'program.programDetails.programBatches.courseParameter.StudentProgramDetailsStore',
	    		emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
	    		displayInfo : true
	    	} ]
	    }],
	    initComponent: function() {

	    	var grid=this;                   
	    	grid.addExportToolBarItems(grid);
	    	this.callParent(arguments);     
	    },

         tbar: [{
            xtype: 'button',
	    	text: getCommonTranslation('SAVE'),
	    	itemId: 'btnSaveItemId',
	    	ui: 'CustomBtnSubmit',
	    	formBind:true,
	    	cls: 'x-btn x-unselectable x-btn-CustomBtnSubmit-small x-noicon x-btn-noicon x-btn-CustomBtnSubmit-small-noicon',
	    	scale: CONSTANTS.BUTTONSIZE
        
    }],

    columns: [{
        header: getCommonTranslation('ADMISSION_ID'),
        dataIndex: 'admissionId',
        flex: 0.1,
        sortable: true
    },{
        header: getCommonTranslation('PROGRAM'),
        dataIndex: 'programName',
        flex: 0.2,
        sortable: true
    },{
        header: getCommonTranslation('BATCH'),
        dataIndex: 'batchName',
        flex: 0.1,
        sortable: true
    },{
        header: getCommonTranslation('DATE_OF_ADMISSION'),
        dataIndex: 'admissionDate',
        flex: 0.15,
        sortable: true,
        editor: {
            xtype: 'datefield',
            format: 'd/m/Y',
            allowBlank: true
        },
       renderer: function (value) {
    return value ? Ext.Date.format(new Date(value), 'd/m/Y') : '';
    }
    },{
        header: getCommonTranslation('ADMISSION_ID_STATUS'),
        dataIndex: 'admissionStatus',
        flex: 0.15,
        sortable: true,
        renderer: function (value) {
            return value ? value : '';
        }
    },{
        header: getCommonTranslation('ID_INACTIVE_REASON'),
        dataIndex: 'inactiveReason',
        flex: 0.2,
        sortable: true
        
    }],

    initComponent: function() {
	    	var this$ = this;
	    	var store = this$.buildStore();
	    	Ext.apply(this$, {
	    		store: store,
	    		dockedItems: [{
	    			xtype: 'toolbar',
	    			dock: 'bottom',
	    			items: [{
	    				xtype: 'custompagingtoolbar',
	    				plugins: ['pagesize'],
	    				store: store,
	    				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
	    				displayInfo: true
	    			}]
	    		}]
	    	});
	    	this$.addExportToolBarItems(this$);
	    	this$.callParent(arguments);
	    },
	    buildStore: function() {
	    	return Ext.create('Academia.store.program.programDetails.programBatches.courseParameter.StudentProgramDetailsStore');
	    }
});