Ext.define('Academia.view.personinfo.common.disciplinaryactivity.SanctionDetailsGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.sanctiondetailsgrid',
	store: 'personinfo.common.disciplinaryactivity.DisciplinarySanctionDetailGridStore',
	title: getPersonModuleTranslation('ADD_SANCTION_DETAILS'),
	border: true,
	autoScroll: false,
	frame: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH
	}],
	columns: [{
		header: getPersonModuleTranslation('SANCTION_TYPE'),
		dataIndex: 'sanctionType',
		flex: 1,
		editor: {
			xtype: 'customcombobox',
			name: 'sanctionType',
			itemId: 'sanctionTypeItemId',
			store:Ext.create('Academia.store.personinfo.common.disciplinaryactivity.DisciplinarySanctionTypeSUStore'),
			allowBlank: true,
			displayField : 'value',
			valueField : 'id',
			triggerCls : Ext.baseCSSPrefix + 'x-form-trigger',
        	enableKeyEvents  : 'true',
        	hideTrigger:false,
        	forceSelection:true,
        	triggerAction: 'all',
			queryParam:'id',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			minChars:3,
			listConfig: {
        		listeners: {
        			beforeshow: function(picker) {
        				picker.minWidth = picker.up('combobox').getSize().width;
        			}
        			
        		},
        		loadingText: getCommonTranslation('SEARCHING'),
        		emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
        		getInnerTpl: function() {
        			return '<div class="search-item">' +
        			'{code} / {value}'  +
        			'</div>';
        		}
        	}
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			if(!isNullOrEmpty(value) && value !== '') {
				try{
					if(Ext.isObject(value)){
						var index = rec.column.getEditor().store.findExact('id',value.id);
						if(index !== -1){
	    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value.id)).data.value;
	    				}else{
	    					rec.tdCls = 'gridInputCustomStyle';
	    					return getExaminationTranslation('CLICK_TO_ENTER');
	    				}
					}else{
						var index = rec.column.getEditor().store.findExact('id',value);
						if(index !== -1){
	    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
	    				}else{
	    					rec.tdCls = 'gridInputCustomStyle';
	    					return getExaminationTranslation('CLICK_TO_ENTER');
	    				}
					}
    				
    			}
    			catch(e){
    				return null;
    			}
			}
			else{
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}

	}, {
		header: getPersonModuleTranslation('SANCTION_COMPLETION_DATE'),
		dataIndex: 'sanctionDate',
		flex: 1,
		sortable: true,
		allowBlank: false,
		editor: {
			xtype: 'datefield',
			name: 'sanctionCompletionDate',
			itemId: 'sanctionCompletionDate',
			format:CONSTANTS.DATE_FORMAT,
			maxLength: 100
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return dateRender(val);
			}
		}
	},{
		header: getPersonModuleTranslation('SANCTION_RECALL_DATE'),
		dataIndex: 'sanctionRecallDate',
		flex: 1,
		sortable: true,
		editor: {
			xtype: 'datefield',
			name: 'sanctionRecallDate',
			itemId: 'sanctionRecallDateItemId',
			format:CONSTANTS.DATE_FORMAT,
			maxLength: 100,
		},
		renderer: function(val, rec,date) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return dateRender(val);
			}
		}
	},{
		header: getPersonModuleTranslation('SANCTION_COMPLETE'),
		dataIndex: 'whetherSanctionCompleted',
		flex: 1,
		sortable: true,
		editor: {
			xtype: 'customcombobox',
			name: 'sanctionComplete',
			itemId: 'sanctionCompleteItemId',
			displayField : 'value',
			valueField : 'value',
			maxLength: 100,
			forceSelection: true,
			editable: false,
			listeners: {
				focus: function(combo, eOpt) {
					combo.setRawValue(combo.getValue());
				},
				blur: function(combo, r) {
					combo.setValue(combo.getValue());
				},
				render: function(combo) {
					var store = Ext.create('Academia.store.personinfo.common.disciplinaryactivity.SanctionCompletedStore');
					combo.bindStore(store);
				},
				change: function(combo, eOpt) {
					combo.setRawValue(combo.getValue());
				}
			}
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				if(val == true ||val == 'Yes'){
					return 'Yes';
				}else{
					return 'No';
				}
			}
		}
	},{

		header: getPersonModuleTranslation('APPEAL'),
		dataIndex: 'appealOutcome',
		flex: 1,
		editor: {
			xtype: 'customcombobox',
			name: 'appeal',
			itemId: 'appealItemId',
			store:'personinfo.common.disciplinaryactivity.DisciplinarySUAppealOutcome',
			displayField : 'value',
			valueField : 'id',
			triggerAction: 'all',
			forceSelection: true,
			//queryParam:'name',
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
			minChars:3,
			enableKeyEvents : 'true',
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND')
			} 
		},
		renderer: function(value, rec, record, rowIndex, colIndex, store, view) {
			if(!isNullOrEmpty(value) && value !== '') {
				try{
					if(Ext.isObject(value)){
						var index = rec.column.getEditor().store.findExact('id',value.id);
						if(index !== -1){
	    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value.id)).data.value;
	    				}else{
	    					rec.tdCls = 'gridInputCustomStyle';
	    					return getExaminationTranslation('CLICK_TO_ENTER');
	    				}
					}else{
						var index = rec.column.getEditor().store.findExact('id',value);
						if(index !== -1){
	    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',value)).data.value;
	    				}else{
	    					rec.tdCls = 'gridInputCustomStyle';
	    					return getExaminationTranslation('CLICK_TO_ENTER');
	    				}
					}
    				
    			}
    			catch(e){
    				return null;
    			}
			}
			else{
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			}
		}
	},{
		header: getPersonModuleTranslation('SANCTION_HOURS'),
		dataIndex: 'sanctionHours',
		flex: 1,
		sortable: true,
		editor: {
			xtype: 'numberfield',
			name: 'sanctionHours',
			itemId: 'sanctionHoursItemId',
			maxLength: 100,
			minValue: 0
		},
		renderer: function(val, rec) {
			if (isNullOrEmpty(val)) {
				rec.tdCls = 'gridInputCustomStyle';
				return getExaminationTranslation('CLICK_TO_ENTER');
			} else {
				return val;
			}
		}
	},{
		header: getServiceRequestTranslation('EMM_ADD'),
		dataIndex: 'addButton',
		flex: 0.5,
		cls: 'CustomBodyBtnSettings',
		style:{'text-align':'center'},
		sortable: true,
		renderer: function(value, meta, record) {
			if ((!isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id))
				return "<div class='addButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
			return '';
		}
	}, {
		header: getServiceRequestTranslation('EMM_DELETE'),
		dataIndex: 'deleteButton',
		flex: 0.6,
		cls: 'CustomBodyBtnSettings',
		style:{'text-align':'center'},
		sortable: true,
		renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
			if ((rowIndex > 0 && !isNullOrEmpty(record.data.isAddDeleteRow) && record.data.isAddDeleteRow) || !isNullOrEmpty(record.data.id)) {
				return "<div class='deleteButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
			}else if(rowIndex >= 0 && !isNullOrEmpty(record.data.isAddDeleteRow)){
				return "<div class='deleteButtonClsForGridActionCls' style='margin: 0 auto !important'></div>";
			}
			return '';
		}
	}],
	plugins: {
        ptype: 'cellediting',
        clicksToEdit: 1
    }
});
