/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.personinfo.common.pasthistory.MedicalDetailsForm', {
    //extend: 'Ext.form.Panel',
	extend: 'Academia.view.common.DynamicFieldForm',
	alias: 'widget.medicaldetailsform',
    border: false,
    frame: true,
    title: getPersonModuleTranslation('MD_MEDICAL_DETAILS')+'<p>'+getCommonTranslation('NAVIGATE_TO_NEXT_TAB_MSG')+'</p>',
    cls:'medicalDetailsFormTtitleCls',
    plugins: "formlabelrequired",
    items: [{
        xtype: 'hidden',
        name: 'module',
        value: 'MedicalDetail'
    }, {
        xtype: 'hidden',
        name: 'medicalAidDocumentUploadPath'
    }, {
        xtype: 'hidden',
        itemId: 'documentIdItemId',
        name: 'documentId'
    }, {
        xtype: 'hidden',
        itemId: 'idItemId',
        name: 'id'
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        layout: 'hbox',
        items: [{
            xtype: 'textfield',
            name: 'scheme',
            itemId: 'schemeItemId',
            fieldLabel: getPersonModuleTranslation('MD_SCHEME'),
            allowBlank: false,
            maxLength: 255
        }, {
            xtype: 'textfield',
            name: 'option',
            itemId: 'optionItemId',
            fieldLabel: getPersonModuleTranslation('MD_OPTION'),
            maxLength: 255
        }, {
            xtype: 'textfield',
            name: 'principleMember',
            itemId: 'principleMemberItemId',
            fieldLabel: getPersonModuleTranslation('MD_PRINCIPAL_MEMBER'),
            allowBlank: false,
            maxLength: 255
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        layout: 'hbox',
        items: [{
            xtype: 'textfield',
            name: 'membershipNumber',
            itemId: 'membershipNumberItemId',
            fieldLabel: getPersonModuleTranslation('MD_MEMBERSHIP_NO'),
            allowBlank: false,
            maxLength: 255
        }, {
            xtype: 'datefield',
            name: 'validTill',
            itemId: 'validTillItemId',
            fieldLabel: getPersonModuleTranslation('VALIDTILL_DATE'),
            vtype: 'daterange',
          //--submitFormat: CONSTANTS.SUBMIT_DATE_FORMAT,
            listeners: {
                render: function(obj) {
                    obj = dateFormatRender(obj);
                }
            }
        }, {
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('MD_BLOOD_TYPE'),
            name: 'bloodType',
            itemId: 'bloodTypeItemId',
            store: 'enquiry.studentDetail.BloodGroupStore',
            valueField: 'id',
            displayField: 'value',
            queryMode: 'local',
            editable: false
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        layout: 'hbox',
        items: [{
            xtype: 'textfield',
            name: 'childDependentCode',
            itemId: 'childDependentCodeItemId',
            fieldLabel: getPersonModuleTranslation('MD_CHILD_DEPENDEND_CODE'),
            maxLength: 255
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        layout: 'hbox',
        items: [{
            xtype: 'displayfield',
            name: 'familyPractionerDetails',
            itemId: 'familyPractionerDetailsId',
            value: '<b class="menu-title">' + getPersonModuleTranslation('MD_FAMILY_PRACTIONER_DETAILS') + '</b>'
        }]
    }, {
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 226
    	},
    	//height: 100,
    	layout: 'hbox',
    	items: [{
    		xtype: 'textfield',
    		name: 'familyPractionerName',
    		itemId: 'familyPractionerNameItemId',
    		fieldLabel: getPersonModuleTranslation('NAME'),
    		maxLength: 255
    	}, {
    		xtype: 'customcombobox',
    		name: 'familyPractionerCountryCode',
    		itemId: 'familyPractionerCountryCodeItemId',
    		fieldLabel: getPersonModuleTranslation('MD_CONTACT_NO'),
    		valueField: 'isdCode',
    		displayField: 'isdCode',
    		store: 'common.CountryStore',
    		triggerAction: 'all',
    		forceSelection: true,
    		minChars: 1,
    		//editable: false,
    		width: 100
    	}, {
    		xtype: 'numberfield',
    		name: 'familyPractionerContactNumber',
    		itemId: 'familyPractionerContactNumberItemId',
    		minLength: 0,
    		maxLength: 11,
    		enforceMaxLength: true,
    		hideTrigger: true,
    		keyNavEnabled: false,
    		mouseWheelEnabled: false,
    		allowExponential: false,
    		width: 146,
    		style:{
    			marginTop:'28px'
    		}
    	}]
    }, {
		xtype: 'fieldcontainer',
		layout: 'hbox',
		defaults: {
			labelAlign: 'top',
			width: 226
		},
		items: [{
	        xtype: 'filefield',
	        name: 'file',
	        itemId: 'medicalAidDocumentItemId',
	        fieldLabel: getPersonModuleTranslation('MD_MEDICAL_AID_DOCUMENT'),
	        buttonText: getPersonModuleTranslation('BROWSE'),
	        ui: 'CustomBtnSubmit',
	        width: 226,
	        labelAlign: 'top',
	        listeners: {
	            specialkey: function(me, e) {
	                if (e.getKey() == e.TAB) {
	                    e.stopEvent();
	                }
	            }
	        }
	    }, {
	    	xtype: 'displayfield',
	        itemId: 'availableDocumentLabelItemId',
//	        name: 'availableDocumentLabel',
	        value: '<a href=#><b class="menu-title">' + getPersonModuleTranslation('MD_VIEW_DOCUMENT') + '</b></a>',
	        hidden: true,
	        style: {
	            marginTop: '24px',
	            textDecoration: "underline"
	        }
		}]
	}, {
        xtype: 'fieldcontainer',
        style: {
            marginLeft: '-2px'
        },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }]
    },{
        xtype: 'fieldcontainer',
        items: [{
            xtype: 'button',
            text: getCommonTranslation('NEXT'),
            itemId: 'medicalDetailNextButtonId',
            buttonAlign: 'right',
            hidden:true,
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            //formBind: true   as per requirement need to skip this form even if mandatory fields are not being filled
        }]
    }]
});