/**
 * @author dharmendra.p
 * Medical History Form 
 */
Ext.define('Academia.view.personinfo.common.pasthistory.PatentDetailsForm', {
   //extend: 'Ext.form.Panel',
	extend:'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.patentdetailsform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
    initComponent: function() {
    	if(this.itemId === 'studentPatentDetailsForm'){
		    Ext.apply(this,{
		    	customFieldEntity:CONSTANTS.PERSON_PATENT_DETAIL,
    		    columns: 2
		    });  
		}
    	this.callParent(arguments);
    },
    items: [{
        xtype: 'hidden',
        itemId: 'patent_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        name: 'version'
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        layout: {
            type: 'hbox'
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getPersonModuleTranslation('PATENT_TYPE'),
            store:'personinfo.common.pasthistory.PatentTypeStore',
            itemId:'patentTypeSMId',
            valueField: 'id',
            displayField: 'value',
            name: 'patentType',
            editable: false,
            allowBlank: false,
            forceSelection:true
        }, {
            xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('PATENT_NAME'),
            name: 'patentName',
            allowBlank:false
        }]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        layout: {
            type: 'hbox'
        },
        items: [{
			xtype : 'datefield',
			fieldLabel : getPersonModuleTranslation('DATE_OF_PATENT_FILED'),
			name : 'dateOfPatentFiled',
			itemId:'dateOfPatentFiled',	
			endDateField : 'dateOfPatentAwarded',
			listeners: {
				render: function(field) {
					return dateFormatRender(field);
				}
			},
			//--submitFormat : CONSTANTS.DATE_FORMAT,
			vtype : 'daterange',
			allowBlank:false
		},{
			xtype : 'datefield',
			fieldLabel : getPersonModuleTranslation('DATE_OF_PATENT_AWARDED'),
			name : 'dateOfPatentAwarded',
			itemId:'dateOfPatentAwarded',
			startDateField : 'dateOfPatentFiled',
			listeners: {
            	  render: function(field) {
            		  return dateFormatRender(field);
            	  }
              },
            //--submitFormat : CONSTANTS.DATE_FORMAT,
			vtype : 'daterange',
			allowBlank:false
		}
		]
    },{
        xtype: 'fieldcontainer',
        layout: 'vbox',
        defaults: {
            labelAlign: 'top',
            width: 460
        },
        items: [{
            xtype: 'textareafield',
            name: 'otherDetails',
            fieldLabel: getPersonModuleTranslation('OTHER_DETAILS')
        }]
    },{
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        layout: {
            type: 'hbox'
        },
        items: [{
			xtype: 'multiselectcombofield',
			fieldLabel : getCommonTranslation('SUPERVISORS'),
			name: 'supervisor',
			itemId: 'supervisor',
			autoloadStore: false,
			width : 226,
			store:'common.AllUserBySmartSearch',
			displayField : 'value',
			valueField : 'id',
			queryParam:'codeOrName',
			minChars:3,
            typeAhead:true,
			triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			queryMode:'remote',
			enableKeyEvents  : 'true',
			hideTrigger:false,
			forceSelection:true,
			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		     listConfig: {
			listeners: {
			beforeshow: function(picker) {
			picker.minWidth = picker.up('combobox').getSize().width;
			}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
			return '<div class="search-item">' +
			'{code}' +
			'</div>';
			}
			}
			},{
				xtype : 'datefield',
				fieldLabel : getCommonTranslation('DEFENCE_DATE'),
				name : 'defenceDate',
				itemId:'defenceDate',
				width : 226,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},
				vtype : 'daterange'
			}]
    }, {
        xtype: 'fieldcontainer',
        width: 'auto',
        defaults: {
            labelAlign: 'top',
            width: 460
        },
        layout: {
            type: 'hbox'
        },
        items: [{
				xtype: 'textareafield',
				name: 'remarks',
				itemId:'remarks',
				fieldLabel: getCommonTranslation('PATENT_REMARKS'),
				maxLength:255
			}]
    }, {
		xtype:'patenttypedocument',
		itemId:'patentTypeDocument',
		style:{marginTop:'10px',marginLeft:'0px'},
		width:250
	},{
        xtype: 'fieldcontainer',
        width: '100%',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        },{
			 xtype: 'button',
			 //width:460,
//			 name: 'courseSyllabus',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'uploadDocItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]
});