/**
 * @author Prakash Sharma
 */
Ext.define('Academia.view.personinfo.common.pasthistory.SocioEconomicInformationForm', {
	extend:'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.socioeconomicinformationform',
    title: getPersonModuleTranslation('SOCIO_ECONOMIC_INFORMATION'),
    customFieldEntity:CONSTANTS.SOCIO_INFORMATION_CD,
    autoScroll: true,
	cls:'horizontal-scrolling-fix',
	bodyPadding:'10 10 10 10',
	columns: 3,
	frame:true,
	style:{
		marginLeft:CONSTANTS.MARGIN_LEFT_FOR_FORM
	},
	itemId:'socioeconomicinformationformItemId',
	plugins : "formlabelrequired",
	method: 'POST',
    
   /* initComponent: function() {
    	
    },*/
   /* listeners:{
    	beforeRender: function(){
    		Ext.apply(this,{
				customFieldEntity:CONSTANTS.SOCIO_INFORMATION_CD,
        		columns:1
			});
    	}
    },*/
    items: [{
        xtype: 'hidden',
        itemId: 'socioEconomic_hidden_field',
        name: 'id'
        	
    }, {
			xtype:'panel',
			layout:'vbox',
			cls: 'panelNoSpace',
			items:[{
			         xtype: 'fieldcontainer',
			         itemId:'socioFieldsContainer1',
			         defaults: {
			             labelAlign: 'top',
			             width: 930
			         },
			         layout: 'hbox',
			         items: [{
			        	 	xtype : 'customcombobox',
							fieldLabel : getPersonModuleTranslation('HIGHEST_QUALIFICATION_PARENT1'),
							name : 'parentQualification1',
							itemId : 'parentQualification1',
							valueField: 'id',
							displayField: 'value',
							width:300,
							forceSelection:true,		
							editable:false,
							listeners  :{
								render : function(combo){
									var store=Ext.create('Academia.store.common.StoSocioEconomicHighestQualiStore');
									combo.bindStore(store)
								}
							}
						
			         }, {
			        	 	xtype : 'customcombobox',
							fieldLabel : getPersonModuleTranslation('HIGHEST_QUALIFICATION_PARENT2'),
							name : 'parentQualification2',
							itemId : 'parentQualification2',
							valueField: 'id',
							displayField: 'value',
							width:300,
							editable:false,
							typeAhead:true,
							forceSelection:true,
							listeners  :{
								render : function(combo){
									var store=Ext.create('Academia.store.common.StoSocioEconomicHighestQualiStore');
									combo.bindStore(store)
								}
							}
						
			         }, {
			        	 	xtype : 'customcombobox',
							fieldLabel : getPersonModuleTranslation('CHILD_BENEFIT_FROM_GOVT'),
							name : 'receivedChildBenefit',
							itemId : 'receivedChildBenefit',
							valueField: 'id',
							displayField: 'value',
							width:300,
							editable:false,
							typeAhead:true,
							forceSelection:true,
							listeners  :{
								render : function(combo){
									var store=Ext.create('Academia.store.common.StoAdmSocioEconomicChildBenefitStore');
									combo.bindStore(store)
								}
							}
						
			         }]
			     },{
			         xtype: 'fieldcontainer',
			         itemId:'socioFieldsContainer2',
			         defaults: {
			             labelAlign: 'top',
			             width: 930
			         },
			         layout: 'hbox',
			         items: [{
			        	 	xtype : 'customcombobox',
							fieldLabel : getPersonModuleTranslation('SOCIAL_PENSION'),
							name : 'socialPension',
							itemId : 'socialPension',
							valueField: 'id',
							displayField: 'value',
							width:300,
							editable:false,
							typeAhead:true,
							forceSelection:true,
							listeners  :{
								render : function(combo){
									var store=Ext.create('Academia.store.common.StoAdmSocioEconomicSocialPensionStore');
									combo.bindStore(store)
								}
							}
						
			         }, {
			        	 	xtype : 'customcombobox',
							fieldLabel : getPersonModuleTranslation('PAY_FOR_YOUR_STUDY'),
							name : 'payStudy',
							itemId : 'payStudy',
							valueField: 'id',
							style:{'margin-bottom':'10px'},
							displayField: 'value',
							width:300,
							editable:false,
							typeAhead:true,
							forceSelection:true,
							listeners  :{
								render : function(combo){
									var store=Ext.create('Academia.store.common.StoAdmSocioEconomicPayForStore');
									combo.bindStore(store)
								}
							}
						
			         }, {
			        	 	xtype : 'customcombobox',
							fieldLabel : getPersonModuleTranslation('PARENT_ANNUAL_INCOME'),
							name : 'parentAnnualIncome',
							itemId : 'parentAnnualIncome',
							style:{'margin-bottom':'10px'},
							valueField: 'id',
							displayField: 'value',
							editable:false,
							width:300,
							typeAhead:true,
							forceSelection:true,
							listeners  :{
								render : function(combo){
									var store=Ext.create('Academia.store.common.StoAdmSocioEconomicAnnualIncomeStore');
									combo.bindStore(store)
								}
							}
						
			         }]
			     },{
			         xtype: 'fieldcontainer',
			         itemId:'socioFieldsContainer3',
			         defaults: {
			             labelAlign: 'top',
			             width: 930
			         },
			         layout: 'hbox',
			         items: [{
			        	   xtype: 'textfield',
			               fieldLabel: getPersonModuleTranslation('PARENT_OCCUPATION'),
			               width:300,
			               itemId: 'parentOccupation',
			               name: 'parentOccupation'
						
			         }, { 
			        	   xtype: 'textfield',
			               fieldLabel: getPersonModuleTranslation('EMPLOYER'),
			               width:300,
			               itemId: 'employer',
			               name: 'employer'
						
			         }, {
			        	 	xtype : 'customcombobox',
							fieldLabel : getPersonModuleTranslation('NSFAS_HOLDER'),
							name : 'nSFASHolder',
							itemId : 'nSFASHolder',
							valueField: 'id',
							displayField: 'value',
							width:300,
							editable:false,
							typeAhead:true,
							forceSelection:true,
							listeners  :{
								render : function(combo){
									var store=Ext.create('Academia.store.common.StoAdmSocioEconomicNSFASHolderStore');
									combo.bindStore(store)
								}
							}
						
			         }]
			     },{
			         xtype: 'fieldcontainer',
			         itemId:'socioFieldsContainer4',
			         defaults: {
			             labelAlign: 'top',
			             width: 310
			         },
			         layout: 'hbox',
			         items: [{
			            	   xtype : 'customcombobox',
								fieldLabel : getPersonModuleTranslation('FINACIAL_SUPPORT_RECEIVED'),
								name : 'schoolFeePerYear',
								itemId : 'schoolFeePerYear',
								valueField: 'id',
								displayField: 'value',
								width:300,
								editable:false,
								typeAhead:true,
								forceSelection:true,
								listeners  :{
									render : function(combo){
										var store=Ext.create('Academia.store.common.StoAdmSocioEconomicFeePerYearStore');
										combo.bindStore(store)
									}
								}
						
						
			         }]
			     },{
			         xtype: 'fieldcontainer',
			         itemId:'socioFieldsContainer5',
			         defaults: {
			             labelAlign: 'top',
			             width: 310
			         },
			         layout: 'hbox',
			         items: [{
			            	   xtype : 'customcombobox',
								fieldLabel : getPersonModuleTranslation('SCHOLARSHIP_BASED_ON_FINANCIAL_NEED'),
								name : 'isScholarship',
								itemId : 'isScholarship',
								valueField: 'id',
								displayField: 'value',
								style:{'margin-bottom':'10px'},
								editable:false,
								width:300,
								typeAhead:true,
								forceSelection:true,
								listeners  :{
									render : function(combo){
										var store=Ext.create('Academia.store.common.StoAdmSocioEconomicFinancialNeedStore');
										combo.bindStore(store)
									}
								}
						
			         }]
			     }
			     ]
		}
    ,{
        xtype: 'fieldcontainer',
        style: {
            marginLeft: '-2px',
            marginTop: '5px'
        },
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            name:'submitButton',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
            //hidden: true
        }]
    }]
});