/**
 * @Author Amit G
 */
Ext.define('Academia.view.personinfo.common.pasthistory.StudentLanguageInformationGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.studentlanguageinformationgrid',
	title: getCommonTranslation('LANGUAGE_INFORMATION'),
	border: true,
	selType:'checkboxmodel',
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: true,
		checkOnly : false,
		renderer: function(value, metaData, record, rowIndex, colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix + 'grid-cell-special ' + baseCSSPrefix + 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix + 'grid-row-checker">&#160;</div>';
		}
	},
	autoScroll: false,
	/*defaults:{
        width:'100%'
    },
    layout:'vbox',*/
    viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
    isGridConfigurable: true,
	enableColumnHide: false,
    tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation('ADD'),
		glyph: ICONGLYPH.ADDGLYPH,
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation('EDIT'),
		glyph: ICONGLYPH.EDITGLYPH,
		hasDisableForProfileViewMode: true
	}, {
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon',
		hasDisableForProfileViewMode:true
	}, {
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH,
		hasDisableForProfileViewMode:true
	}],

	columns: [ {
		header: getCommonTranslation('LANGUAGE'), 
		dataIndex: 'languageName',
		sortable: true,
		flex: .2,
		renderer:function(value, meta, record){
        if(!isNullOrEmpty(value)) {
              return record.data.language.value;
          } 
		 }
	}, {
		header: getCommonTranslation('PRIMARY_LANGUAGE'), 
		dataIndex: 'isPrimaryLanguage',
		sortable:true,
		flex: .2
	}, {
		header: getCommonTranslation('YEARS_OF_EDUCATION'), 
		dataIndex: 'yearOfEducation',
		sortable:true,
		flex: .2

	}, {
		header: getCommonTranslation('LANGUAGE_EXAM_TYPE'), 
		dataIndex: 'languageExamTypeName',
		sortable:true,
		flex: .2

	}, {
		header: getCommonTranslation('OTHER_LANGUAGE_EXAM_TYPE'), 
		dataIndex: 'otherLanguageExamType',
		sortable:true,
		flex: .2,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){			
			if(!isNullOrEmpty(record.data.otherLanguageExamType)){
				if(record.data.otherLanguageExamType.length > 31) {
					metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(record.data.otherLanguageExamType) + '"';
					metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 16px;max-height: 56px;min-width: 1ch;max-width: 30ch;';
					metaData.tdCls ="student-thesis-column-cls";
				}
				return record.data.otherLanguageExamType;					
			}
		}
	},{
		header: getCommonTranslation('LANGUAGE_EXAM_DATE'), 
		dataIndex: 'studentLanguageExamDate',
		sortable:true,
		flex: .2

	},{
		header: getCommonTranslation('OVERALL_SCORE'), 
		dataIndex: 'overAllScore',
		sortable:true,
		flex: .2,
		renderer:function(value, metaData, record, rowIdx, colIdx, store){			
			if(!isNullOrEmpty(record.data.overAllScore)){
				if(record.data.overAllScore.length > 31) {
					metaData.tdAttr = 'data-qtip="' + Ext.htmlEncode(record.data.overAllScore) + '"';
					metaData.style = 'text-align: left;overflow: hidden;display: -webkit-box;-webkit-line-clamp: 3;-webkit-box-orient: vertical;line-height: 16px;max-height: 60px;min-width: 1ch;max-width: 30ch;';
					metaData.tdCls ="student-thesis-column-cls";
				}
				return record.data.overAllScore;					
			}
		}
	},{
		header: getCommonTranslation('DOCUMENTS'), 
		dataIndex: 'languageDocument',
		sortable:true,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.data.languageDocument.length)) {
				if(record.data.languageDocument.length>1) {					
					return '<a href=#>'+record.data.languageDocument.length+'<a>';
				} else if(record.data.languageDocument.length==1) {
					var pathSplit=record.data.languageDocument[0].path.split('/');
		            var newPath=pathSplit[2];
					var newName=record.data.languageDocument[0].name;
					var newValue=newName!=null?newName:newPath;
					return '<a href=#>'+newValue+'<a>';
				} 
			}                        
		}
	},{

		header: getCommonTranslation('DOCUMENT_URL'),
		dataIndex: 'languageDocumentUrl',
		sortable:true,
		flex: .2,
		renderer:function(value, meta, record){
			if(!isNullOrEmpty(record.data.languageDocumentUrl.length)) {
				if(record.data.languageDocumentUrl.length>1) {					
					return '<a href=#>'+record.data.languageDocumentUrl.length+'<a>';
				} else if(record.data.languageDocumentUrl.length==1) {
					var newPath=record.data.languageDocumentUrl[0].path;
					var newName=record.data.languageDocumentUrl[0].name;
					var newValue=newName!=""?newName:newPath;
				    return "<a href="+newPath+" target='_blank'>"+newValue;
				    
				} 
			}                        
		} 
	  
	}],

    initComponent: function() {
    	var this$ = this;
    	var store = this$.buildStore();
    	Ext.apply(this$, {
    		store: store,
    		dockedItems: [{
    			xtype: 'toolbar',
    			dock: 'bottom',
    			items: [{
    				xtype: 'custompagingtoolbar',
    				plugins: ['pagesize'],
    				store: store,
    				emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
    				displayInfo: true
    			}]
    		}]
    	});
    	this$.addExportToolBarItems(this$);
    	this$.callParent(arguments);
    },
    buildStore: function() {
    	return Ext.create('Academia.store.personinfo.common.pasthistory.StudentLanguageInfoStore');
    }
});