Ext.define('Academia.view.personinfo.common.pasthistory.TrainingDetailsGrid', {
    extend: 'Ext.grid.Panel',
    alias: 'widget.trainingdetailsgrid',
    store: 'personinfo.common.pasthistory.TrainingStore',
    title: getPersonModuleTranslation('TRAINING_DETAILS'),// : 'Training Details',
    border: true,
    autoScroll: true,
    viewConfig: {
        stripeRows: true
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
        	 xtype: 'custompagingtoolbar',
             plugins:['pagesize'],
            store: 'personinfo.common.pasthistory.TrainingStore',
            emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
            displayInfo: true
        }]
    }],

    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH
    }],
    columns: [{
        header: getPersonModuleTranslation('TRAINING_NAME'), //:'Training Name',
        dataIndex: 'trainingName',
        sortable:true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('CATAGORY_TRAINING'), // : 'Catagory of Training',
        dataIndex: 'catagory',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('FROM_DATE'), // : 'From Date',
        dataIndex: 'fromDate',
        sortable:true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getPersonModuleTranslation('To_Date'), // : 'To Date',
        dataIndex: 'toDate',
        sortable:true,
        flex: .2,
		renderer:function(date) {
			return dateRender(date);
		}
    }, {
        header: getPersonModuleTranslation('WORK'),//'Work ',
        dataIndex: 'work',
        sortable:true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('ORGANIZATION_TRANING'), // : 'Organization Doing The Training',
        dataIndex: 'organization',
        sortable:true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('REMARK'), //'Remark',
        dataIndex: 'remark',
        sortable:true,
        flex: .2
    }]

});