/**
 * This view is used for the student credit Bills records.
 * @author Priyanshi
 */
Ext.define('Academia.view.personinfo.common.paymentandrefund.CreditNoteGridForStudentPortal', {
	//extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	store:'personinfo.common.paymentandrefund.PendingCreditStore',
	alias: 'widget.creditnotegridforstudentportal',
	title: getCommonTranslation('BILL_PAYABLE'),
	border: true,
	autoScroll: false,
	viewConfig: { 
		stripeRows: false
	},
	refreshStoreData:true,
	selType : 'checkboxmodel',
	isGridConfigurable: true,
	enableColumnHide: false,
	selModel : {
		mode : 'MULTI',
		showHeaderCheckbox : true,
		allowDeselect : true,
		checkOnly : true,
		renderer : function(value, metaData, record, rowIndex,
				colIndex, store, view) {
			var baseCSSPrefix = Ext.baseCSSPrefix;
			metaData.tdCls = baseCSSPrefix
			+ 'grid-cell-special ' + baseCSSPrefix
			+ 'grid-cell-row-checker';
			return '<div class="' + baseCSSPrefix
			+ 'grid-row-checker">&#160;</div>';
		}
	},
	features: [{
		ftype: 'summary',
		showSummaryRow:CONSTANTS.SHOW_SUMMARY_ROW 
	}],
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'personinfo.common.paymentandrefund.PendingCreditStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		}]
	}],
	initComponent: function() {
		var grid=this;                   
		grid.addExportToolBarItems(grid,false);
		this.callParent(arguments);     
	},
	tbar: [{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation('VIEW'),
		iconCls: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnStudentPrintTaxCertificatePortal',
		text : getFeeAndPaymentCommonTranslation('PRINT_TAX_CERTIFICATE'),
		tooltip: getFeeAndPaymentCommonTranslation('PRINT_TAX_CERTIFICATE')
	},'->',{
		xtype: 'button',
		itemId: 'btnPrint',
		disabled : true,
		icon: 'resources/images/print1.png',
		tooltip: getFeeAndPaymentCommonTranslation('Print')
	}],
	columns: [{
		header: getCommonTranslation('CREDIT_NOTE_NO'),
		dataIndex: 'billNo',
		sortable: true,
		flex: .2,
		renderer: function(value, metaData, record, rowIndex, colIndex, view) {
			metaData.style = "white-space: normal;";
			return value;
		},
		summaryRenderer:function(value, summaryData, dataIndex, rowIndex, colIndex, store, view){
			if(portalId==1){
				if(!isNullOrEmpty(store.data.items[0].data.baseCurrencyId)) {
					return getFeeAndPaymentCommonTranslation('TOTAL')+" ("+"In "+store.data.items[0].data.baseCurrencyName+")";
				} else {
					return getFeeAndPaymentCommonTranslation('TOTAL');
				}
			}else{
				//if(!isNullOrEmpty(store.data.items[0].data.baseCurrencyId)) {
					return getFeeAndPaymentCommonTranslation('TOTAL');
			//	}
			}
		}
		/*summaryRenderer: function(value, summaryData, dataIndex) {
	          return getFeeAndPaymentCommonTranslation('TOTAL');
	      }*/
	},{
		header: getCommonTranslation('CREDIT_NOTE_DATE'),
		dataIndex: 'billDate',
		flex: .2,
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			}
		}
	},{
		header: getCommonTranslation('BILL_DUE_DATE'),
		dataIndex: 'dueDate',
		flex: .2,
		renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			}
		}
	}, {
		header: getCommonTranslation('CREDIT_NOTE_TYPE'),
		dataIndex: 'raiseBillType',
		flex: .2,
		renderer: function(value){
			if(!isNullOrEmpty(value)){
				value = getCommonTranslation(value);
			}
			return value;
		}
	},{
		header: getCommonTranslation('DISCOUNT_AMOUNT'),
		dataIndex: 'discount',
		flex: .2,
		summaryType: 'sum',



		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
			if(portalId ==1){
				if(store.data.items[0].data.baseCurrencyId==null){
					return currencyRenderer(value,record.get("currencyId"));
				}
				return " ";
			}else{
				return Ext.util.Format.currency(value,'',record.get("currencyId"),false);
			}
		}

		/*	
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  value;
		}*/
	},
	{

		header : getCommonTranslation('CURRENCY_EXCHANGE_RATE_DETAIL'),
		dataIndex : 'currencyExchangeRate',
		flex : .3,

	},
	{
		header: getCommonTranslation('BILL_ABLE_AMOUNT'),
		dataIndex: 'feeAmount',
		flex: .2,
		summaryType: 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
			if(portalId ==1){
				if(store.data.items[0].data.baseCurrencyId==null){
					return currencyRenderer(value,record.get("currencyId"));
				}
				return " ";
			}else{
				//return currencyRenderer(value,record.get("currencyId"));
				return currencyRenderer(value,store.data.items[0].data.currencyId);
			}
		}

		/*	renderer:function(value, metaData, record, row, col, store, gridView){
				if(!isNullOrEmpty(value)){
					return currencyRenderer(value,record.get("currencyId"));
				}
			},
			align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
			summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
				return  value;
			}*/
	},{
		header : getCommonTranslation('CONVERTED_AMOUNT'),
		dataIndex : 'convertedAmount',
		flex : .3,
		summaryType: 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("baseCurrencyId"));
			}
		},
		summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
			//return Ext.util.Format.currency(value,'',record.get("baseCurrencyId"),false);
			//return Ext.util.Format.currency(value,'',store.data.items[0].data.baseCurrencyId,false);
			return currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
		}

		/*renderer:function(value, metaData, record, row, col, store, gridView){
				if(!isNullOrEmpty(value)){
					//return currencyRenderer(value,record.get("currencyId"));
					return record.get("baseCurrencyCode") + " "+value;
				}
			}*/
	}, /*{
		header: getPersonModuleTranslation('BILL_VIEW'),
		dataIndex: 'billView',
		flex: .2
	} ,{
		header: getPersonModuleTranslation('BILL_GENERATION_TYPE'),
		dataIndex: 'billGenerationType',
		flex: .2
	},*/ {
		header: getCommonTranslation('BALANCE_AMOUNT'),
		dataIndex: 'balanceAmount',
		flex: .2,
		summaryType: 'sum',/*//AS PER DISCUSSION WITH NAVIN SIR AND STORY-89564
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
			return currencyRenderer(value,record.get("currencyId"));
			}
			},
			summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
			//return Ext.util.Format.currency(value,'',record.get("currencyId"),false);
				return currencyRenderer(value,store.data.items[0].data.currencyId);
			}*/
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
			if(portalId ==1){
				if(store.data.items[0].data.baseCurrencyId==null){
					return currencyRenderer(value,record.get("currencyId"));
				}
				return " ";
			}else{
				//return Ext.util.Format.currency(value,'',record.get("currencyId"),false);
				return currencyRenderer(value,store.data.items[0].data.currencyId);
			}
		}
	},{
		header : getCommonTranslation('CONVERTED_BALANCE_AMOUNT'),
		dataIndex : 'convertedBalanceAmount',
		flex : .3,
		summaryType: 'sum',
		renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)){
				return currencyRenderer(value,record.get("baseCurrencyId"));
			}
		},
		summaryRenderer: function (value, metaData, record, row, col, store, gridView) {
			return currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
		}
	}, {
		header: getCommonTranslation('CREDIT_NOTE_CURRENCY'),
		dataIndex: 'currencyName',
		flex: .2,
		hidden:true
	}],
});