/**
 *
 * @author priyanshi sharma
 */
Ext.define('Academia.view.personinfo.common.paymentandrefund.FundingAndMonitoringGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.fundingandmonitoringgrid',
	title: getPersonModuleTranslation('FUNDING_AND_MONITORING'),
	border: true,
	viewConfig: {
		stripeRows: true
	},
	initComponent: function() {    	     
    	var grid=this;
    	grid.addExportToolBarItems(grid);
    	var store=Ext.create('Academia.store.personinfo.common.paymentandrefund.FundingAndMonitoringStore');
    	Ext.apply(this, {
    		store: store        
    	});
    	this.callParent(arguments);
    	var custompagingtoolbar=grid.down('custompagingtoolbar');
    	if(custompagingtoolbar){
    		custompagingtoolbar.bindStore(store);        	
    	}
    },
	tbar: [{
		xtype: 'button',
		itemId: 'btnAdd',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	}, {
		xtype: 'button',
		itemId: 'btnEdit',
		tooltip: getCommonTranslation("EDIT"),
		glyph: ICONGLYPH.EDITGLYPH
	},{
		xtype: 'button',
		itemId: 'btnView',
		tooltip: getCommonTranslation("VIEW"),
		glyph: 'view-icon'
	},{
		xtype: 'button',
		itemId: 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip: getCommonTranslation("DELETE"),
		glyph: ICONGLYPH.DELETEGLYPH
	}],
	columns: [{
		header: getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex: .2
	}, {
		header: getCommonTranslation('FUNDING_BODY'),
		dataIndex: 'fundingBody',
		flex: .2
	},{
		header: getCommonTranslation('NON-REGULATED_FEE_FLAG'),
		dataIndex: 'nonRegulatedFeeFlag',
		flex: .2
	},{
		header: getCommonTranslation('FUNDING_LENGTH'),
		dataIndex: 'fundingLength',
		flex: .2
	},{
		header: getCommonTranslation('FUNDING_COMPLETION'),
		dataIndex: 'fundingCompletion',
		flex: .2
	},{
		header: getCommonTranslation('EQUIVALENT_OR_LOWER_QUALIFICATION'),
		dataIndex: 'equivalentOrLowerQualification',
		flex: .2
	}]
});