/**
 * This form is used for student faculty post dated cheque
 * @author Sachin.Bangar 
 */
Ext.define('Academia.view.personinfo.common.paymentandrefund.PostDatedChequeGrid', {
    //extend: 'Ext.grid.Panel',
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.postdatedchequegrid',
    title: getPersonModuleTranslation('POST_DATED_CHEQUE'),
    border: true,
    viewConfig: {
        stripeRows: true
    },
    /*tbar: [{
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }],*/
    features: [{
    	ftype: 'summary',
    	showSummaryRow:false 
    }],
    columns: [{
        header: getPersonModuleTranslation('RECEIPT_DATE'),
        dataIndex: 'transactionDate',
        flex: .2,
        renderer:function(value){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			}                        
		},
		 summaryRenderer:function(value, summaryData, dataIndex, rowIndex, colIndex, store, view){
				if(portalId==1){
					 if(!isNullOrEmpty(store.data.items[0].data.baseCurrencyId)) {
						  return getFeeAndPaymentCommonTranslation('TOTAL')+" ("+"In "+store.data.items[0].data.baseCurrencyName+")";
					  } else {
						  return getFeeAndPaymentCommonTranslation('TOTAL');
					  }
				}else{
					if(store.data.items[0].data.whetherDisplayTotal != false && !isNullOrEmpty(store.data.items[0].data.baseCurrencyId)) {
						  return getFeeAndPaymentCommonTranslation('TOTAL');
					  }
				}
			  }
		/*summaryRenderer: function(value, summaryData, dataIndex) {
			return getFeeAndPaymentCommonTranslation('TOTAL');
		}*/
    },{
        header: getPersonModuleTranslation('RECEIPT_NUMBER'),
        dataIndex: 'receiptNo',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('AMOUNT'),
        dataIndex: 'amount',
        flex: .2,
        renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("currencyId"));
			}
		},
		summaryType: 'sum',
		//align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			if(portalId ==1){
				if(store.data.items[0].data.baseCurrencyId==null){
					return currencyRenderer(value,store.data.items[0].data.currencyId)
				}
				return " ";
			}else{
				if(store.data.items[0].data.whetherDisplayTotal != false){
		        	return currencyRenderer(value,store.data.items[0].data.currencyId);					
				}
			}
		}
    },{
        header: getPersonModuleTranslation('CURRENCY_EXCHANGE_RATE'),
        dataIndex: 'currencyExchangeRate',
        flex: .2
    },{
        header: getPersonModuleTranslation('CONVERTED_AMOUNT'),
        dataIndex: 'convertedAmount',
        flex: .2,
        renderer:function(value, metaData, record, row, col, store, gridView){
			if(!isNullOrEmpty(value)) {
				return currencyRenderer(value,record.get("baseCurrencyId"));
			}
		},
		summaryType: 'sum',
		align: CONSTANTS.AMOUNT_COLUMN_ALIGN,
		summaryRenderer: function (value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
			return  currencyRenderer(value,store.data.items[0].data.baseCurrencyId);
		}
    }, {
        header: getPersonModuleTranslation('INSTRUMENT_NUMBER'),
        dataIndex: 'instrumentNo',
        flex: .2
    }, {
        header: getPersonModuleTranslation('INSTRUMENT_DATE'),
        dataIndex: 'instrumentDate',
        flex: .2,
        renderer:function(value,meta){
			if(!isNullOrEmpty(value)) {
				return dateRender(value);
			}                        
		}
    }, {
        header: getPersonModuleTranslation('DRWAN_ON_BANK'),
        dataIndex: 'bankName',
        flex: .2,
        renderer : function(value, metaData, record,
				row, col, store, gridView) {
			if (record.data.bankName==null) {
				return 'Others';
			} else {
				return value;
			}
		}
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.addExportToolBarItems(this$);
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.paymentandrefund.PostDatedChequeStore');
    }
});