Ext.define('Academia.view.personinfo.common.personalinfo.ApplicantVisaDocumentListGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.applicantvisadocumentlistgrid',
	store :'personinfo.common.personalinfo.ApplicantVisaDocumentGridStore',
	border: true,
	//autoScroll: true,
	height:'60%',
	//frame:false,
	enableColumnHide :false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	title : getCommonTranslation('LIST_OF_DOCUMENTS'),
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'personinfo.common.personalinfo.ApplicantVisaDocumentGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;
	this.callParent(arguments);
	},
	
	tbar: [{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
				
	},'->',{
		xtype : 'button',
		itemId : 'downloadDocumentItemId',
		tooltip : getCommonTranslation('DOWNLOAD_ALL'),
		text : getCommonTranslation('DOWNLOAD_ALL'),
		formBind:true,
	}],
	columns :[{
		header : getCommonTranslation('S_NO'),
		xtype: 'rownumberer',
		align: 'left',
		flex: 0.5,
		renderer: function(value, metaData, record, rowIndex){
			return "<span style='padding-left: 6px;'>" + (rowIndex + 1) + "</span>";
		}
	},{
		header : getCommonTranslation('DOCUMENTS'),
		dataIndex : 'documentName',
		flex:1,
		sortable:false,
		renderer:function(value, metaData, record){
			if(record){
				var pathSplit=record.data.path.split('/');
	            var newPath=pathSplit[2];
				var newvalue=value!=null?value:newPath;
				return "<a href='#'>"+newvalue+"</a>";
			}
		}
	},{
		header : getCommonTranslation('UPLOADED_ON'),
		dataIndex : 'submissionDate',
		sortable:false,
		flex:1,
		renderer: function(date) {
            return dateRender(date);
        }
	}]
});