/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.personinfo.common.personalinfo.FeePayerDetailGrid', {
    //  extend: 'Ext.grid.Panel',
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.feepayerdetailgrid',
    title: getPersonModuleTranslation('LIST_OF_FEE_PAYERS'),
    border: true,
    collapsible: true,
    viewConfig: {
        stripeRows: true
    },
    tbar: [{
        xtype: 'button',
        itemId: 'btnAdd',
        tooltip: getCommonTranslation('ADD'),
        glyph: ICONGLYPH.ADDGLYPH,
        hasDisableForProfileViewMode: true
    }, {
        xtype: 'button',
        itemId: 'btnEdit',
        tooltip: getCommonTranslation('EDIT'),
        glyph: ICONGLYPH.EDITGLYPH,
        hasDisableForProfileViewMode: true
    }, {
        xtype: 'button',
        itemId: 'btnView',
        tooltip: getCommonTranslation('VIEW'),
        iconCls: 'view-icon'
    }, {
        xtype: 'button',
        itemId: 'btnDelete',
        cls: 'CustomToolbarBtnReject',
        tooltip: getCommonTranslation('DELETE'),
        glyph: ICONGLYPH.DELETEGLYPH,
        hasDisableForProfileViewMode: true
    }],
    columns: [{
        header: getPersonModuleTranslation('FPD_FEE_PAYER_NAME'),
        dataIndex: 'payerName',
        sortable: false,
        flex: .2
    }, {
        header: getPersonModuleTranslation('FPD_FEE_PAYER_TYPE'),
        dataIndex: 'payerType',
        sortable: true,
        flex: .2,
        renderer: function(val) {
            var value = '';
            if (val == 'PERSON') {
                value = getPersonModuleTranslation('FPD_PERSON');
            } else if (val == 'CORPORATE') {
                value = getPersonModuleTranslation('FPD_CORPORATE');
            }else if (val == 'STUDENT') {
            	 value = getPersonModuleTranslation('FPD_STUDENT');
			}
            return value;
        }
    }, {
        header: getPersonModuleTranslation('FPD_WORK_TELEPHONE'),
        dataIndex: 'workTelephone',
        sortable: true,
        flex: .2,
        renderer: function(value, metaData, record) {
            var mergeValue = '';
            if (!isNullOrEmpty(record.data.workTelephoneCountryCode)) {
                if (!isNullOrEmpty(value)) {
                    mergeValue = record.data.workTelephoneCountryCode + " " + value;
                } else {
                    mergeValue = record.data.workTelephoneCountryCode;
                }
            } else if (!isNullOrEmpty(value)) {
                mergeValue = value;
            }
            return mergeValue;
        }
    }, {
        header: getPersonModuleTranslation('MOBILE_NUMBER'),
        dataIndex: 'mobileNumber',
        sortable: true,
        flex: .2,
        renderer: function(value, metaData, record) {
            var mergeValue = '';
            if (!isNullOrEmpty(record.data.countryCode)) {
                if (!isNullOrEmpty(value)) {
                    mergeValue = record.data.countryCode + " " + value;
                } else {
                    mergeValue = record.data.countryCode;
                }
            } else if (!isNullOrEmpty(value)) {
                mergeValue = value;
            }
            return mergeValue;
        }
    }, {
        header: getPersonModuleTranslation('FPD_WORK_EMAIL'),
        dataIndex: 'emailWork',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('FPD_HOME_EAMIL'),
        dataIndex: 'emailHome',
        sortable: true,
        flex: .2
    }, {
        header: getPersonModuleTranslation('FPD_CONSENT_TO_CREDIT_CHECK'),
        dataIndex: 'doesFeePayerConsentToCreditCheck',
        sortable: true,
        flex: .2,
        renderer: function(val) {
            var value = '';
            if (val) {
                value = getPersonModuleTranslation('YES');
            } else {
                value = getPersonModuleTranslation('NO');
            }
            return value;
        }
    }, {
        header: getPersonModuleTranslation('DOCUMENTS'),
        dataIndex: 'documentCount',
        flex: .2,
        sortable: true,
        renderer: function(value, meta, record) {
            if (!isNullOrEmpty(value)) {
                if (value > 0) {
                    return "<a href='#'>" + value + "</a>";
                }
            }
            return '0';
        }
    }, {
        header: getAdmissionTranslation('ADDRESS'),
        dataIndex: 'fulladdress',
        flex: .2,
        sortable: true
    }],
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store,
            dockedItems: [{
                xtype: 'toolbar',
                dock: 'bottom',
                items: [{
                    xtype: 'custompagingtoolbar',
                    plugins: ['pagesize'],
                    store: store,
                    emptyMsg: getCommonTranslation('EMPTY_MESSAGE'),
                    displayInfo: true
                }]
            }]
        });
        this$.callParent(arguments);
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.personalinfo.FeePayerDetailStore');
    }
});