/**
 *  @author Amit G
 */
Ext.define('Academia.view.personinfo.common.personalinfo.FeePayerPaymentTermSelectionGrid', {
	extend : 'Ext.grid.Panel',
	alias : 'widget.feepayerpaymenttermselectiongrid',
	border: true,
	title:getCommonTranslation('CLICK_ON_BELOW_PAYMENT_PLAN_TO_EDIT')+"      "+'<p>'+getCommonTranslation('NOT_REQUIRED_VALUE_IFNOSERVICESAREREQUIRED_MSG')+'</p>',
	store : 'personinfo.common.personalinfo.FeePayerPaymentTermSelectionGridStore',
	cls:'feePayerGridTtitleCls',
	viewConfig : {
		stripeRows : CONSTANTS.STRIPEROWS
	},
	columns: [{
		header : getAdmissionTranslation('FEE_TYPE'),
		dataIndex : 'feePlanName',
		flex : 1	  
	},{
		header : getPersonModuleTranslation('PAYMENT_TERM_IN_SELECTION'),
		dataIndex : 'paymentTerm',
		flex : 1,
		editor: {
            xtype: 'customcombobox',
            name: 'paymentTermCombo',
            itemId: 'paymentTermCombo',
            allowBlank:false,
            valueField: 'feePlanRuleName',
            displayField: 'feePlanRuleName',
            queryMode:'local',
    		listeners: {
                focus: function(combo) {
                	var grid = combo.up('grid');
                	var selectedRecord = grid.getSelectionModel().getSelection()[0];
                    var store = Ext.create('Academia.store.personinfo.common.personalinfo.FeePayerPaymentTermSelectionComboStore');
                    combo.bindStore(store);
                    var comboStore =  selectedRecord.data.feePlanRules;
					 if(store.getRange()){
						 store.removeAll();	 
					 }
					 store.add(comboStore);
                },
                select: function(obj, record){
                	var grid = obj.up('grid')
                	var selectedRecord = grid.getSelectionModel().getSelection()[0];
                   	var recordToBeUpdated = grid.getStore().findRecord('feePlanId',selectedRecord.data.feePlanId);
                   	selectedRecord.set('paymentTerm',record[0].data.feePlanRuleName);
                   	if(!isNullOrEmpty(record[0].data.installmentPerMonth)){
                   		recordToBeUpdated.set('installmentPerMonth',selectedRecord.data.currencyCode+' '+record[0].data.installmentPerMonth);
                   		recordToBeUpdated.set('installmentSchedule','');
                   	}else{
                   		recordToBeUpdated.set('installmentPerMonth','-');
                   		recordToBeUpdated.set('installmentSchedule','-');
                   	}
                   	if(!isNullOrEmpty(record[0].data.totalAmount)){
                   		recordToBeUpdated.set('totalAmount',selectedRecord.data.currencyCode+' '+record[0].data.totalAmount);
                   	}else{
                   		recordToBeUpdated.set('totalAmount','-');
                   	}
                   	if(!isNullOrEmpty(record[0].data.feePlanRuleId)){
                   		recordToBeUpdated.set('feePlanRuleId',record[0].data.feePlanRuleId);
                   	}
                   	if(!isNullOrEmpty(record[0].data.feeStageHeadConfigId)){
                   		recordToBeUpdated.set('feeStageHeadConfigId',record[0].data.feeStageHeadConfigId);
                   	}
                   	if(!isNullOrEmpty(record[0].data.paymentPeriod)){
                   		recordToBeUpdated.set('paymentPeriod',record[0].data.paymentPeriod);
                   	}
                   	
                }
            },
            listConfig: {
            	listeners: {
            		beforeshow: function(picker) {
            			picker.minWidth = picker.up('combobox').getSize().width;
            		}
            	},
            	loadingText: getCommonTranslation('SEARCHING'),
            	emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            	getInnerTpl: function() {
            		return '<div class="search-item">' +
            		'{value}' +
            		'</div>';
            	}
            }
        },    
        renderer:function(value,meta, records, temp)
        {
        	var randomId = randomString(10);
        	var randomId2 = randomString(4);
        	var randomId3 = randomString(4);
        	var randomId4 = randomString(4);
        	
        	var returnValue = '';
        	if (!isNullOrEmpty(value))
			{
        		returnValue = value;
			}
        	else if(!isNullOrEmpty(records.data.feePlanRules))
        	{
        		for(i=0;i<records.data.feePlanRules.length;i++)
        		{
        			if(records.data.feePlanRules[i].isView || records.data.feePlanRules[i].feePlanRuleName.startsWith('Not Required'))
        			{
        				records.set('paymentTerm',records.data.feePlanRules[i].feePlanRuleName);
        				records.set('feePlanRuleId',records.data.feePlanRules[i].feePlanRuleId);
        				records.set('feeStageHeadConfigId',records.data.feePlanRules[i].feeStageHeadConfigId);
        				records.set('paymentPeriod',records.data.feePlanRules[i].paymentPeriod);
        				returnValue = records.data.feePlanRules[i].feePlanRuleName;
        			}
        		}
        	}     
        	return '<table class="x-field x-table-plain x-form-item x-form-type-text x-field-default x-container-form-item x-form-dirty" cellpadding="0" id="'+randomId+'" style="table-layout: fixed; width: 105% !important;"><tbody><tr role="presentation" id="'+randomId+'-inputRow" class="x-form-item-input-row"><td role="presentation" id="'+randomId+'-labelCell" style="display:none;" valign="top" halign="left" width="105" class="x-field-label-cell"><label id="'+randomId+'-labelEl" for="'+randomId+'-inputEl" class="x-form-item-label x-unselectable x-form-item-label-left" style="width:100px;margin-right:5px;" unselectable="on"></label></td><td role="presentation" class="x-form-item-body" id="'+randomId+'-bodyEl" colspan="3" style="width: 100%;"><table id="'+randomId+'-triggerWrap" class="x-form-trigger-wrap" cellpadding="0" cellspacing="0" style="table-layout: fixed; width: 95%;"><tbody><tr><td id="'+randomId+'-inputCell" class="x-form-trigger-input-cell" style="width: 100%;"><div class="x-hide-display x-form-data-hidden" role="presentation" id="ext-gen'+randomId2+'"></div><input id="'+randomId+'-inputEl" type="text" value="'+returnValue+'" class="x-form-field x-form-required-field x-form-text" autocomplete="off" name="paymentTermCombo" maxlength="255" style="width: 100%;"></td><td valign="top" class=" x-trigger-cell x-unselectable" style="width:22px;" id="ext-gen'+randomId3+'"><div class="x-trigger-index-0 x-form-trigger x-form-arrow-trigger x-form-trigger-first" role="button" id="ext-gen'+randomId4+'"></div></td></tr></tbody></table></td></tr></tbody></table>';
        	
        }
	},{ 
		header :  getCommonTranslation('TOTAL_AMOUNT'),
		dataIndex : 'totalAmount',
		flex : 1,
		editor : {
			xtype:'displayfield',
			name: 'totalAmount',
			itemId:'totalAmount',
			allowBlank:false,
			mouseWheelEnabled:false,
			allowDecimals:true,
			hideTrigger:true,
			readOnly:true,
		},    
		renderer:function(value,meta, records, temp)
		{
			if (!isNullOrEmpty(value))
			{
				return value;
			}else if(!isNullOrEmpty(records.data.feePlanRules))
        	{
        		for(i=0;i<records.data.feePlanRules.length;i++)
        		{
        			if(records.data.feePlanRules[i].isView)
        			{
        				records.set('totalAmount',records.data.feePlanRules[i].totalAmount);
        				return records.data.feePlanRules[i].totalAmount;
        			}else if(records.data.feePlanRules[i].feePlanRuleName.startsWith('Not Required'))
        			{
        				records.set('totalAmount','-');
        				return '-';
        			}
        		}
        	} else {
        		meta.tdCls = 'gridInputCustomStyle';
        	}                        
        }
	}/*,{ 
		header : getCommonTranslation('FEE_INSTALMENT_SCHEDULE'),
		dataIndex : 'installmentSchedule',
		flex : 1,
        renderer: function(value, rec) {
        	if(!isNullOrEmpty(value)) {
				return value;
			} else {
                return '<a href="#">View</a>';
			} 
        }
	}*/],
	plugins: {
		ptype : 'cellediting',
		clicksToEdit: 1
	}
});