/**
 * @Author Harshal Mahale
 */
Ext.define('Academia.view.personinfo.common.personalinfo.InsuranceForm', {
//	extend: 'Ext.form.Panel',
	extend:'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.insuranceform',
	border : false,
	frame : false,
	plugins: "formlabelrequired",
	width  : '100%',
	items: [{
        xtype: 'hidden',
        itemId: 'insurance_detail_hidden_field',
        name: 'id'
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 260
    	},
    	layout: {
    		type: 'hbox'
    	},
    	items: [{
			xtype: 'checkboxfield',
			itemId : 'healthInsuranceConfirmed',
			labelAlign: 'right',
			region: 'south',
			boxLabel: getCommonTranslation('HEALTH_INSURANCE_CONFIRMED'),
			name: 'healthInsuranceConfirmed',
			hidden : false,
			checked:false,
			inputValue: true,
			uncheckedValue: false,
			style:{marginTop:'20px'}
		}]
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 260
    	},
    	layout: {
    		type: 'hbox'
    	},
    	items: [{
    		xtype: 'nestedJsonCombo',
    		fieldLabel: getCommonTranslation('SCHOOL_INSURANCE_TYPE'),
    		store: 'personinfo.common.personalinfo.SchoolInsuranceTypeStore',
    		valueField: 'id',
    		displayField: 'value',
    		name: 'schoolInsuranceType',
    		itemId: 'schoolInsuranceTypeItemId',
    		allowBlank:false,
    		editable: false,
    		fourceSelection: true,
    	}]
    },{
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('VALID_FROM'),
            itemId: 'validFrom',
            name: 'validFrom',
            hidden: true,
            allowBlank:true,
            listeners: {
                render: function(field) {
                    dateFormatRender(field);
                },
                change: function(field, newValue) {
                    const validToField = field.up('form').down('#validTo');
                    if (validToField) {
                        validToField.setMinValue(newValue); // Set the minimum value for "Valid To".
                        validToField.validate(); // Revalidate "Valid To" when "Valid From" changes.
                    }
                }
            }
        },{
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('VALID_TO'),
            itemId: 'validTo',
            name: 'validTo',
            hidden: true,
            allowBlank:true,
            listeners: {
                render: function(field) {
                    dateFormatRender(field);
                }
            }
        }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('NAME_OF_INSURANCE_COMPANY'),
            itemId : "nameOfInsuranceCompany",
            name: 'nameOfInsuranceCompany',
            allowBlank: true,
            maxLength:255,
            hidden: true
		},{
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('POLICY_NUMBER'),
            itemId : "policyNumber",
            name: 'policyNumber',
            allowBlank: true,
            maxLength:255,
            hidden: true
		}]
    },{
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		labelAlign: 'top',
    		width: 226
    	},
    	items: [{
    		xtype      : 'radiogroup',
    		fieldLabel : getCommonTranslation('SCHOOL_INSURANCE_CARD_RECEIVED'),
    		itemId: 'schoolInsuranceCardReceived',
    		name: 'schoolInsuranceCardReceived',
    		height : 55,
    		defaults: {
    			flex: 1
    		},
    		layout: 'hbox',
    		margin: '0 20 10 0',
    		hidden: true,
    		allowBlank:true,
    		items:[{ 
    			boxLabel: getCommonTranslation('YES'), 
    			name: 'schoolInsuranceCardReceived', 
    			inputValue: true,
    			checked:true

    		},{ 
    			boxLabel: getCommonTranslation('NO'), 
    			name: 'schoolInsuranceCardReceived', 
    			inputValue: false
    		}]
    	},{
			xtype: 'datefield',
			fieldLabel: getCommonTranslation('RECEIVED_DATE'),
			itemId : 'receivedDate',
            name: 'receivedDate',
            width: 260,
            margin: '0 0 0 22',
            hidden: true,
            allowBlank:true,
            listeners: {
            	render: function(field) {
            		return dateFormatRender(field);
            	}
            },
            vtype : 'daterange'
		}]
    },
    {
    	xtype: 'fieldcontainer',
    	layout: 'hbox',
    	defaults: {
    		labelAlign: 'top',
    		width: 530
    	},
    	items: [{
    		xtype: 'textarea',
    		fieldLabel: getCommonTranslation('REAMRK'),
    		name: 'remarks',
    		itemId : 'remarks',
    		allowBlank:true
    	}]
    },
    {
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width : 460,
			labelAlign : 'top'
		},
		items : [{
			xtype:'studentinsurancedocumentgrid',
			itemId:'studentinsurancedocumentgrid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width : 460,
			labelAlign : 'top'
		},
		items : [{
			xtype:'studentinsuranceurlgrid',
			itemId:'studentinsuranceurlgrid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width : 460,
			labelAlign : 'top'
		},
		items : [{
			xtype:'applicantinsurancedocumentgrid',
			itemId:'applicantinsurancedocumentgrid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width : 460,
			labelAlign : 'top'
		},
		items : [{
			xtype:'applicantinsuranceurlgrid',
			itemId:'applicantinsuranceurlgrid',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},
    {
    	xtype: 'fieldcontainer',
    	width:'auto',
		layout : 'hbox',
    	items: [{
    		xtype: 'button',
    		text: getCommonTranslation('SUBMIT'),
    		itemId: 'submitButtonId',
    		buttonAlign: 'right',
    		ui: 'CustomBtnSubmit',
    		scale: CONSTANTS.BUTTONSIZE,
    		formBind: true
    	}, {
    		xtype: 'button',
    		text: getCommonTranslation('CANCEL'),
    		ui: 'CustomBtnCancel',
    		itemId: 'cancelButtonId',
    		scale: CONSTANTS.BUTTONSIZE
    	},{
			 xtype: 'button',
			 name: 'insuranceUploadFile',
			 text:getCommonTranslation('UPLOAD_DOCUMENT'),
			 itemId: 'insuranceUploadFileItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		},{
			 xtype: 'button',
			 name: 'insuranceUploadURL',
			 text:getCommonTranslation('UPLOAD_URL'),
			 itemId: 'insuranceUploadURLItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]
});