/**
 * @author Dharmendra.P
 * 
 */
Ext.define('Academia.view.personinfo.common.personalinfo.OtherInformationDetailsForm', {
	extend :'Academia.view.common.IdGeneratorCustomForm',
    alias: 'widget.otherinformationdetailsform',
    border: false,
    frame: true,
    plugins: "formlabelrequired",
    title:getPersonModuleTranslation('OTHER_INFORMATION'),
	formCode:'studentOtherForm',
	initComponent: function() {
		var itemsArray = new Array();
		var customFieldPosition=itemsArray.length-1;
		
		if (this.personType === 'STUDENT' || this.personType === 'APPLICANT') {
			itemsArray.push({
				xtype: 'numberfield',
				itemId: 'financialAidGranted',
				name: 'financialAidGranted',
				fieldLabel: getCommonTranslation('FINANCIAL_AID_GRANTED'),
				labelAlign: 'top',
				width: 226,
				allowBlank: true,
				decimalPrecision: 2,
				hideTrigger: true,          
                keyNavEnabled: false,       
                mouseWheelEnabled: false,  
                allowExponential: false, 
                minValue: 0,
                allowDecimals: true,
				validator: function(value) {
				        if (value === '' || value === null) {
				            return true; // allow blank if required
				        }
				        // Check if the value has more than 2 decimal digits
				        var parts = value.toString().split('.');
				        if (parts.length === 2 && parts[1].length > 2) {
				            return 'Only up to two decimal places are allowed.';
				        }
				        return true;
				    }
			});
		}
    
		if(this.personType === 'STUDENT'){
			Ext.apply(this,{
				customFieldEntity:CONSTANTS.STUDENT_OTHER_INFORMATION,
				columns:3,
//				addPosition: customFieldPosition
			});
		}else if(this.personType === 'FACULTY'){
			Ext.apply(this,{
				customFieldEntity:CONSTANTS.EMPLOYEE_OTHER_INFORMATION,
				columns:3,
//				addPosition: customFieldPosition
			});
		}else if(this.personType === 'APPLICANT'){
			Ext.apply(this,{
				customFieldEntity:CONSTANTS.APPLICANT_OTHER_INFORMATION,
				columns:3,
//				addPosition: customFieldPosition
			});
		}else
		{
			if(portalId == 6)
			{
				Ext.apply(this,{
					customFieldEntity:CONSTANTS.APPLICANT_OTHER_INFORMATION,
					columns:3,
				});
			}

		}
		this.getSaveFormField(itemsArray);
		this.items = itemsArray;
		this.callParent(arguments);
		
	},

	getSaveFormField: function(itemsArray){
		itemsArray.push({
			xtype: 'fieldcontainer',
			width: '100%',
			margin:'5 0 0 0',
			items: [{
				xtype: 'hidden',
				itemId: 'oid_hidden_field',
				name: 'id'
			},{
				xtype: 'button',
				text: getCommonTranslation('SUBMIT'),
				itemId: 'submitButtonId',
				buttonAlign: 'right',
				ui: 'CustomBtnSubmit',
				scale: CONSTANTS.BUTTONSIZE,
				formBind: true,
				style :{
					/*marginTop:'5px',*/
					marginLeft:'0px'
				}
			}]
		});
		return itemsArray;
	}
});