/**
 * @author sachin.bangar
 * Parent Guardian Form
 */
Ext.define('Academia.view.personinfo.common.personalinfo.ParentGuardianForm', {
    //extend: 'Ext.form.Panel',
	//extend:'Academia.view.common.DynamicFieldForm',
	extend:'Academia.view.common.IdGeneratorCustomForm',
    customFieldEntity:CONSTANTS.PARENTANDGUARDIAN_CF_DATA,
    customFieldEntityType:CONSTANTS.PARENTANDGUARDIAN_CF_DISPLAY_NAME,
	alias: 'widget.parentguardianform',
    border: false,
    frame: false,
    plugins: "formlabelrequired",
    relatedPerson: null,
    relatedPersonUserId:null,
    getRelatedPerson: function() {
        return this.relatedPerson;
    },
    setRelatedPerson: function(relatedPerson) {
    	this.relatedPerson = relatedPerson;
    },
    getRelatedPersonUserId: function() {
        return this.relatedPersonUserId;
    },
    setRelatedPersonUserId: function(relatedPersonUserId) {
    	this.relatedPersonUserId = relatedPersonUserId;
    },
    style:{margin:'24px 24px 40px 24px'},
    items: [{
        xtype: 'hidden',
        itemId: 'pg_hidden_field',
        name: 'id'
    }, {
        xtype: 'hidden',
        itemId: 'pg_version_field',
        name: 'version'
    },{
    	xtype: 'hidden',
        itemId: 'old_photo_url',
        name: 'photoUrl'
    }, {
        xtype: 'fieldcontainer',
        itemId : 'relationShipEmployeeField',
        defaults: {
            labelAlign: 'top',
            //width: 226
        },
        items: [
        	{
                xtype: 'fieldcontainer',
                //itemId : 'relationShipEmployeeField',
                layout: 'hbox',
                defaults: {
                    labelAlign: 'top',
                    width: 260
                },
                items: [{
                    xtype: 'customcombobox',
                    fieldLabel: getPersonModuleTranslation('RELATIONSHIP'),
                    name: 'relationship',
                    valueField: 'name',
                    displayField: 'value',
                    itemId: 'relationShipField',
                    store: 'common.RelationshipStore',
                    editable: false,
                    allowBlank: false
                },{
                	xtype: 'form',
                	itemId: 'parentImageInnerForm',
                	border: false,
                    frame: false,
                    cls: 'panelNoSpace',
                    plugins: "formlabelrequired",
                    defaults: {
                        labelAlign: 'top',
                        width: 260
                    },
                	items:[
                		{
        			        xtype: 'filefield',
        			        fieldLabel: getCommonTranslation('PHOTO_IMAGE_SIZE'),
        			        buttonText: getPersonModuleTranslation('UPLOAD'),
        			        itemId: 'photoFileImageParent',
        			        ui: 'CustomBtnSubmit',
        			        name: 'photoFileImageParent'
                		}
                	]
			    },{
                    xtype: 'textfield',
                    fieldLabel: getPersonModuleTranslation('EMPLOYEE_ID'),
                    //vtype: 'NospaceAsInputFrench',
                    name: 'externalEmployeeId',
                    allowBlank: true,
                    itemId :'relationshipUserExternal',
                    style:{marginLeft:'10px'}
                }]
         },{
        	 xtype: 'fieldcontainer',
        	 //itemId : 'relationShipEmployeeField',
        	 layout: 'hbox',
        	 defaults: {
        		 labelAlign: 'top',
        		 width: 226
        	 },
        	 items: [{
        		 xtype: 'checkboxfield',
        		 width: 'auto',
        		 itemId: 'isEmployeeOrganisation',
        		 labelAlign: 'right',
        		 boxLabel: getPersonModuleTranslation('EMPLOYEE_OF_ORGANIZATION'),
        		 name: 'isEmployeeOfOrganization',
        		 inputValue: true,
        		 uncheckedValue: false,
        		 width: 226,
        		 listeners: {
        			 afterrender: function(cmp) {
        				 Ext.defer(function() {
        					 var nWidth = cmp.up('form').getWidth();
        					 cmp.up('fieldcontainer').setWidth(nWidth);
        					 cmp.setWidth(nWidth);
        				 }, 500);
        			 }
        		 }
        	 },{
        		 xtype:'button',
        		 text: getCommonTranslation('SNAPSHOT'),
        		 itemId: 'photoFileImageParent',
        		 name: 'photoFileImageSnapshot',
        		 ui: 'CustomBtnSubmit',
        		 listeners:{
        			 click : function(){
        				 var formWindow = Ext.widget('imagecapturewindow');
        				 formWindow.show();
        			 }
        		 }
        	 }]
         }]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        itemId : 'employeeIdSearchField',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        hidden : true,
        disabled : true,
        items: [{
            xtype: 'textfield',
            itemId: 'employeeIdField',
            emptyText: getCommonTranslation('ENTER_USER_CODE'),
            fieldLabel: getPersonModuleTranslation('USER_ID'),
            name: 'userCode'
        },{
            xtype: 'button',
            text: getCommonTranslation('SEARCH'),
            itemId: 'searchButtonId',
            ui: 'CustomBtnSubmit',
            style: {
                marginTop: '30px'
            },
            scale: CONSTANTS.BUTTONSIZE
        }]
    }, {
    	xtype : 'form',
    	itemId : 'parentGuardianInfoItemField',
    	margin : '0px',
    	items : [{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 260
            },
            items: [{
                xtype: 'nestedJsonCombo',
                fieldLabel: getCommonTranslation('SALUTATION'),
                itemId :'salutationId',
                name: 'salutation',
                store: 'common.SalutationStore',
                valueField: 'id',
                displayField: 'salutationName',
                allowBlank: false,
                editable: false
            }, {
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('FIRST_NAME'),
                name: 'firstName',
                allowBlank: false,
                itemId :'firstName',
                maxLength : 100
            },{
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('MIDDLE_NAME'),
                name: 'middleName',
                itemId :'middleName',
                maxLength : 53
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 260
            },
            items: [{
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('LAST_NAME'),
                name: 'lastName',
                allowBlank: false,
                itemId:'lastName',
                maxLength : 100
            }/*,{
                xtype: 'customcombobox',
                itemId: 'genderCombo',
                fieldLabel: getCommonTranslation('GENDER'),
                name: 'gender',
                valueField: 'id',
                allowBlank: false,
                displayField: 'value',
                store: 'Academia.store.common.GenderTypeStore',
                editable: false,
//                readOnly : true,
                queryMode: 'local',
                listeners: {
                	render : function(combo){
                		var store = combo.getStore();
                		store.load();
                	}
                }
            }, {
                xtype: 'datefield',
                fieldLabel: getPersonModuleTranslation('DATE_OF_BIRTH'),
                name: 'birthDate',
                itemId: 'birthDate',
              //--submitFormat : CONSTANTS.DATE_FORMAT,
                listeners: {
                	render: function(field) {
                		return dateFormatRender(field);
                	}
                },
                allowBlank: true,
                maxValue: new Date()
            }*/]
        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 260
            },
            items: [{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('FIRST_NAME_OTHER_LANGUAGE'),
				name: 'firstNameOtherLanguage',
				itemId:'firstNameOtherLanguageId',
				maxLength : 100,
				enforceMaxLength :true,
			}, {
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('MIDDLE_NAME_OTHER_LANGUAGE'),
				name: 'middleNameOtherLanguage',
				itemId:'middleNameOtherLanguageId',
				maxLength : 53,
				enforceMaxLength :true,
			}]
        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 260
            },
            items: [{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('LAST_NAME_OTHER_LANGUAGE'),
				name: 'lastNameOtherLanguage',
				itemId: 'lastNameOtherLanguageId',
				maxLength : 100,
				enforceMaxLength :true,
			}]
        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 260
            },
            items: [{
                xtype: 'customcombobox',
                itemId: 'genderCombo',
                fieldLabel: getCommonTranslation('GENDER'),
                name: 'gender',
                valueField: 'id',
                allowBlank: true,
                displayField: 'value',
                store: 'Academia.store.common.GenderTypeStore',
                editable: false,
//                readOnly : true,
                queryMode: 'local',
                listeners: {
                	render : function(combo){
                		var store = combo.getStore();
                		store.load();
                	}
                }
            }, {
                xtype: 'datefield',
                fieldLabel: getPersonModuleTranslation('DATE_OF_BIRTH'),
                name: 'birthDate',
                itemId: 'birthDate',
              //--submitFormat : CONSTANTS.DATE_FORMAT,
                listeners: {
                	render: function(field) {
                		return dateFormatRender(field);
                	}
                },
                allowBlank: true,
                maxValue: new Date()
            }]
        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 260
            },
            items: [{
            	xtype : 'radiogroup',
            	itemId:'isAlumnusRadio',
            	name:'isAlumnusRadio',
            	labelAlign : 'top',
            	height:60,
            	fieldLabel:getPersonModuleTranslation('IS_ALUMNUS'),
            	allowBlank: true,
            	items : [{
            		boxLabel : getCommonTranslation('YES'),
            		name:'isAlumnus',
            		inputValue : 'true'        		
            	},{
            		boxLabel : getCommonTranslation('NO'),
            		name:'isAlumnus',	
            		inputValue : 'false',
            		checked : true
            	}]           
            }, {
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('SCHOOL_ATTENDED'),
                name: 'schoolAttended',
                itemId: 'schoolAttended',
                minValue: 0,
                maxLength : 255,
                allowBlank: true,
//                hidden:true
                hidden:false
            }, {
                xtype: 'customcombobox',
                itemId: 'maritalStatusCombo',
                fieldLabel: getPersonModuleTranslation('MARITAL_STATUS'),
//                readOnly : true,
                queryMode: 'local',
                store: 'Academia.store.common.MaritalStatusCSMStore',
                valueField: 'id',
                displayField: 'value',
                name: 'maritalStatus',
                itemId: 'maritalStatus',
                editable: false,
                listeners: {
                	render : function(combo){
                		var store = combo.getStore();
                		store.load();
                	}
                }
            }]
        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 260
            },
            items: [{
                xtype: 'customcombobox',
                fieldLabel: getCommonTranslation('BLOOD_GROUP'),
                itemId: 'bloodGroup',
                name: 'bloodGroup',
                store: 'enquiry.studentDetail.BloodGroupStore',
                valueField: 'id',
                displayField: 'value',
                editable: false,
                allowBlank: true
            }, {
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('OCCUPATION'),
                //vtype: 'NospaceAsInput',
                //vtype : 'NoSpaceAndSpecialCharactersAsInput',
                name: 'occupation',
                itemId: 'occupation',
                maxLength : 100,
                allowBlank: true
            }, {
                xtype: 'numberfield',
                fieldLabel: getPersonModuleTranslation('FAMILY_INCOME'),
                name: 'personalIncome',
                itemId: 'personalIncome',
                minValue: 0,
                maxLength : 10,
                allowBlank: true
            }]
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 260
            },
            items: []
        }, {
            xtype: 'fieldcontainer',
            layout: 'hbox',
            itemId : 'parentGuardianEmailField',
            defaults: {
                labelAlign: 'top',
                width: 260
            },
            items: [{
                xtype: 'textfield',
                itemId : 'primaryeEmailId',
                fieldLabel: getPersonModuleTranslation('EMAIL_ID'),
                name: 'emailId',
                vtype: 'myemail',
                allowBlank: false,
                maxLength : 100,
                listeners: {
                    change: function(field, newValue) {
                        var checkbox = field.up('form').down('#enableEmailCommunicationId');
                        if(!isNullOrEmpty(checkbox)){
                        if (newValue && newValue.trim() !== '') {
                            checkbox.setDisabled(false);
                        } else {
                            checkbox.setDisabled(true);
                            checkbox.setValue(false);
                        }
                       }
                    }
                }
            },{
                xtype: 'textfield',
                fieldLabel: getPersonModuleTranslation('VEHICLE_LICENSE_PLATE_NO'),
                name: 'vehicleLicenseNo',
                itemId : 'vehicleLicenseNo',
                maxLength : 45,
                //vtype: 'NospaceAsInput',
                //vtype : 'NoSpaceAndSpecialCharactersAsInput',
                allowBlank: true,
                maxLength : 45
            }, {
                xtype: 'filefield',
                fieldLabel: getPersonModuleTranslation('PHOTO'),
                buttonText: getPersonModuleTranslation('UPLOAD'),
                itemId: 'photoFileImage',
                ui: 'CustomBtnSubmit',
                name: 'photoUrl'
        	}]
        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            itemId : 'parentGEnableEmailCommunication',
            defaults: {
                labelAlign: 'top',
                width: 260
            },
            items: [{
                xtype: 'checkboxfield',
                itemId : 'enableEmailCommunicationId',
                boxLabel: getPersonModuleTranslation('ENABLE_EMAIL_COMMUNICATION'),
                name: 'enableEmailCommunication',
                disabled:true,
                hidden:true,
                inputValue:true
            }]
        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            //itemId : 'parentGuardianEmailField',
            defaults: {
                labelAlign: 'top',
                width: 260
            },
            items: [/*{
				xtype: 'nestedJsonCombo',
				fieldLabel: getPersonModuleTranslation('DESIGNATION'),
				store: 'common.DesignationTypeStore',
				itemId:'designationCombo',
				valueField: 'id',
				displayField: 'value',        
				name : 'designation',
				//allowBlank: false,
				editable: false,
				queryMode: 'local',
				triggerAcation: 'all',
				fourceSelection: true				
			}*/{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('DESIGNATION'),
				itemId:'designationCombo',
				name : 'parentDesignation',
				maxLength : 45
				//allowBlank: false,
			},{
                xtype: 'textfield',
                fieldLabel: getCommonTranslation('BUSINESS_NAME'),
                name: 'businessName',
                itemId:'businessName',
                maxLength : 100,
                allowBlank: true
            },{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('EMPLOYMENT_STATUS'),
				name: 'employmentStatus',
				itemId: 'employmentStatus',
				valueField: 'id',
				displayField: 'value',
				store: 'personinfo.common.personalinfo.EmploymentStatusCSMStore',
				editable: false,
				allowBlank: true
		    }]
        },{
            xtype: 'fieldcontainer',
            layout: 'hbox',
            defaults: {
                labelAlign: 'top',
                width: 260
            },
            items: [{
                xtype: 'textfield',
                fieldLabel: getCommonTranslation('POSITION'),
                name: 'position',
                itemId:'position',
                maxLength : 100,
                allowBlank: true
            }]
        }, {

		xtype: 'fieldcontainer',
		itemId : 'contactFieldSet',
		defaults: {
			labelAlign: 'top'
		},
		style: {
			marginTop: '30px !important',
			marginLeft : '0px'
		},
		title: getAdmissionTranslation('CONTACT_INFORMATION'), // Contact Information
		items: [{
			html: '<i>'+getAdmissionTranslation('ENTER_ANY_ONE_CONTACT_Details')+'</i>'+'<span class="required" style="color:red"> *</span>',
			margin: 0,
			width:700
		},{
		    xtype: 'fieldcontainer',
		    itemId : 'mainParentGuardianMobileField',
		    layout:{
		        type:'hbox'
		    },
		    height:70,
		    width: '100%',
		    items:[{
		        xtype: 'fieldcontainer',
		        layout:{
		            type:'hbox'
		        },
		        width: '100%',
		        items:[{
		            xtype: 'fieldcontainer',
		            itemId : 'parentGuardianMobileField',
		            fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO'),
		            labelAlign: 'top',
		            width: '50%',
		            layout:{
		                type:'hbox'
		            },
		            height:70,
		            items: [{
		                xtype: 'customcombobox',
		                name: 'mobileCountryCode',
		                itemId: 'mobileCountryCode',
		                valueField: 'isdCode',
		                displayField: 'isdCode',
		                store: 'common.CountryStore',
		                triggerAction: 'all',
		                forceSelection: true,
		                minChars: 1,
		                width: 100
		            }, {
		                xtype: 'numberfield',
		                itemId: 'cellNo',
		                name: 'mobileNumber',
		                minLength: 0,
		                maxLength: 15,
		                enforceMaxLength : true,
		                hideTrigger: true,
		                keyNavEnabled: false,
		                mouseWheelEnabled: false,
		                width: 220
		            }]
		        }, {
		            xtype: 'fieldcontainer',
		            fieldLabel: getCommonTranslation('ADDRESS_PHONE_NUMBER_1'),
		            labelAlign: 'top',
		            width: '50%',
		            layout:{
		                type:'hbox'
		            },
		            defaults: {
		                labelAlign: "top",
		                width: 226
		            },
		            items : [{
		                xtype : 'customcombobox',
		                hiddenName : 'phoneNumber1',
		                valueField : 'isdCode',
		                displayField : 'isdCode',
		                store:'common.CountryStore',
		                triggerAction : 'all',
		                name : 'phoneCountryCode',
		                itemId : 'phoneCountryCode',
		                forceSelection: true,
		                minChars: 1,
		                width: 100
		            }, {
		                xtype : 'numberfield',
		                name : 'phoneAreaCode',
		                width: 110,
		                maxLength: 5,
		                enforceMaxLength : true,
		                // To Remove spinner buttons, and arrow key and mouse wheel listeners
		                hideTrigger: true,
		                keyNavEnabled: false,
		                mouseWheelEnabled: false,
		                allowExponential:false
		            }, {
		                xtype : 'numberfield',
		                itemId : 'phoneNoField',
		                name : 'phoneNo',
		                maxLength: 15,
		                enforceMaxLength : true,
		                // To Remove spinner buttons, and arrow key and mouse wheel listeners
		                hideTrigger: true,
		                width: 230,
		                keyNavEnabled: false,
		                mouseWheelEnabled: false,
		                allowExponential:false
		            }]
		        }/*,{
		        
	        	xtype: 'fieldcontainer',
	    		//fieldLabel: getCommonTranslation('ADDRESS_PHONE_NUMBER_1'),
//	    	    hidden : true,
//	    	    disabled:true, 
	        	defaults: {
	                 labelAlign: 'top',
	                 width: 400
	            },
	    		layout : {
	    			type : 'hbox'
	    		},
	    		items : [{
					xtype: 'checkboxfield',
					itemId : 'isMobUseForCommunicationField',
					labelAlign: 'right',
					region: 'south',
					height:45,
					style: {
						marginTop: '25px',
						marginLeft:'5px'
					},
					boxLabel: getPersonModuleTranslation('USE_MOBILE_FOR_COMMUNICATION'),
					name: 'isMobUseForCommunication',
					itemId:'isMobUseForCommunication',
					inputValue: true,
					uncheckedValue: false,
					listeners: {
						afterrender: function(cmp) {
							Ext.defer(function() {
								var nWidth = cmp.up('form').getWidth();
								cmp.up('fieldcontainer').setWidth(nWidth);
								cmp.setWidth(nWidth);
							}, 500);
						}
					}
				}]
	        }*/]
		    }]
		}, {
			xtype: 'fieldcontainer',
	        layout:{
	            type:'hbox'
	        },
	        width: 700,
	        items :[{
                xtype: 'checkboxfield',
                itemId : 'isMobUseForCommunicationField',
//                flex:1,
                width:330,
//                height:45,
                boxLabel: getPersonModuleTranslation('USE_MOBILE_FOR_COMMUNICATION'),
                name: 'isMobUseForCommunication',
                inputValue: true,
                uncheckedValue: false,
//                listeners: {
//                    afterrender: function(cmp) {
//                        Ext.defer(function() {
//                            var nWidth = cmp.up('form').getWidth();
//                            cmp.up('fieldcontainer').setWidth(nWidth);
//                            cmp.setWidth(nWidth);
//                        }, 500);
//                    }
//                }
            }, {
                xtype: 'checkboxfield',
                itemId : 'isPhoneUseForCommunicationField',
//                height:45,
//                flex:1,
                width:350,
                boxLabel: getPersonModuleTranslation('USE_PHONE_FOR_COMMUNICATION'),
                name: 'isPhoneUseForCommunication',
                inputValue: true,
                uncheckedValue: false,
//                listeners: {
//                    afterrender: function(cmp) {
//                        Ext.defer(function() {
//                            var nWidth = cmp.up('form').getWidth();
//                            cmp.up('fieldcontainer').setWidth(nWidth);
//                            cmp.setWidth(nWidth);
//                        }, 500);
//                    }
//                }
            
            }]
		}]
	    }, {
	        xtype: 'fieldcontainer',
	        layout:{
	            type:'hbox'
	        },
	        width: '100%',
	        items:[{
	            xtype: 'fieldcontainer',
	            layout:{
	                type:'hbox'
	            },
	            width: '100%',
	            items:[{
	                xtype: 'fieldcontainer',
	                itemId : 'alternateMobileField',
	                fieldLabel: getCommonTranslation('ADDRESS_ALTERNATE_MOBILE_NO'),
	                labelAlign: 'top',
	                width: '50%',
	                height:'50',
	                layout:{
	                    type:'hbox'
	                },
	                defaults: {
	                    labelAlign: 'top',
	                    width: 226
	                },
	                items: [{
	                    xtype: 'customcombobox',
	                    name: 'alternateMobileCountryCode',
	                    itemId: 'alternateMobileCountryCode',
	                    valueField: 'isdCode',
	                    displayField: 'isdCode',
	                    store: 'common.CountryStore',
	                    triggerAction: 'all',
	                    //editable: false,
	                    minChars: 1,
	                    forceSelection: true,
	                    width: 100
	                }, {
	                    xtype: 'numberfield',
	                    itemId: 'alternateMobileNo',
	                    name: 'alternateMobileNo',
	                    minLength: 0,
	                    maxLength: 15,
	                    enforceMaxLength : true,
	                    hideTrigger: true,
	                    keyNavEnabled: false,
	                    mouseWheelEnabled: false
	                }]
	            }, {
	                xtype: 'fieldcontainer',
	                labelAlign: 'top',
	                width: '50%',
	                layout:{
	                    type:'hbox'
	                },
	                defaults: {
	                    labelAlign: 'top',
	                    width: 226
	                },
	                items: [{
	                    xtype: 'textfield',
	                    fieldLabel: getPersonModuleTranslation('FPD_NATIONAL_ALTERNATE_ID'),
	                    name: 'nationalID',
	                    itemId :'nationalId',
	                    maxLength : 50,
	                    vtype: 'NoSpecialCharactersWithNumberWithoutSpaceAsInput',
	                    allowBlank: true
	                
	                }]
	            }]
	            
	        }]
	    }, {
	xtype: 'fieldcontainer', 
	layout : {
		type : 'hbox'
	},
	defaults: {
		labelAlign: "top",
        width: 450
	},
	items : [{
		xtype: 'checkboxfield',
		itemId : 'isAlternateMobUseForCommunicationField',
		labelAlign: "right",
		region: 'south',
		height:45,
		/*style: {
			marginTop: '25px',
			marginLeft:'5px'
		},*/
		boxLabel: getPersonModuleTranslation('USE_ALTERNATE_MOBILE_FOR_COMMUNICATION'),
		name: 'isAlternateMobUseForCommunication',
		inputValue: true,
		uncheckedValue: false,
		listeners: {
			afterrender: function(cmp) {
				Ext.defer(function() {
					var nWidth = cmp.up('form').getWidth();
					cmp.up('fieldcontainer').setWidth(nWidth);
					cmp.setWidth(nWidth);
				}, 500);
			}
		}
	}]
},{
	xtype : 'radiogroup',
	itemId:'haveAccessToLearnerId',
	labelAlign : 'top',
	fieldLabel:getPersonModuleTranslation('HAVE_ACCESS_TO_STUDENT'),
    /*defaults: {
        labelAlign: 'top',
        width: 226
    },*/
	items : [{
		boxLabel : getCommonTranslation('YES'),
		name:'haveAccessToLearner',
		inputValue : 'true',
		checked : true
	},{
		boxLabel : getCommonTranslation('NO'),
		name:'haveAccessToLearner',	
		inputValue : 'false'
	}]
}, {
	xtype: 'fieldcontainer',
    itemId : 'emergencyContactField',
	layout: 'hbox',
    labelAlign: 'top',
    defaults: {
        labelAlign: 'top',
        width: 260
    },
    items: [{
    	xtype: 'checkboxfield',
		itemId : 'isEmergencyContactField',
		labelAlign: 'right',
		region: 'south',
		boxLabel: getPersonModuleTranslation('IS_AN_EMERGENCY_CONTACT'),
		name: 'isEmergencyContact',
		checked:true,
		inputValue: true,
		uncheckedValue: false,
		listeners: {
			afterrender: function(cmp) {
				Ext.defer(function() {
					var nWidth = cmp.up('form').getWidth();
					cmp.up('fieldcontainer').setWidth(nWidth);
					cmp.setWidth(nWidth);
				}, 500);
			}
		}
    }]
}, {
    	xtype: 'fieldcontainer',
        itemId : 'deceasedField',
    	layout: 'hbox',
        labelAlign: 'top',
        defaults: {
            labelAlign: 'top',
            width: 226
        },
        items: [{
        	xtype: 'checkboxfield',
    		itemId : 'isDeceasedField',
    		labelAlign: 'right',
    		region: 'south',
    		boxLabel: getCommonTranslation('IS_DECEASED'),
    		name: 'isDeceased',
    		inputValue: true,
    		uncheckedValue: false,
    		listeners: {
    			afterrender: function(cmp) {
    				Ext.defer(function() {
    					var nWidth = cmp.up('form').getWidth();
    					cmp.up('fieldcontainer').setWidth(nWidth);
    					cmp.setWidth(nWidth);
    				}, 500);
    			}
    		}
        }]
 },{
	xtype:'fieldcontainer',
	layout:'hbox',
	defaults: {
		width: 460,
		labelAlign: 'top'
	},
	items:[{
		xtype: 'multiselectcombofield',
		fieldLabel: getPersonModuleTranslation('APPLY_UPDATE_TO_SIBLINGS'),
		name: 'applyUpdateToSiblings',
		valueField : 'id',
		displayField : 'value',
		store:'common.SiblingsByParentDetailsStore',
		itemId: 'applyUpdateToSiblings',
		//hidden:true,
		queryMode:'local'
	}]

}]
    }, {
        xtype: 'fieldcontainer',
        width: '100%',
        itemId : 'parentGuardianButtonField',
        
        items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        }, {
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        }]
    }]
});