/**
 * @Author Vidhi Shah
 */
Ext.define('Academia.view.personinfo.common.personalinfo.PermitUrlDocumentListGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias : 'widget.permiturldocumentlistgrid',
	store :'personinfo.common.personalinfo.PermitUrlDocumentGridStore',
	border: true,
	height:'60%',
	maxWidth:850,
	enableColumnHide :false,
	selType:'checkboxmodel',
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	selModel: {
		mode:'MULTI',
		showHeaderCheckbox: true,
		allowDeselect: false,
		checkOnly : true
	},
	title : getCommonTranslation('LIST_OF_URLS'),
	dockedItems : [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype: 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'personinfo.common.personalinfo.PermitUrlDocumentGridStore',
			emptyMsg :getCommonTranslation('EMPTY_MESSAGE'),
			displayInfo : true
		} ]
	}],
	initComponent: function() {
		var grid=this;
	this.callParent(arguments);
	},
	
	tbar: [{
		xtype : 'button',				
		itemId : 'btnDelete',
		cls: 'CustomToolbarBtnReject',
		tooltip :getCommonTranslation('DELETE'),
		glyph: ICONGLYPH.DELETEGLYPH
				
	}],
	columns :[{
		header : getCommonTranslation('S_NO'),
		xtype: 'rownumberer',
		align: 'left',
		flex: 0.5,
		sortable: false,
		renderer: function(value, metaData, record, rowIndex){
			return "<span style='padding-left: 6px;'>" + (rowIndex + 1) + "</span>";
		}
	},{
		header : getCommonTranslation('URLS'),
		dataIndex : 'name',
		flex:1,
		sortable: false,
		renderer:function(value, metaData, record){
			if(record){
				var newName=record.data.name;
                var newPath=record.data.path;    
                var val=!isNullOrEmpty(newName)?newName:newPath;
                return "<a href="+newPath+" target='_blank'>"+val;
			}
		}
	},{
		header : getCommonTranslation('UPLOADED_ON'),
		dataIndex : 'submissionDate',
		flex:1,
		sortable: false,
		renderer: function(date) {
            return dateRender(date);
        }
	}]
});