/**
 * Personal Information Form
 */
Ext.define('Academia.view.personinfo.common.personalinfo.PersonalInformationForm', {
	//extend: 'Ext.form.Panel',
	//extend: 'Academia.view.common.CustomFieldForm',
	extend :'Academia.view.common.IdGeneratorCustomForm',
	alias: 'widget.personalinformationform',
	padding: '15',
	margin: 0,
	autoScroll:true,
	width:1000,
	plugins: "formlabelrequired",
	defaults: {
		labelAlign: 'top'
	},
	height:'auto',
	standardSubmit: false,
	listeners: {
        validitychange: function(d, c) {
        	if (this.up().down("#innerTabNextButton")){
            if (c) {
                this.up().down("#innerTabNextButton").setDisabled(false);
                this.up().down("#innerTabNextButton").isVisible() && this.up().down("#errorMsgShow1").setVisible(false)
            } else {
                this.up().down("#innerTabNextButton").setDisabled(true);
                this.up().down("#innerTabNextButton").isVisible() && this.up().down("#errorMsgShow1").setVisible(true)
            }
         }
        }
    },
	initComponent: function() {
		var detailsArray = new Array();
		var itemsArray = new Array();
		this.getHiddenFormField(itemsArray);
		
		if(!Ext.isDefined(this.personType)) {
			try{
				if(portalId==3 || portalId==7) {
					this.personType = 'STUDENT';
				}
			}
			catch(e){}
		}
		
		if(this.personType === 'APPLICANT' || portalId==6){
			this.getApplicantAcademicFormField(detailsArray);
		}if(this.personType === 'STUDENT'){
			this.getStudentAcademicFormField(detailsArray);
		}else if(this.personType === 'FACULTY'){
			this.getFacultyAcademicFormField(detailsArray);
		}

		if(this.personType === 'APPLICANT' || portalId==6){
			this.getPersonalCommonFormWithSalutationField(itemsArray, this.personType, detailsArray);
		}if(this.personType === 'STUDENT'){
			this.getPersonalCommonFormWithSalutationField(itemsArray, this.personType, detailsArray);
		}else if(this.personType === 'FACULTY'){
			this.getPersonalCommonFormField(itemsArray, this.personType, detailsArray);
		}
		
		/*if(this.personType === 'APPLICANT' || this.personType === 'STUDENT'){
			this.getExtraDetailFormField(itemsArray);
		}*/
		
		if(this.personType === 'FACULTY'){
			this.getFacultypersonalFormField(itemsArray);
		} 
		this.getContactDetailsFormField(itemsArray);
		
		if(this.personType === 'APPLICANT' || portalId==6){
			this.getPersonalDetailFormExtSysRefLastNameField(itemsArray);
		}if(this.personType === 'STUDENT'){
			this.getPersonalDetailFormExtSysRefField(itemsArray);
		}
		if(this.personType === 'FACULTY'){
			this.getPersonalDetailFormExtSysRefField(itemsArray);
		}
		
		
		if(this.personType === 'FACULTY'){
			this.getOtherFacultyDetailsFormField(itemsArray);
		}else if(this.personType === 'APPLICANT' || portalId==6){
			this.getOtherApplicantDetailsFormField(itemsArray);
		}else{
			this.getOtherStudentDetailsFormField(itemsArray);
		}

		if(this.personType === 'FACULTY'){
			this.getBankDetailFormField(itemsArray);
		} else if(this.personType === 'APPLICANT' || this.personType === 'STUDENT' || portalId==6){
			this.getBankDetailStudentApplicationFormField(itemsArray);
			if(this.personType === 'APPLICANT' || portalId==6){
				this.getIsRegistrationContractConditionField(itemsArray);
			}
			this.getIsRegistrationContractField(itemsArray);
		}
		
		//this.getPhysicalCharacteristicsFormField(itemsArray);
		this.getSaveFormField(itemsArray);

		var customFieldPosition=itemsArray.length-1;
		if(this.personType === 'APPLICANT' || portalId==6){
			Ext.apply(this,{
				customFieldEntity:CONSTANTS.APPLICANT_PERSON_CF_DATA,
				columns:1,
				addPosition: customFieldPosition
			});
		}if(this.personType === 'STUDENT'){
			Ext.apply(this,{
				customFieldEntity:CONSTANTS.PERSON_CD,
				customFieldEntityType:CONSTANTS.STUDENT_PERSON_CF_ENTITY_TYPE,
				columns:1,
				addPosition: customFieldPosition
			});
		}else if(this.personType === 'FACULTY'){
			Ext.apply(this,{
				customFieldEntity:CONSTANTS.PERSON_CD,
				customFieldEntityType:CONSTANTS.EMPLOYEE_PERSON_CF_ENTITY_TYPE,
				columns:1,
				addPosition: customFieldPosition
			});
		}

		this.items = itemsArray;
		this.callParent(arguments);
	},

	getHiddenFormField: function(itemsArray) {

		itemsArray.push({
			xtype: 'hidden',
			itemId: 'user_Id',
			name: 'id'
		}, {
			xtype: 'hidden',
			itemId: 'user_version',
			name: 'version'
		}, {
			xtype: 'hidden',
			itemId: 'person_Id',
			name: 'personId'
		}, {
			xtype: 'hidden',
			itemId: 'person_version',
			name: 'personVersion'
		}, {
			xtype: 'hidden',
			itemId: 'isEmployeeOfOrganization_Id',
			name: 'isEmployeeOfOrganization'
		}, {
			xtype: 'hidden',
			name: 'bankDetailsId'
		}, {
			xtype: 'hidden',
			name: 'bankDetailsVersion'
		}, {
			xtype: 'hidden',
			name: 'phyId'
		}, {
			xtype: 'hidden',
			name: 'phyVersion'
		}, {
			xtype: 'hidden',
			itemId: 'checkboxDropdown',
			name: 'checkboxDropdown'
		}, {
			xtype: 'hidden',
			itemId: 'photo_url',
			name: 'photo_url'
		});

		return itemsArray;
	},

	getApplicantAcademicFormField: function(itemsArray) {
		itemsArray.push({
			xtype: 'fieldcontainer',
			itemId: 'academicDetails',
			//padding: 10,
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'hidden',
				itemId: 'refApplicationId',
				name: 'refApplicationId'
			},{
				xtype: 'textfield',
				itemId : 'personCodeField',
				fieldLabel: getPersonModuleTranslation('APPLICANT_ID'),
				name: 'applicantId',
				readOnly: true,
				allowBlank: false
			},{
				xtype: 'textfield',
				itemId : 'refStudentIdField',
				fieldLabel: getPersonModuleTranslation('REFERENCE_STUDENT_ID'),
				name: 'refStudentId',
				readOnly: true,
				allowBlank: true,
				hidden:true
			},/* V2D-479891{
				xtype: 'photouploadform',
				itemId: 'applicantPhotoUploadForm',
				name: 'applicantPhotoUploadForm'
			},*/{
				xtype: 'checkboxfield',
				itemId : 'isAgencyRequiredField',
				labelAlign: 'right',
				region: 'south',
				style: {
					marginTop: '25px',
					marginLeft:'5px'
				},
				boxLabel: getPersonModuleTranslation('IS_AGENCY_RECRUITED'),
				name: 'isAgencyRequired',
				inputValue: true,
				uncheckedValue: false
			}]
		});

		return itemsArray;
	},

	getStudentAcademicFormField: function(itemsArray) {
		itemsArray.push({
			xtype: 'fieldcontainer',
			//padding: 10,
			itemId:'studentAcademicContainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype:'image',
				itemId: 'profile_image_prev',
				border: 1,
				hidden : true,
				style: {
					borderColor: '#e0e0e0',
					borderStyle: 'solid',
					borderRadius:'50%',
					//marginTop: '25px !important',
					//marginLeft: '13px !important'
				},
				width: 64,
				height: 64,
				src: 'resources/images/default-profile.png'
			},{
				xtype: 'textfield',
				itemId : 'admissionCodeIteamId',
				fieldLabel: getPersonModuleTranslation('ADMISSION_NUMBER'),                
				name: 'admissionCodeField',
				width:226,
				readOnly: false,
				allowBlank: false,
				readOnly:true,
				hidden:true
			},{
				xtype: 'textfield',
				itemId : 'admissionIdIteamId',
				fieldLabel: getPersonModuleTranslation('ADMISSION_NUMBER'),                
				name: 'admissionCode',
				width:226,
				readOnly: false,
				allowBlank: false,
				readOnly:true
			},{
				xtype: 'textfield',
				itemId : 'personCodeField',
				fieldLabel: getPersonModuleTranslation('STUDENT_ID'),                
				name: 'code',
				width:226,
				readOnly: false,
				allowBlank: false,
				readOnly:true
			}, {
				xtype: 'photouploadform',
				itemId: 'studentPhotoUploadForm',	
				name: 'studentPhotoUploadForm',		
				width:280,
				listeners:{
					beforeRender: function(){
						this.down('#photoFileImage').setFieldLabel(getCommonTranslation('PHOTO_IMAGE_SIZE'));
					}
				}
			},{
				xtype:'button',
				text:'Snapshot',
				itemId: 'photoFileImage',
				name: 'photoFileImage',
			    ui: 'CustomBtnSubmit',
			    width:100,
			    style: {
					marginTop: '29px',
					marginLeft: '2px'
				},
			    listeners:{
			    	click : function(){
			    		var formWindow = Ext.widget('imagecapturewindow');
			    		formWindow.show();
			    	}/*,
			    	afterrender: function(btn){
			    		setTimeout(function(){
			    			btn.setVisible(false);
			    		},300);
			    	}*/
			    }
			},{
				xtype:'button',
				text:'Remove',
				itemId: 'profilePhotoRemove',
			    ui: 'CustomBtnSubmit',
			    width:60,
			    style: {
					marginTop: '29px',
					marginLeft: '20px'
				}			    
			}]
		});
		
		itemsArray.push({
			xtype: 'fieldcontainer',
			//padding: 10,
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'checkboxfield',
				itemId : 'isAgencyRequiredField',
				labelAlign: 'right',
				region: 'south',
				/*style: {
					marginTop: '25px'
					//marginLeft: '-0px'
				},*/
				//width:400,
				boxLabel: getPersonModuleTranslation('IS_AGENCY_RECRUITED'),
				name: 'isAgencyRequired',
				inputValue: true,
				uncheckedValue: false
			}]
		});

		return itemsArray;
	},

	getFacultyAcademicFormField: function(itemsArray) {

		itemsArray.push({
			xtype: 'fieldcontainer',
			//padding: 10,
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('EMPLOYEE_ID'),
				itemId : 'personCodeField',
				name: 'code',
				readOnly: false,
				allowBlank: false
			}, {
				xtype: 'photouploadform',
				itemId: 'facultyPhotoUploadForm'
			}]
		});

		return itemsArray;
	},

	getFacultypersonalFormField: function(objArray) {

		objArray.push({
			xtype: 'fieldset',
			itemId: 'facultyDeptDetails',
			style:{'padding':'0px !important','margin-top':'-14px !important','margin-left': '10px','margin-bottom':'35px'},
			items: [{ 
				xtype: 'fieldcontainer',
				//fieldLabel: getCommonTranslation('ADDRESS_PHONE_NUMBER_1'),		
				allowBlank:false,
				layout : {
					type : 'hbox'
				},
				defaults: {
					labelAlign: 'top',
					width: 226
				},         	  
				
				items: [{
					xtype: 'nestedJsonCombo',
					fieldLabel: getPersonModuleTranslation('DESIGNATION'),

					store: 'common.DesignationTypeStore',
					valueField: 'id',
					displayField: 'value',        
					name : 'designation',
					allowBlank: false,
					editable: false,
					//queryMode: 'local',
					triggerAcation: 'all',
					fourceSelection: true,
					itemId:'designationCombo'
				}, {
					xtype: 'nestedJsonCombo',
					fieldLabel: getPersonModuleTranslation('DEPARTMENT'),

					store: 'department.DepartmentComboStore',
					itemId : 'departmentCombo',
					valueField: 'id',
					displayField: 'name',     
					name : 'department',
					allowBlank: false,
					editable: false,
				//	queryMode: 'local',
					triggerAcation: 'all',
					fourceSelection: true
				}, /*{
					xtype: 'customcombobox',
					fieldLabel: getPersonModuleTranslation('FACULTY_TYPE'),

					store : 'personinfo.faculty.FacultyTypeStore',
					valueField: 'name',
					displayField: 'value',  
					name: 'facultyType',
					allowBlank: false,
					editable: false
				}*/ {
					xtype: 'datefield',
					fieldLabel: getPersonModuleTranslation('DATE_OF_JOIN'),
					name: 'joiningDate',
					itemId :'startDate',
					vtype: 'daterange',
					endDateField: 'endDate',
					//--submitFormat: CONSTANTS.DATE_FORMAT,
					listeners: {
						render: function(field) {
							return dateFormatRender(field);
						}
					},
					allowBlank: false
				}]},{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 226
					},
					items: [{
						xtype: 'numberfield',
						fieldLabel: getPersonModuleTranslation('YEAR_OF_EXPERIENCE_MONTHS'),

						allowBlank: true,
						minValue : 0,
						maxLength : 3,
						value : 0,
						decimalPrecision : 2,
						editable: false,
						readOnly: true,
						name: 'yearsOfExperience',
						itemId : 'yearsOfExperience'
					},{
						xtype: 'customcombobox',
						name:'leaveCategory',
						itemId:'leaveCategory',
						fieldLabel: getCommonTranslation('LEAVE_CATEGORY'),
						store:'securitysetup.LeaveCategorTypeStore',
						valueField: 'id',
						displayField: 'value',
						forceSelection: true,
						editable: false,
						//readOnly: true,
					}]
				},{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 226
					},
					items: [{
						xtype : 'textfield',
						fieldLabel : getPersonModuleTranslation('EXPERIENCE_YEAR'),
						width: 125,
						readOnly:true,
						name:'experienceInYear',
						itemId : 'experienceInYear',
					},{
						xtype : 'textfield',
						fieldLabel : getPersonModuleTranslation('EXPERIENCE_MONTH'),
						width: 125,
						readOnly:true,
						name:'experienceInMonth',
						itemId : 'experienceInMonth',
					}]
				}]});
		return objArray;
	},

	getPersonalCommonFormWithSalutationField: function(itemsArray, personType, detailsArray) {
		var objArray = new Array();
		for(var i = 0; i< detailsArray.length;i++){
			objArray.push(detailsArray[i]);
		}


		objArray.push({

			xtype: 'panel',
			style: {
				marginTop: '0px !important'
			},
			itemId: 'profileImageItemId',
			hidden: true,
			layout: {
				type: 'hbox'
			},
			width: '100%',
			items: [{
				xtype:'image',
				itemId: 'profile_image',
				border: 1,
				style: {
					borderColor: '#e0e0e0',
					borderStyle: 'solid',
					borderRadius:'50%',
					marginTop: '25px !important',
					marginLeft: '13px !important'
				},
				width: 64,
				height: 64,
				src: 'resources/images/default-profile.png'
			},{
			    xtype: 'container', // Using container to manage custom HTML
			    itemId: 'profile_image_icon',
			    hidden: false,
			    style: {
			        marginTop: '25px',
			        marginLeft: '13px'
			    },
			    html: '<span class="hoverElement" style="display: inline-block; width: 25px; height: 25px; border: 1px solid #e0e0e0; border-radius: 50%; overflow: hidden; padding: 5px; position: absolute; left: -32px; background-color: #fff; top: 35px;">' +
			          '<img class="hoverImage" src="resources/images/Edit_Pro.svg" style="width: 100%; height: 100%; object-fit: cover;">' +
			          '</span>'
			},{
				xtype: 'hidden',
		    	itemId: 'hiddenImageItemId',
		    	name: 'hiddenImage'
			}]

		
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'nestedJsonCombo',
				fieldLabel: getCommonTranslation('SALUTATION'),
				itemId:'salutationId',
				name: 'salutation',
				store: 'common.SalutationStore',
				valueField: 'id',
				displayField: 'salutationName',
			//	queryMode: 'local',
				editable: false
			}, {
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('PERSON_FIRST_NAME'),
				name: 'firstName',
				itemId:'firstNameId',
				maxLength : 100,
				enforceMaxLength :true,
				allowBlank: false,
				//as per SYSCOM requirement vtype removed
//				vtype: 'spaceAndSpecialCharactersAsInput'
			}, {
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('PERSON_MIDDLE_NAME'),
				name: 'middleName',
				itemId:'middleNameId',
				maxLength : 53,
				enforceMaxLength :true,
				//as per SYSCOM requirement vtype removed
//				vtype: 'spaceAndSpecialCharactersAsInput'
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('PERSON_LAST_NAME'),
				name: 'lastName',
				itemId: 'lastNameId',
				maxLength : 100,
				enforceMaxLength :true,
				//as per SYSCOM requirement vtype removed
//				vtype: 'spaceAndSpecialCharactersAsInput'
			}]
		}, {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [/*{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('PERSON_LAST_NAME'),
				name: 'lastName',
				itemId: 'lastNameId',
				maxLength : 100,
				enforceMaxLength :true,
				//as per SYSCOM requirement vtype removed
//				vtype: 'spaceAndSpecialCharactersAsInput'
			},*/{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('PERSON_SHORT_NAME'),
				name: 'shortName',
				itemId: 'shortNameId',
				maxLength : 100,
				enforceMaxLength :true,
				allowBlank: false,
				//as per SYSCOM requirement vtype removed
//				vtype: 'spaceAndSpecialCharactersAsInput'
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('PERSON_INITIALS'),
				name: 'initials',
				itemId: 'initialsId',
				maxLength : 5,
				enforceMaxLength :true,
				allowBlank: true,
				stripCharsRe: /[^0-9a-zA-Z]/g,
				//as per SYSCOM requirement vtype removed
//				vtype: 'spaceAndSpecialCharactersAsInput'
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('PERSON_PRINT_NAME'),
				minLength: 3,
				name: 'printName',
				itemId: 'printNameId',
				//as per SYSCOM requirement vtype removed
//				vtype: 'spaceAndSpecialCharactersAsInput',
				allowBlank: false
			},{
				xtype: 'nestedJsonCombo',
				fieldLabel: getCommonTranslation('GENDER'),
				itemId: 'genderCSM',
				name: 'genderCSM',
				valueField: 'id',
				displayField: 'value',
				store: 'Academia.store.common.GenderTypeStore',
			//	queryMode: 'local',
				editable: false,
				allowBlank: false
			}]
		}, {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [ {
				xtype: 'nestedJsonCombo',
				name: 'fieldOfInterest',
				itemId:'fieldOfInterestItemId',
				store:'personinfo.common.personalinfo.FieldOfInterestStore',
				//allowBlank:false,
				fieldLabel: getCommonTranslation('FIELD_OF_INTEREST'),
				valueField: 'id',
				displayField: 'value',
				//typeAhead:true,
				//disabled:false,
				editable: false,
	            disableKeyFilter: false,
				forceSelection:true 
			} ,{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('FIRST_NAME_OTHER_LANGUAGE'),
				name: 'firstNameOtherLanguage',
				itemId:'firstNameOtherLnguageId',
				maxLength : 100,
				enforceMaxLength :true,
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('MIDDLE_NAME_OTHER_LANGUAGE'),
				name: 'middleNameOtherLanguage',
				itemId:'middleNameOtherLnguageId',
				maxLength : 53,
				enforceMaxLength :true,
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('LAST_NAME_OTHER_LANGUAGE'),
				name: 'lastNameOtherLanguage',
				itemId: 'lastNameOtherLnguageId',
				maxLength : 100,
				enforceMaxLength :true,
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('SHORT_NAME_OTHER_LANGUAGE'),
				name: 'shortNameOtherLanguage',
				itemId: 'shortNameOtherLnguageId',
				maxLength : 100,
				enforceMaxLength :true,
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('PRINT_NAME_OTHER_LANGUAGE'),
				minLength: 3,
				name: 'printNameOtherLanguage',
				itemId: 'printNameOtherLnguageId',
			},/*{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('GENDER'),
				itemId: 'genderId',
				name: 'gender',
				valueField: 'id',
				displayField: 'value',
				store: 'enquiry.studentDetail.GenderStore',
				queryMode: 'local',
				editable: false,
				allowBlank: false
			}, */{
				xtype: 'datefield',
				fieldLabel: getPersonModuleTranslation('DATE_OF_BIRTH'),
				itemId: 'birthDateId',
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				/*listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},*/
				name: 'birthDate',
				maxValue: new Date(),
				allowBlank: false,
				listeners: {
					render : function(dateField){
						dateField = dateFormatRender(dateField);
						var date = new Date();
						if(personType === 'STUDENT'){
							dateField.setMaxValue(date);
						}else if(personType == 'FACULTY'){
							date.setFullYear(date.getFullYear()-18);
							dateField.setMaxValue(date);
						}
						return dateField;
					}/*,
					afterrender : function(date) {
						return dateFormatRender(date);
					}*/
				}
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('BIRTH_PLACE'),
				name: 'birthPlace',
				itemId: 'birthPlaceItemId',
				maxLength : 55,
				enforceMaxLength :true,
				allowBlank: true
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [
			{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('AGE'),
				itemId: 'ageId',
				name: 'age',
				valueField: 'id',
				displayField: 'age',
				editable: false,
				allowBlank: true
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('BIRTH_PLACE_LANGUAGE'),
				name: 'birthPlaceOtherLanguage',
				itemId: 'birthPlaceOtherLanguageItemId',
				maxLength : 55,
				enforceMaxLength :true,
				allowBlank: true
			},{
				xtype: 'nestedJsonCombo',
				fieldLabel: getPersonModuleTranslation('COUNTRY'),
				store: 'common.CountryStore',
				itemId: 'countryCombo',
				valueField: 'id',
				displayField: 'countryName',
				name: 'country',
				editable: true,
				queryParam:'countryName',
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				}
			},{
				xtype: 'nestedJsonCombo',
				fieldLabel: getPersonModuleTranslation('NATIONALITY'),
				itemId: 'nationalityCombo',
				store: 'common.NationalityStore',
				valueField: 'id',
				displayField: 'value',
				name: 'nationality',
				queryMode: 'local',
				editable: true,
				minChars:3,
				typeAhead:false,
				hideTrigger:false,
				forceSelection:true ,
				anyMatch:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}'  +
						'</div>';
					}
				}
			}]
		},{

			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'nestedJsonCombo',
				fieldLabel: getCommonTranslation('SECONDARY_CITIZENSHIP'),
				itemId: 'stuSecondaryCitizenshipItemId',
				store: Ext.create('Academia.store.common.NationalityStore'),
				valueField: 'id',
				displayField: 'value',
				name: 'secondaryCitizenship',
				disableKeyFilter: false,
			//	queryMode: 'local',
				editable: false
			},{
				xtype: 'nestedJsonCombo',
				name: 'sadcCitizenship',
				itemId:'sadcCitizenship',
				store:'personinfo.common.personalinfo.SADCCitizenshipStore',
				allowBlank:true,
				fieldLabel: getPersonModuleTranslation('SADC_CITIZENSHIP'),
				valueField: 'id',
				displayField: 'value',
				editable: false,
	            disableKeyFilter: false
			},{
				xtype: 'customcombobox',
				fieldLabel: getAdmissionTranslation('ID_TYPE'),
				itemId: 'idTypeCombo',
				store: Ext.create('Academia.store.common.IDTypeStore'),
				valueField: 'id',
				displayField: 'idTypeName',
				name: 'idtype',
				width: 226,
				hidden: true,
				editable: false
			},{
				xtype: 'textfield',
			    name: 'idNumberSecond',
			    itemId: 'idNumberSecond',
			    width: 226,
			    fieldLabel: getCommonTranslation('ID_NUMBER_SECOND'),
			    maxLength: 50,
			    hidden: true
			}]
		
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'textfield',
			    name: 'nationalID',
			    itemId: 'nationalIDItemId',
			    width: 226,
			    fieldLabel: getPersonModuleTranslation('PP_NATIONAL_ID'),
			    maxLength: 50,
			   // vtype: 'NoSpecialCharactersWithNumberWithoutSpaceAsInput',
			},{
				xtype: 'button',
				text: getPersonModuleTranslation('VALIDATE_ID'),
				ui: 'CustomBtnSubmit',
				itemId:'validateID',
				hidden: true,
				style:{marginTop:'29px'}
			},{
				xtype: 'button',
				text: getPersonModuleTranslation('VERIFY_DETAILS'),
				ui: 'CustomBtnThird',
				itemId:'verifyDetail',
				hidden: true,
				style:{marginTop:'29px'}
			},{
				xtype: 'datefield',
				name: 'identityExpiryDate',
				itemId: 'identityExpiryDateItemId',
				fieldLabel: getPersonModuleTranslation('IDENTITY_EXPIRY_DATE'),
				allowBlank: true,
				vtype: 'daterange',
				hidden: true,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			},{
				xtype: 'datefield',
				fieldLabel: getPersonModuleTranslation('DATE_OF_ADMISSION'),
				name: 'admissionDate',
				itemId :'admissionDate',
				readOnly:true,
				listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				}
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226		
			},
			items: [ {
				xtype: 'nestedJsonCombo',
				fieldLabel: getPersonModuleTranslation('DOMICILE'),
				itemId: 'domicileCombo',
				store: 'common.DomicileStore',
				valueField: 'id',
				displayField: 'value',
				name: 'domicile',
				editable: false
			},{
				xtype: 'nestedJsonCombo',
				name: 'examCenterCSM',
				itemId:'examCenterCSM',
				store:'enquiry.ExamCenterCSMStore',
				fieldLabel: getProgramandcourseTranslation('EXAM_CENTER'),
				valueField: 'id',
				displayField: 'value',
				editable: false,
	            disableKeyFilter: false,
				forceSelection:true
			},{
				xtype: 'customcombobox',
				fieldLabel: getCommonTranslation('EXAM_CENTER_VENUE'),
				itemId: 'examCenterVenue',
				name: 'examCenterVenue',
				store: Ext.create('Academia.store.enquiry.studentDetail.ExamCenterEnumStore'),
				valueField: 'id',
				displayField: 'value',
				editable: false,
				allowBlank: true
			},{
				xtype: 'nestedJsonCombo',
				name: 'currentActivity',
				itemId:'currentActivity',
				store:'enquiry.CurrentActivityStore',
				fieldLabel: getAdmissionTranslation('CURRENT_ACTIVITY'),
				valueField: 'id',
				displayField: 'value',
				editable: false,
				disableKeyFilter: false,
				forceSelection:true 
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226,
				tdAttrs: { 
					style: 'padding: 8px;',
				}					
			},
			items: [{
				xtype: 'multiselectcombofield',
				name: 'haveDisabilities',
				itemId:'haveDisabilities',
				addAllSelector: false,
				store:'personinfo.common.personalinfo.HaveDisibilitiesStore',
				fieldLabel: getPersonModuleTranslation('DOES_HAVE_DISABILITIES'),
				valueField: 'id',
				displayField: 'value',
				editable: false,
	            disableKeyFilter: false,
	            cls:'commonAutoHeightMultiselectField',
				forceSelection:true ,
				maxLength:1000,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						},
						refresh: function( boundList, eOpts ){
							try{
								var combo = boundList.up('combo');
									var newValue = combo.getValue();
									if(!isNullOrEmpty(newValue[0])){
										var allItems = combo.listKeyNav.boundList.all.elements;
										var selectedId = 0;
										var comboStore = combo.getStore();
										if(typeof combo.getValue() == "string"){
											selectedId = combo.getValue();
										}
										else{
											selectedId = combo.getValue()[0].get('id');
										}
										if(selectedId){
											var selectedRecord = comboStore.findRecord('id',selectedId);
										}
										if(selectedRecord.data.value =='none' || selectedRecord.data.value =='None'){
											Ext.each(allItems, function(currentItem){
												var currentNoneId = currentItem.viewRecordId;
												var currentNoneRecord = comboStore.findRecord('id',currentNoneId);
												if(currentNoneRecord.get('value') == 'none' || currentNoneRecord.get('value')  == 'None'){
													currentItem.classList.remove("disabledComboItem")
												}
												else{
													currentItem.classList.add("disabledComboItem");
												}
											});
										}
									}
							}
							catch(e){
								console.log(e);
							}
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{code}' +
						'</div>';
					}
				},
				listeners:{
					beforeselect:function(selModel,record,index){
						var combo = selModel.view.field;
						var comboStore = selModel.getStore();
						if(record.data.value == 'none' || record.data.value == 'None'){
							var allItems = selModel.listKeyNav.boundList.all.elements;
							Ext.each(allItems, function(currentItem){
								var noneRecordId = currentItem.viewRecordId;
								var nonRecordList = comboStore.findRecord('id',noneRecordId);
								if(nonRecordList.get('value') == 'none' || nonRecordList.get('value') == 'None'){
									currentItem.classList.remove("disabledComboItem")
								}
								else{
									currentItem.classList.add("disabledComboItem");
								}
							});
						}
						
						if(!isNullOrEmpty(combo.getValue()) && combo.getValue() != "") {
							var value = combo.getValue();
							if(record.data.value == 'none' || record.data.value == 'None'){
								combo.setValue('');
							}
							var selectedValue;
							if(isArray(value)){
								selectedValue = value[0].get('value');
							}else{
								selectedValue = value;
							}
							//var topS = selModel.getHeight();
							//selModel.up('personalinformationform').up().body.setScrollTop(topS);
							if(!isNullOrEmpty(selectedValue)){
								if(selectedValue == 'none' || selectedValue == 'None'){
									return false;
								}
							}
						}else{
							//var topS = selModel.getHeight();
							//selModel.up('personalinformationform').up().body.setScrollTop(topS);
						}
					},
					change: function(combo, newValue, oldValue) {
                        var comboStore = combo.getStore();
                        if(!isNullOrEmpty(combo.listKeyNav)){
                            var allItems = combo.listKeyNav.boundList.all.elements;
                            var value=combo.getDisplayValue();
                            if(value.length == 0 ){
                                Ext.each(allItems, function(currentItem) {
                                    currentItem.classList.remove("disabledComboItem");
                                });
                            }else if(value == "None" || value == "none"){
                                var noneId=combo.getValue();
                                Ext.each(allItems, function(currentItem) {
                                    if(noneId[0]!=currentItem.viewRecordId){
                                        currentItem.classList.add("disabledComboItem");
                                    }
                                });  
                            }
                        }
                    } 
				}
			}, { 
				xtype: 'textareafield',
				name: 'ifOtherPleaseGiveDetails',
				itemId : 'ifOtherPleaseGiveDetails',
				fieldLabel: getPersonModuleTranslation('IF_OTHER_PLEASE_GIVE_DETAILS'),
				labelAlign: 'top',
				maxLength: 300
			}, {
				xtype: 'multiselectcombofield',
				name: 'currentEducationalInterventions',
				itemId:'currentEducationalInterventionsItemId',
				store:'personinfo.common.personalinfo.CurrentEducationalIntervention',
				fieldLabel: getPersonModuleTranslation('PP_CURRENT_EDUCATIONAL_INTERVENTIONS'),
				valueField: 'id',
				displayField: 'value',
				//typeAhead:true,
				//disabled:false,
				editable: false,
				disableKeyFilter: false,
				forceSelection:true,
				cls:'commonAutoHeightMultiselectField',
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('LEAD_CHANNEL'),
				name: 'leadChannel',
				itemId:'leadChannel',
				allowBlank: true,
				maxLength: 70
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226/*,
				tdAttrs: { 
					style: 'padding: 5px;',
				}			*/		
			},
			items: [{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('AGENCYS_NAME'),
				name: 'agencysName',
				itemId:'agencysName',
    			allowBlank: true,
    			maxLength: 70
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('LEAD_OWNER'),
				name: 'leadOwner',
				itemId:'leadOwner',
				allowBlank: true,
				hidden:true,
				maxLength: 70
			},{
				xtype: 'datefield',
				name: 'unconditionalOfferSentDate',
				itemId: 'unconditionalOfferSentDate',
				fieldLabel: getPersonModuleTranslation('UNCONDITIONAL_OFFER_SENT_DATE'),
				allowBlank: true,
				vtype: 'daterange',
				listeners: {
						render: function(field) {
						return dateFormatRender(field);
						}
				}
			},{
				xtype: 'nestedJsonCombo',
				name: 'currentOrLastSchoolAttended',
				itemId: 'currentOrLastSchoolAttended',
				fieldLabel: getCommonTranslation("CURRENT_OR_LAST_SCHOOL_ATTENDED"),
				valueField: 'schoolId',
				displayField: 'schoolName',
				store: Ext.create('Academia.store.campaignnew.CampaignSchoolNameStore'),
				queryParam:'schoolName',
				minChars:3,
				allowBlank:true,
				forceSelection :false,
				hidden :false,
				disableKeyFilter: false,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				listConfig: {
						listeners: {
							beforeshow: function(picker) {
								picker.minWidth = picker.up('combobox').getSize().width;
								picker.width = picker.up('combobox').getSize().width;
							}
						},
				loadingText: getCommonTranslation('SEARCHING'),
						emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
						getInnerTpl: function() {
							return '<div class="search-item">' +
							'{value}' +
							'</div>';
						}
					}
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226				
			},
			items: [{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('PP_SPECIFY_OTHER'),
				name: 'specifyOther',
				itemId:'specifyOtherItemId',
				enforceMaxLength :true,
				hidden: true,
				maxLength: 100
				//allowBlank: false
			},{
				xtype: 'nestedJsonCombo',
				name: 'areaOfResearch',
				itemId:'areaOfResearchItemId',
				store:'personinfo.common.personalinfo.AreaOfResearchStore',
				//allowBlank:false,
				fieldLabel: getCommonTranslation('AREA_OF_RESEARCH'),
				valueField: 'id',
				displayField: 'value',
				//typeAhead:true,
				//disabled:false,
				editable: false,
	            disableKeyFilter: false,
				forceSelection:true 
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('ENTRY_ROUTE'),
				name: 'entryRoute',
				itemId:'entryRoute',
				allowBlank: true,
				maxLength: 70
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('PLEASE_CHOOSE_AFTER_READING_INFO'),
				name: 'pleaseChooseAfterReadingInfo',
				itemId:'pleaseChooseAfterReadingInfo',
				hidden:true,
    			allowBlank: true,
    			maxLength: 70
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226/*,
				tdAttrs: { 
					style: 'padding: 5px;',
				}			*/		
			},
			items: [{
				xtype: 'customcombobox',
				name: 'studentStatus',
				itemId: 'studentStatusItemId',
				store: 'student.studentprofile.StudentStatusCSMStore',
				fieldLabel: getCommonTranslation('STUDENT_STATUS_CSM'),
				valueField: 'id',
				displayField: 'value',
				readOnly :true,
				allowBlank: true,
				forceSelection: true,
				editable: false,
				hidden: true
			},{
				xtype: 'multiselectcombofield',
				name: 'studentAttendanceGroup',
				itemId:'studentAttendanceGroup',
				style:{height:"28px !important"},
				store:'personinfo.common.personalinfo.StudentAttendanceGroupStore',
				fieldLabel: getPersonModuleTranslation('STUDENT_GROUP'),
				valueField: 'id',
				displayField: 'value',
				editable: false,
	            disableKeyFilter: false,
				forceSelection:true,
				hidden : true
			},{
				xtype: 'customcombobox',
				name: 'advisorId',
				itemId:'advisorItemId',
				fieldLabel: getPersonModuleTranslation('ADVISOR_NAME'),
	            store: Ext.create('Academia.store.coursetransaction.sectionmanagement.FacultyIdValueSmartSearch'),
				valueField: 'id',
				displayField: 'valueCode',
				queryParam:'codeOrName',
				triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
				enableKeyEvents  : 'true',
				minChars:3,
				typeAhead:false,
				forceSelection:true,
				emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				triggerAction: '',
				hideTrigger:false,
	            maxLength: 100,
				listConfig: {
					listeners: {
						beforeshow: function(picker) {
							picker.minWidth = picker.up('combobox').getSize().width;
						}
					},
					loadingText: getCommonTranslation('SEARCHING'),
					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
					getInnerTpl: function() {
						return '<div class="search-item">' +
						'{studentCode} / {studentName}' +
						'</div>';
					}
				}
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('DATE_TIME_OF_INTERVIEW'),
				name: 'dateTimeOfInterview',
				itemId:'dateTimeOfInterview',
				allowBlank: true,
				maxLength: 70,
				readOnly: true
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226,
				tdAttrs: { 
					style: 'padding: 5px;',
				}					
			},
			items: [{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('ENGLISH_PROFICIENCY'),
				name: 'englishProficiency',
				itemId:'englishProficiency',
    			allowBlank: true
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('MOTIVATION'),
				name: 'motivation',
				itemId:'motivation',
				allowBlank: true,
				maxLength: 70
			}, { 
				xtype: 'textareafield',
				name: 'commentsByInterviewer',
				itemId : 'commentsByInterviewer',
				fieldLabel: getPersonModuleTranslation('COMMENTS_BY_INTERVIEWER'),
				labelAlign: 'top',
				maxLength: 300
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('DECISION_BY_INTERVIEWER'),
				name: 'decisionByInterviewer',
				itemId:'decisionByInterviewer',
				allowBlank: true,
				maxLength: 70
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226/*,
				tdAttrs: { 
					style: 'padding: 5px;',
				}			*/		
			},
			items: [{
		    	xtype: 'checkboxfield',
				itemId : 'isLearnerSACitizenField',
				labelAlign: 'right',
				region: 'south',
				boxLabel: getPersonModuleTranslation('IS_STUDENT_SA_CITIZEN'),
				name: 'isLearnerSACitizen',
				checked:true,
				inputValue: true,
				uncheckedValue: false,
				style:{
					marginTop:'30px'
				}
		    },{
				xtype: 'checkboxfield',
				itemId : 'isMidtermJoineeField',
				labelAlign: 'right',
				region: 'south',
				boxLabel: getPersonModuleTranslation('MID_TERM_JOINEE'),
				name: 'isMidtermJoinee',
				inputValue: true,
				uncheckedValue: false,
				style:{
					marginTop:'30px'
				}
			},{
				xtype: 'nestedJsonCombo',
				name: 'homeLanguage',
				itemId:'homeLanguage',
				store:'personinfo.common.personalinfo.HomeLanguageStore',
				fieldLabel: getPersonModuleTranslation('HOME_LANGUAGE'),
				valueField: 'id',
				displayField: 'value',
				//typeAhead:true,
				//disabled:false,
				editable: false,
	            disableKeyFilter: false
			}, {
				xtype: 'nestedJsonCombo',
				name: 'secondLanguage',
				itemId:'secondLanguage',
				store:'personinfo.common.personalinfo.SecondLanguageStore',
				//allowBlank:false,
				fieldLabel: getPersonModuleTranslation('SECOND_LANGUAGE'),
				valueField: 'id',
				displayField: 'value',
				//typeAhead:true,
				//disabled:false,
				editable: false,
	            disableKeyFilter: false,
				forceSelection:true 
			}]
		},{

			xtype: 'fieldcontainer',
			layout: 'hbox',
			height:'auto',
			defaults: {
				labelAlign: 'top',
				width: 226
				/*
				minHeight:76,
				tdAttrs: { 
					style: 'padding: 5px;',
				}			*/		
			},
			items: [{
				xtype: 'nestedJsonCombo',
				name: 'correspondenceLanguage',
				itemId:'stuCorrespondenceLanguageItemId',
				store:Ext.create('Academia.store.common.MultiLanguageCorrespondenceLangStore'),
				fieldLabel: getCommonTranslation('CORRESPONDENCE_LANGUAGE'),
				valueField: 'id',
				displayField: 'value',
				editable: false,
	            disableKeyFilter: false,
				forceSelection:true
			},{
				xtype: 'nestedJsonCombo',
				name: 'contactLanguage',
				itemId:'stuContactLanguageItemId',
				store:Ext.create('Academia.store.common.MultiLanguageContactLangStore'),
				fieldLabel: getCommonTranslation('CONTACT_LANGUAGE'),
				valueField: 'id',
				displayField: 'value',
				editable: false,
	            disableKeyFilter: false,
				forceSelection:true			
			},{
				 xtype      : 'radiogroup',
				 fieldLabel : getCommonTranslation('WHEEL_CHAR_REQUIRED'),
				 itemId: 'stuIsWheelCharRequiredItemId',
				 name: 'isWheelChairRequired',
				 minHeight:76,
				 defaults: {
					 flex: .5
				 },
				 layout: 'hbox',
				 items:[{ 
					 boxLabel: getCommonTranslation('YES'), 
					 name: 'isWheelChairRequired', 
					 inputValue: true
				 },{ 
					 boxLabel: getCommonTranslation('NO'), 
					 name: 'isWheelChairRequired', 
					 inputValue: false,
					 checked:true
				 }]
			 }, {
				 xtype      : 'radiogroup',
				 fieldLabel : getCommonTranslation('PERMANENT_RESIDENCY'),
				 itemId: 'stuPermanentResItemId',
				 name: 'isPermanentResident',
				 minHeight:76,
				 defaults: {
					 flex: 1
				 },
				 layout: 'hbox',
				 items:[{ 
					 boxLabel: getCommonTranslation('YES'), 
					 name: 'isPermanentResident', 
					 inputValue: true
				 },{ 
					 boxLabel: getCommonTranslation('NO'), 
					 name: 'isPermanentResident', 
					 inputValue: false,
					 checked:true
				 }]
			 }]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226,
				minHeight:76,
				tdAttrs: { 
					style: 'padding: 5px;',
				}					
			},
			items: [{
				 xtype      : 'radiogroup',
				 fieldLabel : getCommonTranslation('ASYLUM_SEEKER'),
				 itemId: 'stuAsylumSeekerItemId',
				 name: 'isAsylumSeeker',
				 defaults: {
					 flex: 1
				 },
				 layout: 'hbox',
				 items:[{ 
					 boxLabel: getCommonTranslation('YES'), 
					 name: 'isAsylumSeeker', 
					 inputValue: true
				 },{ 
					 boxLabel: getCommonTranslation('NO'), 
					 name: 'isAsylumSeeker', 
					 inputValue: false,
					 checked:true
				 }]
			 },{ 
				 xtype      : 'radiogroup',
				 fieldLabel : getCommonTranslation('ARE_YOU_A_REFUGEE'),
				 itemId: 'stuAreYouRefugeeItemId',
				 name: 'areYouRefugee',
				 defaults: {
					 flex: 1
				 },
				 layout: 'hbox',
				 items:[{ 
					 boxLabel: getCommonTranslation('YES'), 
					 name: 'areYouRefugee', 
					 inputValue: true
				 },{ 
					 boxLabel: getCommonTranslation('NO'), 
					 name: 'areYouRefugee', 
					 inputValue: false,
					 checked:true
				 }]
			},{
				 xtype      : 'radiogroup',
				 fieldLabel : getCommonTranslation('DIPLOMATIC_STATUS'),
				 itemId: 'diplomaticStatusId',
				 name: 'diplomaticStatus',
				 defaults: {
					 flex: 1
				 },
				 layout: 'hbox',
				 items:[{ 
					 boxLabel: getCommonTranslation('YES'), 
					 name: 'diplomaticStatus', 
					 inputValue: true
				 },{ 
					 boxLabel: getCommonTranslation('NO'), 
					 name: 'diplomaticStatus', 
					 inputValue: false,
					 checked:true
				 }]
			 }, {
				 xtype      : 'radiogroup',
				 fieldLabel : getCommonTranslation('TEMPORARY_STUDY_VISA'),
				 itemId: 'temporaryStudyId',
				 name: 'temporaryStudy',
				 defaults: {
					 flex: 1
				 },
				 layout: 'hbox',
				 items:[{ 
					 boxLabel: getCommonTranslation('YES'), 
					 name: 'temporaryStudy', 
					 inputValue: true
				 },{ 
					 boxLabel: getCommonTranslation('NO'), 
					 name: 'temporaryStudy', 
					 inputValue: false,
					 checked:true
				 }]
			 }]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			height:'auto',
			defaults: {
				labelAlign: 'top',
				width: 226,
				minHeight:76,
				tdAttrs: { 
					style: 'padding: 5px;',
				}					
			},
			items: [{
				 xtype      : 'radiogroup',
				 fieldLabel : getCommonTranslation('WORK_CRITICAL_SKILLS_VISA'),
				 itemId: 'workCriticalSkillsId',
				 name: 'workCriticalSkills',
				 defaults: {
					 flex: 1
				 },
				 layout: 'hbox',
				 items:[{ 
					 boxLabel: getCommonTranslation('YES'), 
					 name: 'workCriticalSkills', 
					 inputValue: true
				 },{ 
					 boxLabel: getCommonTranslation('NO'), 
					 name: 'workCriticalSkills', 
					 inputValue: false,
					 checked:true
				 }]
			 },{
				xtype      : 'radiogroup',
				 fieldLabel : getCommonTranslation('POSTGRADUATE_NON-RESIDENTIAL_STUDENT'),
				 itemId: 'postgraduateNonResidentialStudentId',
				 name: 'postgraduateNonResidentialStudent',
				 defaults: {
					 flex: 1
				 },
				 layout: 'hbox',
				 items:[{ 
					 boxLabel: getCommonTranslation('YES'), 
					 name: 'postgraduateNonResidentialStudent', 
					 inputValue: true
				 },{ 
					 boxLabel: getCommonTranslation('NO'), 
					 name: 'postgraduateNonResidentialStudent', 
					 inputValue: false,
					 checked:true
				 }]
			},{
				 xtype      : 'radiogroup',
				 fieldLabel : getCommonTranslation('STUDYING_TERTIARY_INSTITUTION'),
				 itemId: 'stuIsStudyingInstitutionItemId',
				 name: 'isTertiaryInstitution',
				 defaults: {
					 flex: 1
				 },
				 layout: 'hbox',
				 items:[{ 
					 boxLabel: getCommonTranslation('YES'), 
					 name: 'isTertiaryInstitution', 
					 inputValue: true
				 },{ 
					 boxLabel: getCommonTranslation('NO'), 
					 name: 'isTertiaryInstitution', 
					 checked:true,
					 inputValue: false
				 }]
			},{
				 xtype      : 'radiogroup',
				 fieldLabel : getCommonTranslation('IS_ENROLLED_TERTIARY_INSTITUTION'),
				 itemId: 'isEnrolledTertiaryItemId',
				 name: 'isEnrolledTertiaryInstitute',
				 defaults: {
					 flex: 1
				 },
				 layout: 'hbox',
				 items:[{ 
					 boxLabel: getCommonTranslation('YES'), 
					 name: 'isEnrolledTertiaryInstitute', 
					 inputValue: true
				 },{ 
					 boxLabel: getCommonTranslation('NO'), 
					 name: 'isEnrolledTertiaryInstitute', 
					 checked:true,
					 inputValue: false
				 }]
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			height:'auto',
			defaults: {
				labelAlign: 'top',
				width: 226,
				minHeight:76,
				tdAttrs: { 
					style: 'padding: 5px;',
				}					
			},
			items: [{
				 xtype      : 'radiogroup',
				 fieldLabel : getCommonTranslation('MILITARY_SPONSORED'),
				 itemId: 'isMilitarySponsoredItemId',
				 name: 'isMilitarySponsored',
				 defaults: {
					 flex: 1
				 },
				 layout: 'hbox',
				 items:[{ 
					 boxLabel: getCommonTranslation('YES'), 
					 name: 'isMilitarySponsored', 
					 inputValue: true
				 },{ 
					 boxLabel: getCommonTranslation('NO'), 
					 name: 'isMilitarySponsored', 
					// checked:true,
					 inputValue: false					 
				 }]
			 },{
				 xtype      : 'radiogroup',
				 fieldLabel : getCommonTranslation('PHD_SPONSOR'),
				 itemId: 'pHDSponsorItemId',
				 name: 'pHDSponsor',
				 defaults: {
					 flex: 1
				 },
				 layout: 'hbox',
				 items:[{ 
					 boxLabel: getCommonTranslation('PHD_SPONSOR_DOD'), 
					 name: 'pHDSponsor', 
					 inputValue: 'DOD'
				 },{ 
					 boxLabel: getCommonTranslation('PHD_SPONSOR_MYSELF'),
					 name: 'pHDSponsor',
					// checked:true,
					 inputValue: 'MYSELF'
				 }]
			 },{
				 xtype      : 'radiogroup',
				 fieldLabel : getCommonTranslation('BURSARY_REQUIREMENTS'),
				 itemId: 'isBursaryRequirementsItemId',
				 name: 'isBursaryRequirements',
				 //width: 200,
				 defaults: {
					 flex: 1
				 },
				 layout: 'hbox',
				 items:[{ 
					 boxLabel: getCommonTranslation('YES'), 
					 name: 'isBursaryRequirements', 
					 inputValue: true
				 },{ 
					 boxLabel: getCommonTranslation('NO'), 
					 name: 'isBursaryRequirements', 
					// checked:true,
					 inputValue: false
				 }]
			 },{
				 xtype      : 'radiogroup',
				 fieldLabel : getCommonTranslation('IS_RPL_APPLICANT'),
				 itemId: 'whetherRPLApplicant',
				 name: 'whetherRPLApplicant',
				 //width: 200,
				 defaults: {
					 flex: 1
				 },
				 layout: 'hbox',
				 items:[{ 
					 boxLabel: getCommonTranslation('YES'), 
					 name: 'whetherRPLApplicant', 
					 inputValue: true
				 },{ 
					 boxLabel: getCommonTranslation('NO'), 
					 name: 'whetherRPLApplicant', 
					 inputValue: false
				 }]
			 }]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226,
			},
			items: [{
				 xtype      : 'radiogroup',
				 fieldLabel : getCommonTranslation('IS_AUTOMATE_EXCHANGE'),
				 itemId: 'isAutomateExchange',
				 name: 'isAutomateExchange',
				 hidden:true,
				 minHeight:76,
				 defaults: {
					 flex: 1
				 },
				 layout: 'hbox',
				 items:[{ 
					 boxLabel: getCommonTranslation('YES'), 
					 name: 'isAutomateExchange', 
					 inputValue: true
				 },{ 
					 boxLabel: getCommonTranslation('NO'), 
					 name: 'isAutomateExchange', 
					 inputValue: false,
					 checked:true
				 }]
			 },{
				 xtype: 'nestedJsonCombo',
				 fieldLabel: getCommonTranslation('GOVERNMENT_SPONSOR'),
				 itemId:'governmentSponsorId',
                 name: 'governmentSponsorCSM',
                 valueField: 'id',
                 displayField: 'value',
                 store:'personinfo.common.personalinfo.GovernmentSponsorStore',
                 allowBlank: true,
                 editable: false,
                 forceSelection: true
                // disableKeyFilter: false
			},{
				xtype: 'profiledocuploadform',
				itemId: 'studentDocUploadForm',	
				hidden:true
				
			},{
				xtype: 'profiledocuploadform',
				itemId: 'applicantDocUploadForm',	
				hidden:true
			},{
				xtype: 'displayfield',
				itemId: 'studentDownloadURL',
				hidden:true,
				style: {
				    'margin-left': '10px',
				    'margin-top': '7px',
				    'word-break': 'break-word',  // Ensure long words are wrapped
				    'white-space': 'normal'
				},
				name:'supportDocument',
				renderer:function(value,meta,record){
    				if(value==0){
    					return value;
    				}
    				else {
    					return '<a href=#>'+value+'</a>'
    				}
    			},
				listeners: {
					afterrender: function(c){
		    			c.getEl().on('click', function(){
		    				var path = this.up('personalinformationform').down('#studentDownloadURL').getValue()
		    	       		var csvForm = Ext.create('Ext.form.Panel'); 
		    				if(!isNullOrEmpty(path)){
		    	       		csvForm.getForm().submit({
		    	       			target: '_blank',
		    	       			method:'POST',
		    	       			params :{
		    	       				access_token : Ext.Ajax.defaultHeaders.access_token
		    	       			},
		    	       			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
		    	       			url: SERVERURL.PATH_DOWNLOAD_PERSON_DOC+'?path='+path,
		    	       			standardSubmit :true
		    	       		});
		    				}
		    			}, c);
		    		}
		    	}
				},{
					xtype: 'displayfield',
					itemId: 'applicantDownloadURL',
					style: {
					    'margin-left': '10px',
					    'margin-top': '7px',
					    'word-break': 'break-word',  // Ensure long words are wrapped
					    'white-space': 'normal'
					},
					name:'supportDocument',
					hidden:true,
					renderer:function(value,meta,record){
        				if(value==0){
        					return value;
        				}
        				else {
        					return '<a href=#>'+value+'</a>'
        				}
        			},
					listeners: {
			    		render: function(c){
			    			c.getEl().on('click', function(){
			    				var path = this.up('personalinformationform').down('#applicantDownloadURL').getValue()
			    	       		var csvForm = Ext.create('Ext.form.Panel'); 
			    				if(!isNullOrEmpty(path)){
			    	       		csvForm.getForm().submit({
			    	       			target: '_blank',
			    	       			method:'POST',
			    	       			params :{
			    	       				access_token : Ext.Ajax.defaultHeaders.access_token
			    	       			},
			    	       			headers :{'Authorization':Ext.Ajax.defaultHeaders.Authorization},
			    	       			url: SERVERURL.PATH_DOWNLOAD_APPLICANT_PERSON_DOC+'?path='+path,
			    	       			standardSubmit :true
			    	       		});
			    				}
			    			}, c);
			    		}
			    	}
					}]
			},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226,
			},
			items: [{
				    xtype: 'textfield',
		    	    name: 'academicBankCredits',
		    	    itemId: 'academicBankCredits',
		    	    width: 226,
		    	    fieldLabel: getCommonTranslation('ACADEMIC_BANK_OF_CREDITS_ABC'),
		    	    maxLength: 64
			    },{
					xtype: 'textfield',
					name: 'coaStudent',
					itemId: 'coaStudent',
					width: 226,
					fieldLabel: getCommonTranslation('COA'),
					maxLength: 64
				},{
					xtype: 'textfield',
					name: 'naadStudent',
					itemId: 'naadStudent',
					width: 226,
					fieldLabel: getCommonTranslation('NAAD'),
					maxLength: 64
			}]
		}
		);

		/*if(this.personType === 'FACULTY'){
    		this.getFacultypersonalFormField(objArray);
    	}else{
    		//this.getFamilyIncomeField(objArray);
    	}*/

		itemsArray.push({
			xtype: 'fieldset',
			itemId : 'personalFormField',
			title: getPersonModuleTranslation('PERSONAL_FORM_DETAILS'),
			collapsed: false,
			items: objArray
		});

		return itemsArray;
	},
	
	getPersonalCommonFormField: function(itemsArray, personType, detailsArray) {
		var objArray = new Array();
		for(var i = 0; i< detailsArray.length;i++){
			objArray.push(detailsArray[i]);
		}
		objArray.push({
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'nestedJsonCombo',
				fieldLabel: getCommonTranslation('SALUTATION'),
				itemId:'salutationId',
				name: 'salutation',
				store: 'common.SalutationStore',
				valueField: 'id',
				displayField: 'salutationName',
		//		queryMode: 'local',
				allowBlank: false,
				editable: false
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('FIRST_NAME'),
				name: 'firstName',
				itemId:'firstNameId',
				maxLength : 100,
				enforceMaxLength :true,
				allowBlank: false,
				//as per SYSCOM requirement vtype removed
//				vtype: 'spaceAndSpecialCharactersAsInput'
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('FIRST_NAME_OTHER_LANGUAGE'),
				name: 'firstNameOtherLanguage',
				itemId:'firstNameOtherLnguageId',
				maxLength : 100,
				enforceMaxLength :true,
				//allowBlank: false,
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('MIDDLE_NAME'),
				name: 'middleName',
				itemId:'middleNameId',
				maxLength : 53,
				enforceMaxLength :true,
				//as per SYSCOM requirement vtype removed
//				vtype: 'spaceAndSpecialCharactersAsInput'
			}]
		},{
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('MIDDLE_NAME_OTHER_LANGUAGE'),
				name: 'middleNameOtherLanguage',
				itemId:'middleNameOtherLnguageId',
				maxLength : 53,
				enforceMaxLength :true,
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('LAST_NAME'),
				name: 'lastName',
				itemId: 'lastNameId',
				maxLength : 100,
				enforceMaxLength :true,
				//as per SYSCOM requirement vtype removed
//				vtype: 'spaceAndSpecialCharactersAsInput'
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('LAST_NAME_OTHER_LANGUAGE'),
				name: 'lastNameOtherLanguage',
				itemId: 'lastNameOtherLnguageId',
				maxLength : 100,
				enforceMaxLength :true,
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('SHORT_NAME'),
				name: 'shortName',
				itemId: 'shortNameId',
				maxLength : 255,
				enforceMaxLength :true,
				allowBlank: false,
				//as per SYSCOM requirement vtype removed
//				vtype: 'spaceAndSpecialCharactersAsInput'
			}]
		}, {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('SHORT_NAME_OTHER_LANGUAGE'),
				name: 'shortNameOtherLanguage',
				itemId: 'shortNameOtherLnguageId',
				maxLength : 255,
				enforceMaxLength :true,
				//allowBlank: false,
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('PERSON_INITIALS'),
				name: 'initials',
				itemId: 'initialsId',
				maxLength : 5,
				enforceMaxLength :true,
				allowBlank: true,
				stripCharsRe: /[^0-9a-zA-Z]/g,
				//as per SYSCOM requirement vtype removed
//				vtype: 'spaceAndSpecialCharactersAsInput'
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('PRINT_NAME'),
				minLength: 3,
				name: 'printName',
				itemId: 'printNameId',
				//as per SYSCOM requirement vtype removed
//				vtype: 'spaceAndSpecialCharactersAsInput',
				allowBlank: false
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('PRINT_NAME_OTHER_LANGUAGE'),
				minLength: 3,
				name: 'printNameOtherLanguage',
				itemId: 'printNameOtherLnguageId',
				//allowBlank: false
			}]
		}, {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'nestedJsonCombo',
				fieldLabel: getCommonTranslation('GENDER'),
				itemId: 'genderId',
				name: 'genderCSM',
				valueField: 'id',
				displayField: 'value',
				store: 'Academia.store.common.GenderTypeStore',
		//		queryMode: 'local',
				editable: false,
				allowBlank: false
			}, {
				xtype: 'datefield',
				fieldLabel: getPersonModuleTranslation('DATE_OF_BIRTH'),
				itemId: 'birthDateId',
				//--submitFormat: CONSTANTS.DATE_FORMAT,
				/*listeners: {
					render: function(field) {
						return dateFormatRender(field);
					}
				},*/
				name: 'birthDate',
				maxValue: new Date(),
				allowBlank: false,
				listeners: {
					render : function(dateField){
						dateField = dateFormatRender(dateField);
						var date = new Date();
						if(personType === 'STUDENT'){
							dateField.setMaxValue(date);
						}else if(personType == 'FACULTY'){
							date.setFullYear(date.getFullYear()-18);
							dateField.setMaxValue(date);
						}
						return dateField;
					}/*,
					afterrender : function(date) {
						return dateFormatRender(date);
					}*/
				}
			},{
				xtype: 'nestedJsonCombo',
				fieldLabel: getPersonModuleTranslation('COUNTRY'),
				store: 'common.CountryStore',
				itemId: 'countryCombo',
				valueField: 'id',
				displayField: 'countryName',
				name: 'country',
	//			queryMode: 'local',
				editable: false,
//				allowBlank: false
			},{
				xtype: 'nestedJsonCombo',
				fieldLabel: getPersonModuleTranslation('NATIONALITY'),

				itemId: 'nationalityCombo',
				store: 'common.NationalityStore',
				valueField: 'id',
				displayField: 'value',
				name: 'nationality',
		//		queryMode: 'local',
//				allowBlank: false,
				editable: false
			}]
		}, {
			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'textfield',
			    name: 'nationalID',
			    itemId: 'nationalIDItemId',
			    fieldLabel: getPersonModuleTranslation('PP_NATIONAL_ID'),
			    maxLength: 50,
			    //vtype: 'NoSpecialCharactersWithNumberWithoutSpaceAsInput',
			},{
				xtype: 'button',
				text: getPersonModuleTranslation('VERIFY_DETAILS'),
				ui: 'CustomBtnThird',
				itemId:'employeeVerifyDetail',
				hidden: true,
				style:{marginTop:'29px'}
			},{
				xtype: 'datefield',
				name: 'identityExpiryDate',
				itemId: 'identityExpiryDateItemId',
				fieldLabel: getPersonModuleTranslation('IDENTITY_EXPIRY_DATE'),
				allowBlank: true,
				vtype: 'daterange',
				listeners: {
								render: function(field) {
									return dateFormatRender(field);
								}
							}
				//hidden: true
			},{
				xtype: 'nestedJsonCombo',
				fieldLabel: getPersonModuleTranslation('DOMICILE'),
				itemId: 'domicileCombo',
				store: 'common.DomicileStore',
				valueField: 'id',
				displayField: 'value',
				name: 'domicile',
		//		queryMode: 'local',
//				allowBlank: false,
				editable: false
			}]
		},{

			xtype: 'fieldcontainer',
			layout: 'hbox',
			defaults: {
				labelAlign: 'top',
				width: 226
			},
			items: [{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('HIGHEST_QUALIFICATION'), 
				itemId: 'highestQualification',
				name: 'highestQualification',
				enforceMaxLength:true,
				maxLength:100
			},{
				xtype: 'textfield',
				fieldLabel: getPersonModuleTranslation('AWARDING_INSTITUTION'), 
				itemId: 'awardingInstitution',
				name: 'awardingInstitution',
				enforceMaxLength:true,
				maxLength:100
			}]
		
		});

		/*if(this.personType === 'FACULTY'){
    		this.getFacultypersonalFormField(objArray);
    	}else{
    		//this.getFamilyIncomeField(objArray);
    	}*/

		itemsArray.push({
			xtype: 'fieldset',
			itemId : 'personalFormField',
			title: getPersonModuleTranslation('PERSONAL_FORM_DETAILS'),
			collapsed: false,
			items: objArray
		});

		return itemsArray;
	},

	getContactDetailsFormField: function(itemsArray) {
		var obj ={
				xtype: 'fieldset',
				title : getAdmissionTranslation('CONTACT_INFORMATION'),
				itemId : 'contactFieldSet',
				defaults: {
					labelAlign: 'top'
				},
					items: [{
						xtype: 'fieldcontainer',
						layout: 'hbox',
						defaults: {
							labelAlign: 'top'
						},
						items: [{
							 xtype: 'radiogroup',
							    fieldLabel: getCommonTranslation('IMAGE_MARKETING_CONSENT'),
							    itemId: 'imageMarketingCheckbox',
							    name: 'imageMarketingCheckbox',
							    hidden: true,
							    labelAlign: 'left', // Align the label to the left
							    labelWidth: 180, // Adjust the width of the label to your needs
							    layout: 'hbox',
							    items: [{
							            boxLabel: getCommonTranslation('YES'),
							            name: 'imageMarketingCheckbox',
							            inputValue: true,
							            checked: false,
							            style: 'margin-right: 10px;' // Adjust margin between buttons if needed
							        },{
							            boxLabel: getCommonTranslation('NO'),
							            name: 'imageMarketingCheckbox',
							            inputValue: false,
							            checked: false
							        }]
		                    }],
					},{
						xtype: 'fieldcontainer',
						layout: 'hbox',
						defaults: {
							labelAlign: 'top',
							width: 270
						},
						items: [{
							xtype: 'multiselectcombofield',
							fieldLabel: getCommonTranslation('CONSENTED_COMMUNICATION_CHANNEL'),
							name: 'consentedCommunicationChannel',
							itemId: 'consentedCommunicationChannel',
							store: 'personinfo.common.personalinfo.CommunicationChannelStore',
							valueField: 'id',
							displayField: 'value',
							editable: false,
							allowBlank: true,
							disableKeyFilter: false,
							forceSelection:true,
							hidden: true,
							cls:'commonAutoHeightMultiselectField'
						}]
					}, {
						xtype: 'fieldcontainer',
						layout: 'hbox',
						defaults: {
							labelAlign: 'top',
							width: 226
						},
						items: [{
							xtype: 'checkboxfield',
							boxLabel: getCommonTranslation('CONSENT_STATEMENT_ACCEPTED'),
							name: 'consentStatementAccepted',
							itemId : 'consentStatementAccepted',
							labelAlign: 'left',
							region: 'south',
							hidden: true,
							inputValue: true,
							uncheckedValue: false,
							checked: false
						}]
					},{
						itemId : 'lblOneContactDetail',
			        	html: '<i>'+getAdmissionTranslation('ENTER_ANY_ONE_CONTACT_Details')+'</i>'+'<span class="required" style="color:red"> *</span>',
			        	margin: 0,
			        	allowBlank:false,
			        	width: 380
			        },{
						xtype: 'fieldcontainer',
						fieldLabel: getCommonTranslation('ADDRESS_PHONE_NUMBER_1'),		
						//allowBlank:false,
						itemId : 'phoneNoFldItemId',
						layout : {
							type : 'hbox'
						},
						defaults: {
			                enforceMaxLength: true,
			                labelAlign: "top",
			                width: 226
			            },
						items : [{
							xtype : 'customcombobox',
							hiddenName : 'phoneNumber1',
							valueField : 'isdCode',
							displayField : 'isdCode',
							store:Ext.create('Academia.store.common.CountryStore'),
							triggerAction : 'all',
							name : 'phoneCountryCode',
							itemId : 'phoneCountryCode',
							//editable : false,		
							forceSelection:true,
							width:100,
							minChars: 1
						}, {
							xtype : 'numberfield',
							name : 'phoneAreaCode',
							width: 108,
							//maxLength: 5,
							enforceMaxLength : true,
							// To Remove spinner buttons, and arrow key and mouse wheel listeners
							hideTrigger: true,
							keyNavEnabled: false,
							mouseWheelEnabled: false,
							allowExponential:false,
							itemId : 'phoneAreaCode',
						}, {
							xtype : 'numberfield',
							itemId : 'phoneNoField',
							name : 'phoneNo',
							//maxLength: 10,
							enforceMaxLength : true,
							// To Remove spinner buttons, and arrow key and mouse wheel listeners
							hideTrigger: true,
							width: 226,
							keyNavEnabled: false,
							mouseWheelEnabled: false,
							allowExponential:false
						} ]
					}, {
						xtype: 'fieldcontainer',
						itemId : 'mobileNoFldItemId',
						fieldLabel: getCommonTranslation('ADDRESS_MOBILE_NO'),
						layout : {
							type : 'hbox'
						},
						defaults: {
			                   enforceMaxLength: true,
			                   labelAlign: "top",
			                   width: 226
			               },
						items : [ {
							xtype : 'customcombobox',
							name : 'mobileCountryCode',
							itemId : 'cellCountryCode',
							valueField : 'isdCode',
							displayField : 'isdCode',
							store:Ext.create('Academia.store.common.CountryStore'),
							triggerAction : 'all',
							//editable : false,
							forceSelection:true,
							width:  100,
							minChars: 1
						}, {
							xtype : 'numberfield',
							name : 'mobileNumber',
							itemId : 'mobileNumber',
							minLength: 0,
							maxLength: 15,
							enforceMaxLength : true,
							// To Remove spinner buttons, and arrow key and mouse wheel listeners
							hideTrigger: true,
							keyNavEnabled: false,
							mouseWheelEnabled: false,
							allowExponential:false,
							width : 226
						}]
					},{
						xtype: 'fieldcontainer',
						itemId : 'alternateNoFldItemId',
						name: 'alternateNoFldItem',
						fieldLabel: getCommonTranslation('ALTERNATE_MOBILE_NO'),
						layout : {
							type : 'hbox'
						},
						defaults: {
			                   enforceMaxLength: true,
			                   labelAlign: "top",
			                   width: 226
			               },
						items : [ {
							xtype : 'customcombobox',
							name : 'alternateMobileCountryCode',
							itemId : 'alternateCellCountryCode',
							valueField : 'isdCode',
							displayField : 'isdCode',
							store:Ext.create('Academia.store.common.CountryStore'),
							triggerAction : 'all',
							//editable : false,
							forceSelection:true,
							width:  100,
							minChars: 1
						}, {
							xtype : 'numberfield',
							name : 'alternateMobileNo',
							itemId : 'alternateMobileNumber',
							minLength: 6,
							maxLength: 15,
							enforceMaxLength : true,
							// To Remove spinner buttons, and arrow key and mouse wheel listeners
							hideTrigger: true,
							keyNavEnabled: false,
							mouseWheelEnabled: false,
							allowExponential:false,
							width : 226
						}]
					},{
						xtype: 'fieldcontainer',
						labelAlign: 'top',
						layout: {
							type: 'hbox'
						},
						defaults: {
							labelAlign: 'top',
							width: 226
						},
						items: [ {
							xtype: 'textfield',
							fieldLabel: getAdmissionTranslation('EMAIL_ID'), //Email ID
							name: 'emailId',
							vtype: 'myemail',
							itemId: 'emailId',
							maxLength: '100',
							allowBlank: false
						},{
							xtype:'textfield',	
							fieldLabel:getCommonTranslation('ALTERNATE_EMAIL_ID'),
							name:'alternateEmailId',
							itemId : 'alternateEmailId',
							vtype: 'myemail',
							maxLength: '100'
							//allowBlank: false
					 }]
					}, {
						xtype: 'fieldcontainer',
						labelAlign: 'top',
						layout: {
							type: 'hbox'
						},
						defaults: {
							labelAlign: 'top',
							width: 226
						},
						items: [ {
							xtype: 'textfield',
							fieldLabel: getCommonTranslation('EMERGENCY_FIRST_NAME'),
							name: 'emergencyFirstName',
							itemId: 'emergencyFirstNameId',
							maxLength: '100',
							enforceMaxLength :true
						},{
							xtype:'textfield',	
							fieldLabel:getCommonTranslation('EMERGENCY_LAST_NAME'),
							name:'emergencyLastName',
							itemId : 'emergencyLastNameId',
							maxLength: '100',
							enforceMaxLength :true
					 }]
					}, {
						xtype: 'fieldcontainer',
						itemId : 'emergencyMobileNoFldItemId',
						fieldLabel: getCommonTranslation('EMERGENCY_CONTACT_NUMBER'),
						layout : {
							type : 'hbox'
						},
						defaults: {
			                   enforceMaxLength: true,
			                   labelAlign: "top",
			                   width: 226
			               },
						items : [ {
							xtype : 'customcombobox',
							name : 'emergencyMobileCountryCode',
							itemId : 'emergencyMobileCountryCode',
							valueField : 'isdCode',
							displayField : 'isdCode',
							store:Ext.create('Academia.store.common.CountryStore'),
							triggerAction : 'all',
							forceSelection:true,
							width:  100,
							minChars: 1
						}, {
							xtype : 'numberfield',
							name : 'emergencyMobileNumber',
							itemId : 'emergencyMobileNumberId',
							maxLength: 10,
							enforceMaxLength : true,
							hideTrigger: true,
							keyNavEnabled: false,
							mouseWheelEnabled: false,
							allowExponential:false,
							width : 226
						}]
					}]
		}
		if(this.personType === 'APPLICANT' || portalId==6){
			 obj.items.push({ 
				xtype: 'fieldcontainer',
				labelAlign: 'top',
				layout: {
					type: 'hbox'
				},
				defaults: {
					labelAlign: 'top',
					width: 226
				},
				items: [ { 
					xtype: 'textareafield',
					name: 'comments',
					itemId : 'commentsItemId',
					fieldLabel: getPersonModuleTranslation('COMMENTS'), //Approval Remarks
					labelAlign: 'top',
					width: 440,                
					maxLength: 3000
				}]
			})
			itemsArray.push(obj);
		}else
		{
			itemsArray.push(obj);
		}
		
		return itemsArray;
	},
	getPersonalDetailFormExtSysRefLastNameField: function(itemsArray) {

		itemsArray.push({
			xtype: 'fieldset',
			style:{'padding':'0px !important','margin-top':'-21px !important','margin-left': '10px','margin-bottom':'35px'},		
			items: [{
				xtype: 'fieldcontainer',
				width:'100%',
				layout: {
					type: 'hbox'
				},
				defaults :{
					width: 226,
					labelAlign:'top'
				},
				items: [{
					xtype:'textfield',
					fieldLabel:getCommonTranslation('EXTERNAL_SYSTEM_REFERENCE_1'),
					name:'externalSysRefOne',
					itemId : 'externalSysRefOne',
					maxLength : 50,
					hidden:true
				},{
					xtype:'textfield',
					fieldLabel:getCommonTranslation('EXTERNAL_SYSTEM_REFERENCE_2'),
					name:'externalSysRefTwo',
					itemId : 'externalSysRefTwo',
					maxLength : 50,
					hidden:true
				},{
					xtype:'textfield',
					fieldLabel:getCommonTranslation('EXTERNAL_SYSTEM_REFERENCE_3'),
					name:'externalSysRefThree',
					itemId : 'externalSysRefThree',
					hidden:true,
					maxLength : 50
				},{
					xtype:'textfield',
					fieldLabel:getCommonTranslation('STUDENT_PREVIOUS_LAST_NAME'),
					name:'previousLastName',
					itemId : 'previousLastName',
					hidden:true,
					maxLength : 100,
					enforceMaxLength :true
				}]
			}]});
		return itemsArray;
	},
	getPersonalDetailFormExtSysRefField: function(itemsArray) {

		itemsArray.push({
			xtype: 'fieldset',
			style:{'padding':'0px !important','margin-top':'-21px !important','margin-left': '10px','margin-bottom':'35px'},		
			items: [{
				xtype: 'fieldcontainer',
				width:'100%',
				layout: {
					type: 'hbox'
				},
				defaults :{
					width: 226,
					labelAlign:'top'
				},
				items: [{
					xtype:'textfield',
					fieldLabel:getCommonTranslation('EXTERNAL_SYSTEM_REFERENCE_1'),
					name:'externalSysRefOne',
					itemId : 'externalSysRefOne',
					maxLength : 50,
					hidden:true
				},{
					xtype:'textfield',
					fieldLabel:getCommonTranslation('EXTERNAL_SYSTEM_REFERENCE_2'),
					name:'externalSysRefTwo',
					itemId : 'externalSysRefTwo',
					maxLength : 50,
					hidden:true
				},{
					xtype:'textfield',
					fieldLabel:getCommonTranslation('EXTERNAL_SYSTEM_REFERENCE_3'),
					name:'externalSysRefThree',
					itemId : 'externalSysRefThree',
					hidden:true,
					maxLength : 50

				},{
					xtype:'textfield',
					fieldLabel:getCommonTranslation('STUDENT_PREVIOUS_LAST_NAME'),
					name:'previousLastName',
					itemId : 'previousLastName',
					hidden:true,
					maxLength : 100,
					enforceMaxLength :true
				}]
			}]});
		return itemsArray;
	},
	getOtherStudentDetailsFormField: function(itemsArray) {
		
		itemsArray.push({
			xtype: 'fieldset',
			name : 'otherDetailsStudentFieldSet',
			itemId : 'otherDetailsStudentFieldSet',
			collapsible : true,
			collapsed: true,
			title: getCommonTranslation('OTHER_DETAILS'),
			titleCollapse: true,
			defaults : {
				labelAlign:'top',
				//width: 226,
				tdAttrs: { style: 'padding: 5px;' }
			},
			/*styles: {
              	 marginleft: '10px'
             },*/
			items:[{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 226
				},
				items: [{
					xtype: 'textfield',
					fieldLabel: getPersonModuleTranslation('EXAMBOARDNUMBER'),
					itemId: 'boardNumberId',
					name: 'boardNumber',
					maxLength : 255,
					hidden:true
				},{
					xtype: 'customcombobox',
					fieldLabel: getCommonTranslation('BLOOD_GROUP'),
					name: 'bloodGroup',
					itemId:'bloodGroupId',
					store: Ext.create('Academia.store.enquiry.studentDetail.BloodGroupStore'),
					valueField: 'id',
					displayField: 'value',
					editable: false
				},{
					xtype: 'customcombobox',
					fieldLabel: getPersonModuleTranslation('MARITAL_STATUS'),
					store: Ext.create('Academia.store.common.MaritalStatusCSMStore'),
					valueField: 'id',
					displayField: 'value',
					name: 'maritalStatus',
					itemId:'maritalStatusId',
					editable: false
				},{
					xtype: 'customcombobox',
					fieldLabel: getCommonTranslation('DIET_PREFERENCE'),
					store: Ext.create('Academia.store.common.DietPreferenceStore'),
					valueField: 'id',
					displayField: 'value',
					name: 'dietPreference',
					itemId:'dietPreferenceId',
					editable: false,
					matchFieldWidth: true
				}]},{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 226
					},
					items: [{
						xtype: 'nestedJsonCombo',
						fieldLabel: getPersonModuleTranslation('RELIGION'),
						store: Ext.create('Academia.store.common.ReligionStore'),
						itemId: 'religionCombo',
						valueField: 'id',
						displayField: 'value',
						name: 'religion',
					//queryMode: 'local',
						editable: false
					}, {
						xtype: 'nestedJsonCombo',
						fieldLabel: getPersonModuleTranslation('CASTE_CATEGORY'),
						store: Ext.create('Academia.store.common.CastCategoryStore'),
						itemId: 'castCategoryCombo',
						valueField: 'id',
						displayField: 'value',
						name: 'castCategory',
						editable: false
					}, {
						xtype: 'textfield',
						fieldLabel: getPersonModuleTranslation('CATEGORY'),
						itemId: 'categoryId',
						name: 'category'
					}, {
						xtype: 'textfield',
						fieldLabel: getPersonModuleTranslation('POST_NUMBER'),
						name: 'postNumber',
						itemId: 'postNumberId'
					}]
				},{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 226
					},
					items: [{
						xtype: 'customcombobox',
						fieldLabel: getPersonModuleTranslation('ETHNICITY'),
						store: Ext.create('Academia.store.common.EthnicityResourceStore'),
						name: 'ethnicity',
						itemId: 'ethnicityItemId',
						displayField: 'value',
					    valueField: 'id',
					    editable: false,
						hidden: true,
					},{
						xtype: 'customcombobox',
						fieldLabel: getPersonModuleTranslation('GENDER_IDENTITY'),
						store: Ext.create('Academia.store.common.GenderIdentityStore'),
						name: 'genderIdentity',
						itemId: 'genderIdentityItemId',
						displayField: 'value',
					    valueField: 'id',
					    editable: false,
						hidden: true,
					},{
						xtype: 'customcombobox',
						fieldLabel: getPersonModuleTranslation('SEXUAL_ORIENTATION'),
						store: Ext.create('Academia.store.common.SexualOrientationStore'),
						name: 'sexualOrientation',
						itemId: 'sexualOrientationItemId',
						displayField: 'value',
					    valueField: 'id',
					    editable: false,
						hidden: true,
					}]
				}, {
					xtype: 'fieldcontainer',
					layout: 'hbox',
					style:{marginTop:'15px !important'},
					defaults: {
						labelAlign: 'top',
						width: 226,
						tdAttrs: { style: 'padding: 5px;' }
					},
					items: [{
						xtype: 'numberfield',
						fieldLabel: getPersonModuleTranslation('FAMILTY_INCOME'),
						name: 'personalIncome',
						maxLength: 10,
						minValue:0,
						itemId: 'personalIncomeId',
					},{
						xtype: 'textfield',
						fieldLabel: getPersonModuleTranslation('ACCOUNTING_KEY'),
						name: 'accountingKey',
						itemId: 'accountingKeyId',
						maxLength: 255
					},{
						xtype: 'datefield',
						fieldLabel: getPersonModuleTranslation('VALIDTILL_DATE'),
						name: 'validTill',
						itemId :'validTill',
						//--submitFormat: CONSTANTS.DATE_FORMAT,
						listeners: {
							render: function(field) {
								return dateFormatRender(field);
							}
						}
					},{
						xtype: 'textfield',
						fieldLabel: getPersonModuleTranslation('HPCSA_REG_NO'),
						name: 'hpcsaRegNo',
						itemId: 'hpcsaRegNoId'
					}]
				},{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 226
					},
					items: [{
						xtype: 'customcombobox',
						fieldLabel: getPersonModuleTranslation('TERM_TIME_ACCOMMODATION_TYPE'),
						store: Ext.create('Academia.store.common.TermTimeAccommodationTypeStore'),
						name: 'termTimeAccommodationType',
						itemId: 'termTimeAccommodationTypeItemId',
						displayField: 'value',
					    valueField: 'id',
					    editable: false,
						hidden: true,
					},{
						xtype: 'customcombobox',
						fieldLabel: getPersonModuleTranslation('CARE_LEAVER'),
						store: Ext.create('Academia.store.common.CareLeaverStore'),
						name: 'careLeaver',
						itemId: 'careLeaverItemId',
						displayField: 'value',
					    valueField: 'id',
					    editable: false,
						hidden: true,
					},{
						xtype: 'textfield',
					    fieldLabel: getPersonModuleTranslation('UCAS_SCHEME_CODE'),
					    name: 'ucasSchemeCode',
					    itemId: 'ucasSchemeCodeItemId',
					    maxLength: 4,
					    enforceMaxLength: true,
					    regex: /^[A-Za-z]{2}\d{2}$/,
					    regexText: 'Enter 2 letters followed by 2 numbers (e.g., AB12)',
					    vtype: 'alphanum',
					    hidden: true,	
					}]
				
				},{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					style:{marginTop:'15px !important'},
					defaults: {
						labelAlign: 'top',
						width: 226,
						tdAttrs: { style: 'padding: 5px;' }
					},
					items: [{
						xtype: 'customcombobox',
						fieldLabel: getPersonModuleTranslation('ARMS_OF_SERVICE'),
						store:'personinfo.common.personalinfo.ArmsOfServiceStore',
						valueField: 'id',
						displayField: 'value',
						name: 'armsOfService',
						itemId:'armsOfService',
						editable: false,
						disabled:false,
						 hidden:false,
		//				 queryMode: 'local'
						
					},{
						xtype: 'customcombobox',
						fieldLabel: getPersonModuleTranslation('MUSTERING'),
						store: 'personinfo.common.personalinfo.MusteringStore',
						valueField: 'id',
						displayField: 'value',
						name: 'mustering',
						itemId:'mustering',
						editable: false,
						disabled:true,
						 hidden:false
					},{
						xtype: 'customcombobox',
						fieldLabel: getCommonTranslation('RESIDENCE_TYPE'),
						store: Ext.create('Ext.data.Store', {
						     fields: ['id','value'],
						     data : [
						         {id: 'Senior',    value: getCommonTranslation('SENIOR')},
						         {id: 'Junior', value: getCommonTranslation('JUNIOR')}
						     ]
						 }),
						valueField: 'id',
						displayField: 'value',
						name: 'residenceType',
						itemId:'residenceType',
						editable: false,
						listeners:{
							render:function(cmp){
								if(portalId != '1'){
									cmp.setReadOnly(true);
									
								}
							}
						}
					},{
						xtype: 'numberfield',
						name: 'numberOfCheckIn',
						itemId:'numberOfCheckIn',
						fieldLabel: getCommonTranslation('NUMBER_OF_CHECK'),
						maxLength: 2,
						minValue: 0,
						listeners:{
							render:function(cmp){
								if(portalId != '1'){
									cmp.setReadOnly(true);
									
								}
							}
						}
					}]
				},{
					xtype:'fieldcontainer',
					itemId:'serviceStopPanelId',
				    items:[{
					xtype : 'fieldcontainer',
					width: '100%',
				    itemId:'serviceStopContainer',
					layout : 'hbox',
					defaults: {
						labelAlign: 'top'
					},
					items : [{
						xtype: 'hidden',
						itemId:'langItemId',
						name: 'langId'
				         },{
						xtype : 'customcombobox',
						name : 'employeeLanguage',	
						itemId:'employeeLanguage',
						fieldLabel:getCommonTranslation('LANGUAGE'),
						store:Ext.create('Academia.store.common.EmployeeLanguageStore'),
						valueField: 'id',
						displayField: 'value',
						width: 226,
						editable: false,
			            disableKeyFilter: false,
						forceSelection:true
					},{
						xtype : 'customcombobox',
						name : 'read',	
						itemId:'readItemId',
						width: 226,
						fieldLabel:getCommonTranslation('READ'),
						store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
						valueField: 'id',
						displayField: 'value',
						editable:false,
						autoloadStore: false
					},{
						xtype : 'customcombobox',
						name : 'write',	
						itemId : 'writeItemId',
						store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
						fieldLabel:getCommonTranslation('WRITE'),
						valueField: 'id',
						displayField: 'value',
						editable:false,
						width: 226,
						autoloadStore: false
					},{
						xtype : 'customcombobox',
						name : 'speak',
						itemId : 'speakItemId',
						store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
						fieldLabel:getCommonTranslation('SPEAK'),
						valueField: 'id',
						displayField: 'value',
						editable:false,
						width: 191,
						autoloadStore: false
					},{
						xtype: 'button',
						itemId: 'stopBtn',
						name:'stopBtn',
						cls: 'CustomBodyBtnSettings',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),
						style:{
							marginTop:'30px'
						}
					}]
				}]
			},
			{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 226
				},
				items: [{
					xtype : 'radiogroup',
					fieldLabel: getEnquiryTranslation('UWC_BEFORE'),
					height : 70,
					itemId:'applicantPersonRadioBtnUwcBefore',
					defaults: {
						flex: 1
					},
					layout: 'hbox',
					name: 'uwcBefore',
					items:[{ 
						boxLabel: getCommonTranslation('YES'), 
						name: 'haveYouStudiedAtUWC', 
						inputValue: true},
						{
							boxLabel: getCommonTranslation('NO'),
							name: 'haveYouStudiedAtUWC',
							inputValue: false,checked:true
						}]
				},{
					xtype: 'textfield',
					itemId:'uwcBefore',
					name: 'studentNoAtUWC',
					fieldLabel:getEnquiryTranslation('STUDENT_ID_NUMBER'),
					hidden:true,
					maxLength:100,
					enforceMaxLength : true					
				}]
			},{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 226
				},
				items: [{
					xtype : 'radiogroup',
					fieldLabel: getEnquiryTranslation('REGISTERED_SA_UNIVERSITY_BEFORE'),
					height : 90,
					itemId:'applicantPersonRadioBtnRegisteredBeforeSA',
					defaults: {
						flex: 1
					},
					layout: 'hbox',
					name: 'registeredBeforeSA',
					items:[{
						boxLabel: getCommonTranslation('YES'),
						name: 'areYouRegisteredAtOtherSAU', 
						inputValue: true
					},
					{
						boxLabel: getCommonTranslation('NO'),
						name: 'areYouRegisteredAtOtherSAU', 
						inputValue: false,
						checked:true
					}]
				},{
            			xtype: 'customcombobox',
            			fieldLabel: getCommonTranslation('ALL_INTAKE_YEAR'),  
            			name: 'allIntakeYear',
            			itemId: 'allIntakeYearItemId',
            			editable: true,
            			autoload: false,
            			typeAhead:false,
            			valueField: 'id',
            			displayField: 'value',
            			queryMode : 'remote',
            			minChars:3,
            			hidden: true,
            			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            		    forceSelection:true,
            		       listConfig: {
            					listeners: {
            						beforeshow: function(picker) {
            							picker.minWidth = picker.up('combobox').getSize().width;
            						}
            					},
            					loadingText: getCommonTranslation('SEARCHING'),
            					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
            					getInnerTpl: function() {
            						return '<div class="search-item">' +
            						'{code} / {value}'+ 
            						'</div>';
            					}
            			},
            			listeners: {
                            render: function(combo) {
                                var store = Ext.create('Academia.store.admission.applications.pandadoc.PandaDiscountAppliedStore');
                                combo.bindStore(store);
                            }
                        }
                    },{
                    	xtype: 'textfield',
    					itemId:'registeredBeforeSA',
    					name: 'studentNoAtOtherSAU',
    					hidden: true,
    					allowBlank: true,
    					fieldLabel:getEnquiryTranslation('STUDENT_ID_NUMBER'),
    					maxLength:255,
						disabled: true,
    					enforceMaxLength : true
                    },{
					xtype : 'radiogroup',
					fieldLabel: getEnquiryTranslation('POPIA_ACT: Is Student Above 18'),
					height : 70,
					itemId:'applicantPersonRadioBtnPopiaAct',
					defaults: {
						flex: 1
					},
					layout: 'hbox',
					name: 'isAdult',
					items:[{ 
						boxLabel: getCommonTranslation('YES'), 
						name: 'isAdult', 
						inputValue: true},
						{
							boxLabel: getCommonTranslation('NO'),
							name: 'isAdult',
							inputValue: false,
							checked:false
						}]
				}]
			}]
		});
		return itemsArray;
	},
	getOtherApplicantDetailsFormField: function(itemsArray) {
		
		itemsArray.push({
			xtype: 'fieldset',
			itemId : 'otherDetailsApplicantFieldSet',
			collapsible : true,
			collapsed: true,
			title: getCommonTranslation('OTHER_DETAILS'),
			titleCollapse: true,
			defaults : {
				labelAlign:'top',
				//width: 226,
				tdAttrs: { style: 'padding: 5px;' }
			},
			listeners: {
			    expand: function(fieldset) {
			        Ext.defer(function() {
			            var formPanel = fieldset.up('form');
			            if (formPanel) {
			                formPanel.doLayout();
			            }
			            // Optionally also trigger layout on the field directly
			            var combo = fieldset.down('#applicantModeOfEnquiryItemId');
			            if (combo) {
			                combo.doComponentLayout();
			            }
			        }, 100);
			    }
			},
			items:[{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 226
				},
				items: [{
					xtype: 'customcombobox',
					fieldLabel: getCommonTranslation('BLOOD_GROUP'),
					name: 'bloodGroup',
					itemId:'bloodGroupId',
					store: 'enquiry.studentDetail.BloodGroupStore',
					valueField: 'id',
					displayField: 'value',
		//			queryMode: 'local',
					editable: false
				},{
					xtype: 'customcombobox',
					fieldLabel: getPersonModuleTranslation('MARITAL_STATUS'),
					store: 'Academia.store.common.MaritalStatusCSMStore',
					valueField: 'id',
					displayField: 'value',
					name: 'maritalStatus',
					itemId:'maritalStatusId',
					editable: false
				},{
					xtype: 'customcombobox',
					fieldLabel: getCommonTranslation('DIET_PREFERENCE'),
					store: Ext.create('Academia.store.common.DietPreferenceStore'),
					valueField: 'id',
					displayField: 'value',
					name: 'dietPreference',
					itemId:'dietPreferenceId',
					editable: false,
					matchFieldWidth: true
				},{
					xtype: 'nestedJsonCombo',
					fieldLabel: getPersonModuleTranslation('RELIGION'),
					store: 'common.ReligionStore',
					itemId: 'religionCombo',
					valueField: 'id',
					displayField: 'value',
					name: 'religion',
					//queryMode: 'local',
					editable: false
				}]},{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 226
					},
					items: [{
					    xtype: 'nestedJsonCombo',
					    fieldLabel: getPersonModuleTranslation('CASTE_CATEGORY'),
					    store: 'common.CastCategoryStore',
					    itemId: 'castCategoryCombo',
					    valueField: 'id',
					    displayField: 'value',
					    name: 'castCategory',
					    editable: false
				    },{
						xtype: 'textfield',
						fieldLabel: getPersonModuleTranslation('CATEGORY'),
						itemId: 'categoryId',
						name: 'category'
					},{
						xtype: 'textfield',
						fieldLabel: getPersonModuleTranslation('POST_NUMBER'),
						name: 'postNumber',
						itemId: 'postNumberId'
					},{
						xtype: 'numberfield',
						fieldLabel: getPersonModuleTranslation('FAMILTY_INCOME'),
						name: 'personalIncome',
						maxLength: 10,
						minValue:0,
						itemId: 'personalIncomeId',
					}]
				},{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					style:{
						marginTop:'10px !important'},
						defaults: {
							labelAlign: 'top',
							width: 226,
							tdAttrs: { style: 'padding: 5px;' }
						},
						items: [{
							xtype: 'textfield',
							fieldLabel: getPersonModuleTranslation('ACCOUNTING_KEY'),
							name: 'accountingKey',
							itemId: 'accountingKeyId',
							maxLength: 255
						},{
							xtype: 'datefield',
							fieldLabel: getPersonModuleTranslation('VALIDTILL_DATE'),
							name: 'validTill',
							itemId :'validTill',
							//--submitFormat: CONSTANTS.DATE_FORMAT,
							listeners: {
								render: function(field) {
									return dateFormatRender(field);
								}
							}
						},{
							xtype: 'textfield',
							fieldLabel: getPersonModuleTranslation('HPCSA_REG_NO'),
							name: 'hpcsaRegNo',
							itemId: 'hpcsaRegNoId'
						},{
							xtype: 'multiselectcombofield',
							name: 'applicantModeOfEnquiry',
							itemId:'applicantModeOfEnquiryItemId',
							fieldLabel: getEnquiryTranslation('MODE_OF_ENQUIRY'),
							store:'enquiry.EnquiryModeStore',
							valueField: 'id',
							forceSelection:true,
							displayField: 'value'
					    }]
				},{
					 xtype:'fieldcontainer',
					 layout:'hbox',
					 width:'100%',
					 defaults: {
						 width: 226,
						 labelAlign: 'top'
					 },
					 items:[{
							xtype: 'customcombobox',
							name: 'applicationOwner',
							itemId:'applicationOwner',
							store: Ext.create('Academia.store.enquiry.FollowUpUserWithDepartment'),
							fieldLabel: getCommonTranslation('APPLICATION_OWNER'),
							valueField: 'id',
							displayField: 'value',
							queryParam:'name',
							editable: true,
							minChars:3,
							typeAhead:false,
							hideTrigger:false,
							forceSelection:true,
							emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
							listConfig: {
								listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
									}
								},
								loadingText: getCommonTranslation('SEARCHING'),
								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
								getInnerTpl: function() {
									return '<div class="search-item">' +
									'{code}'  +
									'</div>';
								}
							}
					  },{
						 xtype: 'customcombobox',
						 name: 'enquirySource',
						 itemId:'enquirySource',
						 minChars:3,
						 fieldLabel: getEnquiryTranslation('SOURCE'),
						 store:  Ext.create('Academia.store.enquiry.EnquirySourceStore'),
						 valueField: 'id',
						 displayField: 'value',
						 typeAhead:true,
						 forceSelection:true,
						 hidden:false,
						 editable: false
					 }, {
						 xtype      : 'radiogroup',
						 fieldLabel : getCommonTranslation('COMPANY_SPONSORED'),
						 itemId: 'isCompanySponsored',
						 name: 'isCompanySponsored',
						 defaults: {
							 flex: 1
						 },
						 layout: 'hbox',
						 minHeight:70,
						 items:[{ 
							 boxLabel: getCommonTranslation('YES'), 
							 name: 'whetherCompanySponsored', 
							 inputValue: true
						 },{ 
							 boxLabel: getCommonTranslation('NO'), 
							 name: 'whetherCompanySponsored', 
							 inputValue: false,
							 checked:true
						 }]
					 }, {
							xtype: 'customcombobox',
							name: 'campaignNew',
							itemId: 'applicantCampaign',
							fieldLabel: getCommonTranslation("BRAND_CAMPAIGN_NAME"),
							store: 'campaignnew.CampaignNameFilterStore',
							queryParam:'campaignName',
							valueField: 'id',
							displayField: 'value',
							width : 226,
							maxLength: 226,
							forceSelection :true,
							minChars: 3,
							emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
							listConfig: {
								listeners: {
									beforeshow: function(picker) {
										picker.minWidth = picker.up('combobox').getSize().width;
										picker.width = picker.up('combobox').getSize().width;
									}
								},
								loadingText: getCommonTranslation('SEARCHING'),
								emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
								getInnerTpl: function() {
									return '<div class="search-item">' +
									'{value}' +
									'</div>';
								}
							}
					   }]
				  },{
						 xtype:'fieldcontainer',
						 layout:'hbox',
						 width:'100%',
						 defaults: {
							 width: 226,
							 labelAlign: 'top'
						 },
						 items:[{
								xtype: 'textfield',
								name: 'applicantCampaignType',
								itemId:'applicantCampaignType',
								fieldLabel: getCommonTranslation('CAMPAIGN_TYPE'),
								readOnly: true
							}, {
								xtype: 'textfield',
								name: 'applicantPresentationType',
								itemId:'applicantPresentationType',
								fieldLabel: getCommonTranslation('PRESENTATION_TYPE'),
								readOnly: true
							},{
								 xtype: 'customcombobox',
								 name: 'campaignSchool',
								 itemId: 'applicantCampaignSchool',
								 fieldLabel: getCommonTranslation("SCHOOL"),
								 valueField: 'schoolId',
								 displayField: 'schoolName',
								 store: Ext.create('Academia.store.campaignnew.CampaignSchoolNameStore'),
								 queryParam:'schoolName',
								 minChars:3,
								 allowBlank:true,
								 forceSelection:true,
								 emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
								 listConfig: {
										listeners: {
											beforeshow: function(picker) {
												picker.minWidth = picker.up('combobox').getSize().width;
												picker.width = picker.up('combobox').getSize().width;
											}
										},
								 loadingText: getCommonTranslation('SEARCHING'),
										emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
										getInnerTpl: function() {
											return '<div class="search-item">' +
											'{value}' +
											'</div>';
										}
									}
							 }, {
								 xtype: 'customcombobox',
								 name: 'schoolPriorityNew',
								 itemId:'schoolPriorityNew',
								 fieldLabel: getCommonTranslation('SCHOOL_PRIORITY'),
								 store: Ext.create('Academia.store.campaignnew.AllSchoolPriorityStore'),
								 valueField: 'id',
								 displayField: 'value',
								 typeAhead:true,
								 forceSelection:true,
								 allowBlank:true,
								 editable: false,
								 disabled:true,
								 hidden:true
							 }
						 ]},{
							 xtype:'fieldcontainer',
							 layout:'hbox',
							 width:'100%',
							 defaults: {
								 width: 226,
								 labelAlign: 'top'
							 },
							 items:[{
								 xtype: 'textfield',
								 name: 'applicantSchoolPriority',
								 itemId:'applicantSchoolPriority',
								 fieldLabel: getCommonTranslation('BRAND_CAMP_SCHOOL_PRIORITY'),
								 readOnly: true
							 },{
									xtype: 'customcombobox',
									fieldLabel: getPersonModuleTranslation('ARMS_OF_SERVICE'),
									store:'personinfo.common.personalinfo.ArmsOfServiceStore',
									valueField: 'id',
									displayField: 'value',
									name: 'armsOfService',
									itemId:'armsOfService',
									editable: false,
									disabled:false,
									 hidden:false,
									// queryMode: 'local'
							 },{
									xtype: 'customcombobox',
									fieldLabel: getPersonModuleTranslation('MUSTERING'),
									store: 'personinfo.common.personalinfo.MusteringStore',
									valueField: 'id',
									displayField: 'value',
									name: 'mustering',
									itemId:'mustering',
									editable: false,
									disabled:true,
									 hidden:false
							 }]
					  },{
							xtype:'fieldcontainer',
							itemId:'serviceStopPanelId',
						     items:[{
							xtype : 'fieldcontainer',
							width: '100%',
						    itemId:'serviceStopContainer',
							layout : 'hbox',
							defaults: {
								labelAlign: 'top'
							},
							items : [{
								xtype: 'hidden',
								itemId:'langItemId',
								name: 'langId'
						         },{
								xtype : 'customcombobox',
								name : 'employeeLanguage',	
								itemId:'employeeLanguage',
								fieldLabel:getCommonTranslation('LANGUAGE'),
								store:Ext.create('Academia.store.common.EmployeeLanguageStore'),
								valueField: 'id',
								displayField: 'value',
								width: 226,
								editable: false,
					            disableKeyFilter: false,
								forceSelection:true
							},{
								xtype : 'customcombobox',
								name : 'read',	
								itemId:'readItemId',
								width: 226,
								fieldLabel:getCommonTranslation('READ'),
								store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
								valueField: 'id',
								displayField: 'value',
								editable:false,
								autoloadStore: false
							},{
								xtype : 'customcombobox',
								name : 'write',	
								itemId : 'writeItemId',
								store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
								fieldLabel:getCommonTranslation('WRITE'),
								valueField: 'id',
								displayField: 'value',
								editable:false,
								width: 226,
								autoloadStore: false
							},{
								xtype : 'customcombobox',
								name : 'speak',
								itemId : 'speakItemId',
								store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
								fieldLabel:getCommonTranslation('SPEAK'),
								valueField: 'id',
								displayField: 'value',
								editable:false,
								width: 191,
								autoloadStore: false
							},{
								xtype: 'button',
								itemId: 'stopBtn',
								name:'stopBtn',
								cls: 'CustomBodyBtnSettings',
								text: getCommonTranslation('ADDBUTTONTEXT'),
								tooltip: getCommonTranslation('ADD'),
								style:{
									marginTop:'30px'
								}
							}]
						}]
					},
					{
						xtype: 'fieldcontainer',
						layout: 'hbox',
						defaults: {
							labelAlign: 'top',
							width: 226
						},
						items: [{
							xtype : 'radiogroup',
							fieldLabel: getEnquiryTranslation('UWC_BEFORE'),
							height : 70,
							itemId:'applicantPersonRadioBtnUwcBefore',
							defaults: {
								flex: 1
							},
							layout: 'hbox',
							name: 'uwcBefore',
							items:[{ 
								boxLabel: getCommonTranslation('YES'), 
								name: 'haveYouStudiedAtUWC', 
								inputValue: true},
								{
									boxLabel: getCommonTranslation('NO'),
									name: 'haveYouStudiedAtUWC',
									inputValue: false,checked:true
								}]
						},{
							xtype: 'textfield',
							itemId:'uwcBefore',
							name: 'studentNoAtUWC',
							fieldLabel:getEnquiryTranslation('STUDENT_ID_NUMBER'),
							hidden:true,
							maxLength:100,
							enforceMaxLength : true					
						}]
					},{
						xtype: 'fieldcontainer',
						layout: 'hbox',
						defaults: {
							labelAlign: 'top',
							width: 226
						},
						items: [{
							xtype : 'radiogroup',
							fieldLabel: getEnquiryTranslation('REGISTERED_SA_UNIVERSITY_BEFORE'),
							height : 90,
							itemId:'applicantPersonRadioBtnRegisteredBeforeSA',
							defaults: {
								flex: 1
							},
							layout: 'hbox',
							name: 'registeredBeforeSA',
							items:[{
								boxLabel: getCommonTranslation('YES'),
								name: 'areYouRegisteredAtOtherSAU', 
								inputValue: true
							},
							{
								boxLabel: getCommonTranslation('NO'),
								name: 'areYouRegisteredAtOtherSAU', 
								inputValue: false,
								checked:true
							}]
						},{
		            			xtype: 'customcombobox',
		            			fieldLabel: getCommonTranslation('ALL_INTAKE_YEAR'),  
		            			name: 'allIntakeYear',
		            			itemId: 'allIntakeYearItemId',
		            			editable: true,
		            			autoload: false,
		            			typeAhead:false,
		            			valueField: 'id',
		            			displayField: 'value',
		            			queryMode : 'remote',
		            			minChars:3,
		            			hidden: true,
		            			emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		            		    forceSelection:true,
		            		       listConfig: {
		            					listeners: {
		            						beforeshow: function(picker) {
		            							picker.minWidth = picker.up('combobox').getSize().width;
		            						}
		            					},
		            					loadingText: getCommonTranslation('SEARCHING'),
		            					emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
		            					getInnerTpl: function() {
		            						return '<div class="search-item">' +
		            						'{code} / {value}'+ 
		            						'</div>';
		            					}
		            			},
		            			listeners: {
		                            render: function(combo) {
		                                var store = Ext.create('Academia.store.admission.applications.pandadoc.PandaDiscountAppliedStore');
		                                combo.bindStore(store);
		                            }
		                        }
		                    },{
		                    	xtype: 'textfield',
		    					itemId:'registeredBeforeSA',
		    					name: 'studentNoAtOtherSAU',
		    					hidden: true,
		    					fieldLabel:getEnquiryTranslation('STUDENT_ID_NUMBER'),
		    					maxLength:255,
		    					enforceMaxLength : true
		                    },{
							xtype : 'radiogroup',
							fieldLabel: getEnquiryTranslation('POPIA_ACT: Is Student Above 18'),
							height : 70,
							name:'applicantPersonRadioBtnPopiaAct',
							itemId:'applicantPersonRadioBtnPopiaAct',
							defaults: {
								flex: 1
							},
							layout: 'hbox',
							name: 'isAdult',
							items:[{ 
								boxLabel: getCommonTranslation('YES'), 
								name: 'isAdult', 
								inputValue: true},
								{
									boxLabel: getCommonTranslation('NO'),
									name: 'isAdult',
									inputValue: false,
									checked:false
								}]
						}]
					}]
		
		});
		return itemsArray;
	},

	getOtherFacultyDetailsFormField: function(itemsArray) {

		itemsArray.push({
			xtype: 'fieldset',
			name : 'otherDetailsFacultyFieldSet',
			itemId : 'otherDetailsFacultyFieldSet',
			collapsible : true,
			collapsed: false,
			title: getCommonTranslation('OTHER_DETAILS'),
			titleCollapse: true,
			defaults : {
				labelAlign:'top',
				//width: 226,
				tdAttrs: { style: 'padding: 5px;' }
			},
			/*styles: {
                  	 marginleft: '10px'
                 },*/
			items:[{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 226
				},
				items: [{
					xtype: 'nestedJsonCombo',
					fieldLabel: getPersonModuleTranslation('SUB_DEPARTMENT'),

					store: 'department.SubDepartmentComboStore',
					itemId : 'subDepartmentCombo',
					valueField: 'id',
					displayField: 'name',       
					name : 'subDepartment',
					editable: false,
			//		queryMode: 'local',
					triggerAcation: 'all',
					fourceSelection: true
				},{
					xtype: 'customcombobox',
					fieldLabel: getCommonTranslation('BLOOD_GROUP'),
					name: 'bloodGroup',
					store: 'enquiry.studentDetail.BloodGroupStore',
					valueField: 'id',
					displayField: 'value',
			//		queryMode: 'local',
					editable: false
				},{
					xtype: 'customcombobox',
					fieldLabel: getPersonModuleTranslation('MARITAL_STATUS'),
					store: 'common.MaritalStatusStore',
					valueField: 'id',
					displayField: 'value',
					name: 'maritalStatus',
					editable: false
				},{
					xtype: 'nestedJsonCombo',
					fieldLabel: getPersonModuleTranslation('RELIGION'),
					store: 'common.ReligionStore',
					itemId: 'religionCombo',
					valueField: 'id',
					displayField: 'value',
					name: 'religion',
			//		queryMode: 'local',
					editable: false
				}]},{
					xtype: 'fieldcontainer',
					layout: 'hbox',
					defaults: {
						labelAlign: 'top',
						width: 226
					},
					items: [{
						xtype: 'nestedJsonCombo',
						fieldLabel: getPersonModuleTranslation('CASTE_CATEGORY'),
						store: 'common.CastCategoryStore',
						itemId: 'castCategoryCombo',
						valueField: 'id',
						displayField: 'value',
						name: 'castCategory',
						editable: false
					}, {
						xtype: 'textfield',
						fieldLabel: getPersonModuleTranslation('CATEGORY'),
						name: 'category'
					},{
						xtype: 'datefield',
						fieldLabel: getPersonModuleTranslation('DATE_OF_EXIT'),
						name: 'exitDate',
						itemId : 'endDate',
						vtype: 'daterange',
						startDateField: 'startDate',
						//--submitFormat : CONSTANTS.DATE_FORMAT,
						listeners: {
							render: function(field) {
								return dateFormatRender(field);
							}
						}
					},{
						xtype: 'textfield',
						fieldLabel: getPersonModuleTranslation('ACCOUNTING_KEY'),
						name: 'accountingKey',
						maxLength: 255
					}]
				},{
					xtype:'fieldcontainer',
					itemId:'serviceStopPanelId',
				     items:[{
					xtype : 'fieldcontainer',
					width: '100%',
				    itemId:'serviceStopContainer',
					layout : 'hbox',
					defaults: {
						labelAlign: 'top'
					},
					items : [{
						xtype: 'hidden',
						itemId:'langItemId',
						name: 'langId'
				         },{
						xtype : 'customcombobox',
						name : 'employeeLanguage',	
						itemId:'employeeLanguage',
						fieldLabel:getCommonTranslation('LANGUAGE'),
						store:Ext.create('Academia.store.common.EmployeeLanguageStore'),
						valueField: 'id',
						displayField: 'value',
						width: 226,
						editable: false,
			            disableKeyFilter: false,
						forceSelection:true
					},{
						xtype : 'customcombobox',
						name : 'read',	
						itemId:'readItemId',
						width: 226,
						fieldLabel:getCommonTranslation('READ'),
						store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
						valueField: 'id',
						displayField: 'value',
						editable:false
					},{
						xtype : 'customcombobox',
						name : 'write',	
						itemId : 'writeItemId',
						store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
						fieldLabel:getCommonTranslation('WRITE'),
						valueField: 'id',
						displayField: 'value',
						editable:false,
						width: 226,
					},{
						xtype : 'customcombobox',
						name : 'speak',
						itemId : 'speakItemId',
						store:Ext.create('Academia.store.common.EmployeeLanguageCountStore'),
						fieldLabel:getCommonTranslation('SPEAK'),
						valueField: 'id',
						displayField: 'value',
						editable:false,
						width: 191,
					},{
						xtype: 'button',
						itemId: 'stopBtn',
						cls: 'CustomBodyBtnSettings',
						text: getCommonTranslation('ADDBUTTONTEXT'),
						tooltip: getCommonTranslation('ADD'),
						style:{
							marginTop:'30px'
						}
					}]
					}]
			}]

		});

		return itemsArray;
	},

	/*getPhysicalCharacteristicsFormField: function(itemsArray) {

		itemsArray.push({
			xtype: 'fieldset',
			collapsed: true,
			collapsible : true,
			title: getPersonModuleTranslation('PHYSICAL_CHARACTERISTICS'),
			titleCollapse: true,
			items: [{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 226,
					minValue: 0,
					tdAttrs: { style: 'padding: 5px;' }
				},
				items: [{
					xtype: 'numberfield',
					fieldLabel: getPersonModuleTranslation('HEIGHT'),
					name: 'height',
					maxLength: 5,
					minLength: 2,
					enforceMaxLength: true
					//allowBlank: false
				}, {
					xtype: 'numberfield',
					fieldLabel: getPersonModuleTranslation('WEIGHT'),
					name: 'weight',
					maxLength: 5,
					minLength: 2,
					enforceMaxLength: true
					//allowBlank: false
				},{
					xtype: 'customcombobox',
					fieldLabel: getPersonModuleTranslation('EYE_COLOR'),
					name: 'eyeColor',
					store: 'common.ColorStore',
					valueField: 'id',
					displayField: 'value',
					queryMode: 'local',
					editable: false
				}]
			}, {
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 226
				},
				items: [{
					xtype: 'customcombobox',
					fieldLabel: getPersonModuleTranslation('HAIR_COLOR'),
					name: 'hairColor',
					store: 'common.ColorStore',
					valueField: 'id',
					displayField: 'value',
					queryMode: 'local',
					editable: false
				}]
			}]
		});
		return itemsArray;
	},*/

	getBankDetailFormField: function(itemsArray) {

		itemsArray.push({
			xtype: 'fieldset',
			collapsed: true,
			collapsible : true,
			title: getPersonModuleTranslation('BANK_DETAILS'),
			titleCollapse: true,
			name : 'bankDetailsFieldSet',
			itemId : 'bankDetailsFieldSet',
			items: [{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 226,
					tdAttrs: { style: 'padding: 5px;' }
				},
				items: [{
					xtype: 'textfield',
					fieldLabel: getPersonModuleTranslation('BENEFICIARY_NAME'),
					name: 'beneficiaryName',
					maxLength: 50,
					itemId:'beneficiaryName'
				}, {
					xtype: 'textfield',
					fieldLabel: getPersonModuleTranslation('ACCOUNT_NUMBER'),
					maxLength : 50,
					enforceMaxLength : true,
					name: 'accountNumber',
					itemId: 'accountNumber'
				}, {
					xtype: 'customcombobox',
					fieldLabel: getPersonModuleTranslation('ACCOUNT_TYPE'),
					name: 'accountTypeId',
					valueField: 'id',
					displayField: 'value',
					store: 'user.AccountTypeStore',
					editable: false,
					itemId: 'accountTypeId',
				}]
			}, {
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 226
				},
				items: [{
					xtype: 'textfield',
					fieldLabel: getPersonModuleTranslation('BANK_NAME'),
					name: 'bankName',
					maxLength : 30,
					itemId: 'bankName',
				},{
					xtype: 'textfield',
					fieldLabel: getPersonModuleTranslation('BRANCH_NAME'),
					name: 'branchName',
					maxLength: 100,
					itemId: 'branchName',
				},{
					xtype: 'textfield',
					fieldLabel: getPersonModuleTranslation('IFSC_CODE'),
					itemId: 'ifsCode',
					name: 'ifsCode',
					maxLength : 11,
					minLength : 6,
					enforceMaxLength : true
					//allowBlank: false
				}]
			}]
		});
		return itemsArray;
	},
	
	getBankDetailStudentApplicationFormField: function(itemsArray) {

		itemsArray.push({
			xtype: 'fieldset',
			collapsed: true,
			collapsible : true,
			title: getPersonModuleTranslation('BANK_DETAILS'),
			titleCollapse: true,
			name : 'bankDetailsStudentApplicationFieldSetId',
			itemId : 'bankDetailsStudentApplicationFieldSetId',
			items: [{
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 226,
					tdAttrs: { style: 'padding: 5px;' }
				},
				items: [{
					xtype: 'textfield',
					fieldLabel: getPersonModuleTranslation('BENEFICIARY_NAME'),
					name: 'beneficiaryName',
					maxLength : 50,
					itemId:'beneficiaryName'
				},{
					xtype: 'textfield',
					fieldLabel: getPersonModuleTranslation('BENEFICIARY_NAME_OTHER_LANGUAGE'),
					name: 'beneficiaryNameOtherLanguage',
					maxLength : 50,
					itemId:'beneficiaryNameOtherLanguageId'
				}, {
					xtype: 'textfield',
					fieldLabel: getPersonModuleTranslation('ACCOUNT_NUMBER'),
					maxLength : 50,
					enforceMaxLength : true,
					name: 'accountNumber',
					itemId: 'accountNumber'
				}, {
					xtype: 'customcombobox',
					fieldLabel: getPersonModuleTranslation('ACCOUNT_TYPE'),
					name: 'accountTypeId',
					valueField: 'id',
					displayField: 'value',
					store: 'user.AccountTypeStore',
					editable: false,
					itemId: 'accountTypeId',
				}]
			}, {
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 226
				},
				hidden: true,
				itemId: 'textFieldContainerStudentApplicant',
				items: [{
					xtype: 'textfield',
					fieldLabel: getPersonModuleTranslation('BANK_NAME'),
					name: 'bankName',
					maxLength : 30,
					itemId: 'bankName'
				},{
					xtype: 'textfield',
					fieldLabel: getPersonModuleTranslation('BRANCH_NAME'),
					name: 'branchName',
					itemId: 'branchName',
					maxLength : 100
				},{
					xtype: 'textfield',
					fieldLabel: getPersonModuleTranslation('IFSC_CODE'),
					itemId: 'ifsCode',
					name: 'ifsCode',
					maxLength : 11,
					minLength : 6,
					enforceMaxLength : true
					//allowBlank: false
				}]
			}, {
				xtype: 'fieldcontainer',
				layout: 'hbox',
				defaults: {
					labelAlign: 'top',
					width: 226
				},
				hidden: true,
				itemId: 'comboFieldContainerStudentApplicant',
				items: [{
					xtype : 'nestedJsonCombo',
	        		fieldLabel : getPersonModuleTranslation('BANK_NAME'),
	        		itemId : 'bankNameValue',
	        		emptyText :  getPersonModuleTranslation('BANK_NAME'),
	        	    store: 'feeandpayment.receipts.BankNameStore',
	        		valueField : 'value',
	        		displayField : 'value',
	        		triggerAction : 'all',
	        		name : 'bankNameValue',
	        		valueNotFoundText:"",        		        						
					forceSelection :true,
				    queryParam:'bankName',
		    		minChars:3,
		    		allowBlank: true,
		    		typeAhead:false,
	                editable:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				},{
					xtype : 'nestedJsonCombo',
	        		overrideSetValue:false,
	        		fieldLabel : getPersonModuleTranslation('BRANCH_NAME'),
	        		itemId : 'branchNameValue',
	        		emptyText : getPersonModuleTranslation('BRANCH_NAME'),
	        		store:Ext.create('Academia.store.feeandpayment.receipts.BranchByBankNameStore'),
	        		valueField : 'value',
	        		displayField : 'value',
	        		name : 'branchNameValue',
	        		triggerAction : 'all',
					disabled:true,
	        		valueNotFoundText:"",        		        						
					forceSelection :true,
				    queryParam:'branchName',
		    		minChars:3,
		    		allowBlank: true,
		    		typeAhead:false,
	                editable:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				},{
					xtype : 'nestedJsonCombo',
	        		overrideSetValue:false,
	        		fieldLabel : getPersonModuleTranslation('IFSC_CODE'),
	        		itemId : 'ifscCodeValue',
	        		emptyText : getPersonModuleTranslation('IFSC_CODE'),
	        		store:Ext.create('Academia.store.feeandpayment.receipts.BranchIfscCodeStore'),
	        		valueField : 'code',
	        		displayField : 'code',
	        		name : 'ifscCodeValue',
	        		triggerAction : 'all',
	                disabled:true,
	        		valueNotFoundText:"",        		        						
					forceSelection :true,
				    queryParam:'ifscCode',
		    		minChars:3,
		    		allowBlank: true,
		    		typeAhead:false,
	                editable:true,
					emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
				}]
				
			}]
		});
		return itemsArray;
	},
	
	
//	getContactDetailsFormField: function(itemsArray) {

//	itemsArray.push({});
//	return itemsArray;
//	},
	getFamilyIncomeField: function(objArray) {
		objArray.push({
			xtype: 'fieldcontainer',
			defaults: {
				labelAlign: 'top',
				width: 226,
				tdAttrs: { style: 'padding: 5px;' }
			},
			items: [{
				xtype: 'numberfield',
				fieldLabel: getPersonModuleTranslation('FAMILTY_INCOME'),
				name: 'personalIncome',
				minValue : 0
			}]
		});

		return objArray;
	},

	getIsRegistrationContractField: function(itemsArray) {
	    itemsArray.push({
	        xtype: 'fieldcontainer',
	        hidden: true,
	        itemId: 'isRegistrationContractContainerItemId',
	        layout: 'hbox',
	        style: {
	            //marginTop: '25px',
	            marginLeft: '10px'
	        },
	        items: [{
	            xtype: 'checkboxfield',
	            name: 'isRegistrationContract',
	            itemId: 'isRegistrationContractItemId',
	            width: 'auto',
	            readOnly: 'true',
	            labelAlign: 'right',
	            allowBlank: false,
	            hidden: true,
	            style:{'margin-top':'5px !important'},
	            inputValue: true,
	            uncheckedValue: false
	        },{
                xtype: 'displayfield',
                style: {
                    height: 'auto',
                    textAlign: 'justify'
                },
                flex:1,
                value: '<p style=\'font: normal 13px/17px Open Sans, sans-serif, Myriad Pro;margin:12px 60px 12px 0px;\'>' + getAdmissionTranslation('APOL_REGISTRATION_CONTRACT_CHECKBOX_TEXT') + '</p>',
            }]

	    });

	    return itemsArray;
	},
	
	getIsRegistrationContractConditionField: function(itemsArray) {
	    itemsArray.push({
	        xtype: 'fieldcontainer',
	        hidden: true,
	        itemId: 'isRegistrationContractConditionContainerItemId',
	        layout: 'hbox',
	        style: {
	            //marginTop: '25px',
	            marginLeft: '10px'
	        },
	        items: [{
	            xtype: 'checkboxfield',
	            name: 'isRegistrationContractCondition',
	            itemId: 'isRegistrationContractConditionItemId',
	            width: 'auto',
	            readOnly: 'true',
	            labelAlign: 'right',
//	            allowBlank: false,
	            style:{'margin-top':'5px !important'},
	            hidden: true,
	            inputValue: true,
	            uncheckedValue: false
	        },{
                xtype: 'displayfield',
                style: {
                    height: 'auto',
                    textAlign: 'justify'
                },
                flex:1,
                value: '<p style=\'font: normal 13px/17px Open Sans, sans-serif, Myriad Pro;margin:12px 60px 12px 0px;\'>' + getAdmissionTranslation('APOL_REGISTRATION_CONTRACT_CHECKBOX_TEXT2') + '</p>',
            }]

	    });

	    return itemsArray;
	},
	
	getSaveFormField: function(itemsArray) {
		itemsArray.push({
			xtype: 'button',
			text: getCommonTranslation('SAVE'),
			buttonAlign: 'left',
			itemId: 'personalInfoSaveButtonId',
			ui: 'CustomBtnSubmit',
			scale: CONSTANTS.BUTTONSIZE,         
			formBind: true,  
			hasDisableForProfileViewMode:true,
			style:{
				marginLeft:'10px',
				marginTop:'5px'
			}
		});

		return itemsArray;
	},
	
});
