/**
 * @author Bhartendu Bhaskar
 */
Ext.define('Academia.view.personinfo.common.personalinfo.SSODetailsGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.ssodetailsgrid',
    /*store: 'eventmeetingminutes.EventMeetingMinutesTaskStore',*/
    title: getPersonModuleTranslation('SSO_DETAILS'),
    border: true,
    frame: false,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS,
        deferEmptyText: false,		
        emptyText: getCommonTranslation('NORESULTSNMESSAGE')
    },
    buildStore: function() {
        return Ext.create('Academia.store.personinfo.common.personalinfo.SSODetailsStore');
    },
    initComponent: function() {
        var this$ = this;
        var store = this$.buildStore();
        Ext.apply(this$, {
            store: store
        });
        this$.callParent(arguments);
    },
    tbar: [{
		xtype: 'button',
		itemId: 'btnAddSSO',
		tooltip: getCommonTranslation("ADD"),
		glyph: ICONGLYPH.ADDGLYPH
	},{
        xtype: 'button',
        itemId: 'btnSaveItemId',
        tooltip: getCommonTranslation('SAVE'),
        text: getCommonTranslation('SAVE'),
        disabled:true,
        scale: CONSTANTS.BUTTONSIZE,
        style: {
            marginRight: '10px'
        }
    }],
    columns: [{
        header: getPersonModuleTranslation('SSO_LOGIN_SOURCE'),
        dataIndex: 'socialLoginIntegrationId',
        flex: 0.4,
        sortable: true,
        editor: {
			xtype: 'customcombobox',
			name:'socialLoginIntegrationId',
			itemId:'socialLoginIntegrationItemId',
			store:'personinfo.common.personalinfo.SocialLoginIntegrationStore',
			valueField: 'id',
			displayField: 'value',
			typeAhead:false,
            forceSelection: true,
            editable: false,
            maxLength: 100,
            listeners: {
        		select: function(combo, record) {
        			var grid = combo.up('ssodetailsgrid');
        			var selectedRecord = grid.getSelectionModel().getSelection()[0];
        			var idVal = record[0].data.id;
        			
        			var flag = true;
        			var itms = grid.getStore().data.items;
        			itms.forEach(function(object){
        				if(object.data.socialLoginIntegrationId == idVal){
        					flag = false;
        					return false;
        				}
        			});
        			if(flag){
        				
        			}else{
        				combo.reset();
        				showWarningMessage(getCommonTranslation('ALERT'),getPersonModuleTranslation('SSO_LOGIN_SOURCE_ALREADY_SELECTED_MSG'));
        				return false;
        			}
        		}
    		}
		},
		listeners: {
			render: function(combo){
				combo.getEditor().store.load();
			}
    	},
		renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
    		if(!isNullOrEmpty(val)) {
    			try{
    				var index = rec.column.getEditor().store.findExact('id',val);
    				if(index !== -1){
    					return rec.column.getEditor().store.getAt(rec.column.getEditor().store.findExact('id',val)).data.value;
    				}
    			}
    			catch(e){
    				return null;
    			}
    		} else {
    			if(!isNullOrEmpty(record.get('id')) && record.get('id') !== '') {
    				var editor = rec.column.getEditor();
    				var recTypeName = record.get('value');
    				editor.store.load();
    				if(!isNullOrEmpty(recTypeName)){
    					return recTypeName;
    				}
    			}
    			else{
    				if(Ext.isDefined(record.get('socialLoginIntegrationId')) && isNullOrEmpty(record.get('socialLoginIntegrationId'))){
    					rec.tdCls = 'gridInputCustomStyle';
    					return getExaminationTranslation('CLICK_TO_ENTER');
    				}
    			}
    		}
		}
    }, {
        header: getPersonModuleTranslation('SSO_SOCIAL_ID'),
        dataIndex: 'socialEmail',
        flex: 0.9,
        sortable: true,
        editor: {
            xtype: 'textfield',
            name: 'socialEmail',
            itemId: 'socialEmailItemId',
			maxLength: '100',
			vtype: 'email'
        },
        renderer: function(val, rec) {
            if (isNullOrEmpty(val)) {
                rec.tdCls = 'gridInputCustomStyle';
                return getExaminationTranslation('CLICK_TO_ENTER');
            } else {
                return val;
            }
        }
    }, {
        header: getServiceRequestTranslation('EMM_ADD'),
        dataIndex: 'addButton',
        flex: 0.5,
        cls: 'CustomBodyBtnSettings',
        sortable: true,
        renderer: function(value, meta, record) {
                return "<div class='addButtonClsForGridActionCls'  auto !important'></div>";
        }
    }, {
        header: getServiceRequestTranslation('EMM_DELETE'),
        dataIndex: 'deleteButton',
        flex: 0.6,
        cls: 'CustomBodyBtnSettings',
        sortable: true,
        renderer: function(val, rec, record, rowIndex, colIndex, store, view) {
                return "<div class='deleteButtonClsForGridActionCls'  auto !important'></div>";
        }
    }],
    plugins: [{
        ptype: 'cellediting',
        clicksToEdit: 1,
        listeners: {
            beforeedit: function(obj, editor, context) {}
        }
    }]
});
