/**
 * @author Abhishek Chouhan

 * This component is used for to show WorkHour Grid
 */
Ext.define('Academia.view.personinfo.faculty.WorkHourDetailsGrid', {
    extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
    alias: 'widget.workhourdetailsgrid',
    store: 'calendar.FacultyWorkHoursStore',
    title: getPersonModuleTranslation('WORK_HOURS'),
    collapsible: false,
    border: true,
    viewConfig: {
        stripeRows: CONSTANTS.STRIPEROWS
    },
    features: [{
        ftype: 'summary',
        showSummaryRow: CONSTANTS.SHOW_SUMMARY_ROW
    }],
    columns: [{
        header: getCommonTranslation('DAY'),
        dataIndex: 'weekday',
        align: 'center',
        sortable: false,
        flex: .4,
        renderer: function(value, metaData, record, rowIndex, colIndex, view) {
            metaData.style = "white-space: normal;";
            if (!isNullOrEmpty(value)) {
                if (value == "SUNDAY") {
                    return getCommonTranslation("SUNDAY");
                } else if (value == "MONDAY") {
                    return getCommonTranslation("MONDAY");
                } else if (value == "TUESDAY") {
                    return getCommonTranslation("TUESDAY");
                } else if (value == "WEDNESDAY") {
                    return getCommonTranslation("WEDNESDAY");
                } else if (value == "THURSDAY") {
                    return getCommonTranslation("THURSDAY");
                } else if (value == "FRIDAY") {
                    return getCommonTranslation("FRIDAY");
                } else if (value == "SATURDAY") {
                    return getCommonTranslation("SATURDAY");
                }
            }
            return value;
        },
        summaryRenderer: function(value, summaryData, dataIndex) {
            return getFeeAndPaymentCommonTranslation('TOTAL');
        },
    }, {
        header: getServiceRequestTranslation('IN_TIME'),
        dataIndex: 'startTime',
        align: 'center',
        sortable: true,
        flex: .4,
        renderer: function(value, record) {
            return timeRender(value);
        }

    }, {
        header: getServiceRequestTranslation('OUT_TIME'),
        dataIndex: 'endTime',
        align: 'center',
        sortable: true,
        flex: .4,
        renderer: function(value, record) {
            return timeRender(value);
        }

    },{
        header: getCommonTranslation('TOTAL_HOURS'),
        dataIndex: 'totalHours',
        align: 'center',
        sortable: true,
        flex: .4,
        renderer: function(val) {
        	if (!isNullOrEmpty(val)) {
        		var d = new Date(val);
                hoursArray = d.getHours();
                minuteArray = d.getMinutes();
                var totalTimeInMinutes = (val / 60000);
                var minutes = 0,
                    hours = 0;
                var hours = 0 + '' + d.getHours();
                var minutes = 0 + '' + d.getMinutes();
                var totalTime = hours.substr(-2) + ':' + minutes.substr(-2);
                return totalTime;
            } else {
                return '';
            }
        },
        summaryType: function(records) {
            var hoursArray = 0,
                minuteArray = 0;
            for (i in records) {
                var totalHours = records[i].get('totalHours');
                if (!isNullOrEmpty(totalHours)) {
                    var d = new Date(totalHours);
                    hoursArray = hoursArray + d.getHours();
                    minuteArray = minuteArray + d.getMinutes();
                }
            }
            if (minuteArray >= 60) {
                var reminderMinute = (minuteArray % 60);
                var minutesToHours = (minuteArray - reminderMinute) / 60;
                hoursArray = hoursArray + minutesToHours;
                minuteArray = reminderMinute;
            }
            return hoursArray + ':' + minuteArray;
        },
        summaryRenderer: function(value, summaryData, dataIndex, rowIndex, colIndex, store, view) {
            return value;
        }
    }, {
        header: getCommonTranslation('LATE_COMING_ALLOWED_TILL'),
        dataIndex: 'lateComingAllowedTill',
        align: 'center',
        sortable: true,
        flex: .4,
        renderer: function(value, record) {
            return timeRender(value);
        }
    }, {
        header: getCommonTranslation('EARLY_GOING_ALLOWED_AFTER'),
        dataIndex: 'earlyGoingAllowedAfter',
        align: 'center',
        sortable: true,
        flex: .4,
        renderer: function(value, record) {
            return timeRender(value);
        }
    }, {
        header: getCommonTranslation('MIN_HOURS_FOR_FULL_DAY'),
        dataIndex: 'minHoursOfFullDay',
        align: 'center',
        sortable: true,
        flex: .4,
        renderer: function(val) {
        	if (!isNullOrEmpty(val)) {
        		var d = new Date(val);
                hoursArray = d.getHours();
                minuteArray = d.getMinutes();
                var totalTimeInMinutes = (val / 60000);
                var minutes = 0,
                    hours = 0;
                var hours = 0 + '' + d.getHours();
                var minutes = 0 + '' + d.getMinutes();
                var totalTime = hours.substr(-2) + ':' + minutes.substr(-2);
                return totalTime;
            } else {
                return '';
            }
        },
    }, {
        header: getCommonTranslation('MIN_HOURS_FOR_HALF_DAY'),
        dataIndex: 'minHoursOfHalfDay',
        align: 'center',
        sortable: true,
        flex: .4,
        renderer: function(val) {
        	if (!isNullOrEmpty(val)) {
        		var d = new Date(val);
                hoursArray = d.getHours();
                minuteArray = d.getMinutes();
                var totalTimeInMinutes = (val / 60000);
                var minutes = 0,
                    hours = 0;
                var hours = 0 + '' + d.getHours();
                var minutes = 0 + '' + d.getMinutes();
                var totalTime = hours.substr(-2) + ':' + minutes.substr(-2);
                return totalTime;
            } else {
                return '';
            }
        },
    }],
    initComponent: function() {
        var grid = this;
        grid.addExportToolBarItems(grid);
        this.callParent(arguments);
    },
    dockedItems: [{
        xtype: 'toolbar',
        dock: 'bottom',
        items: [{
            xtype: 'custompagingtoolbar',
            plugins: ['pagesize'],
            store: 'calendar.FacultyWorkHoursStore',
            emptyMsg: "No Records to display",
            displayInfo: true
        }]
    }]
});