/**
 * @author <a href="vyabha.thakur@serosoft.in">Vyabha Thakur</a>
 *
 */
Ext.define('Academia.view.personinfo.student.FunctionaryProgressReportForm', {
    extend: 'Ext.form.Panel',
    alias: 'widget.functionaryprogressreportform',
    border : false,
    frame : false,
    plugins: "formlabelrequired",
	width:'100%',
    items: [{
        xtype: 'hidden',
        itemId: 'functionary_progress_report_hidden_field',
        name: 'id'
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [ {
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('PROGRESS_REPORT_START_DATE'),
          //--submitFormat: CONSTANTS.DATE_FORMAT,
            itemId: 'progressReportPeriodStartDate',
            name: 'progressReportPeriodStartDate',
            endDateField:'progressReportPeriodEndDate',
            allowBlank: false,
            vtype : 'daterange',
            listeners: {
          	  render: function(field) {
          		  return dateFormatRender(field);
          	  }
            }
        }, {
            xtype: 'datefield',
            fieldLabel: getCommonTranslation('PROGRESS_REPORT_END_DATE'),
            itemId: 'progressReportPeriodEndDate',
            name: 'progressReportPeriodEndDate',
            startDateField : 'progressReportPeriodStartDate',
            allowBlank: false,
            vtype : 'daterange',
            listeners: {
          	  render: function(field) {
          		  return dateFormatRender(field);
          	  }
            }
        }]
    
    }, {

    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
            xtype: 'customcombobox',
            fieldLabel: getCommonTranslation('EMPLOYEE_ID'),
            itemId: 'responsibleFunctionaryEmployeeID',
            name: 'responsibleFunctionaryEmployeeID',
            store: 'common.AllUserBySmartSearchFPR',
            allowBlank: false,
            queryParam:'codeOrName',
            triggerAction: 'all',
            forceSelection: true,
            emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
            enableKeyEvents  : 'true',
            triggerCls : Ext.baseCSSPrefix + 'form-search-trigger',
			minChars:3,
			displayField: 'value', 
			valueField: 'id',
			/*displayTpl: new Ext.XTemplate(
             		'<tpl for="."between=" ">',
             		'{[typeof values === "string" ? values : values["code"]]}' +
             		'</tpl>'
            )*/
			listConfig: {
				listeners: {
					beforeshow: function(picker) {
						picker.minWidth = picker.up('combobox').getSize().width;
					}
				},
				loadingText: getCommonTranslation('SEARCHING'),
				emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
				getInnerTpl: function() {
					return '<div class="search-item">' +
					'{value}' +
					'</div>';
				}
			}
        },{
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('FIRST_NAME'),            
            itemId: 'name',
            readOnly: true,
            name: 'name',
            allowBlank: false
        }]
    },{

    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
            xtype: 'textfield',
            fieldLabel: getCommonTranslation('LAST_NAME'),            
            itemId: 'lastName',
            readOnly: true,
            name: 'lastName',
            allowBlank: true
        },{
			xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('FUNCTIONARY_TYPE'),
			store: 'common.FunctionaryTypeStore',
			itemId: 'functionaryType',
			name: 'functionaryType',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			allowBlank: false
		}]
    }, {
        xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        
        items: [ {
        	xtype: 'datefield',
            fieldLabel: getPersonModuleTranslation('AUDIT_DATE'),
            itemId: 'auditDate',
            name: 'auditDate',
            editable : false,
            startDateField : 'auditDate',
            listeners: {
            	render: function(obj) {
            		obj = dateFormatRender(obj);
            		obj.setValue(new Date());
            	}
            },
            allowBlank: false,
            vtype : 'daterange'
        },{
        	xtype: 'textfield',
            fieldLabel: getPersonModuleTranslation('AUDIT_ID'),            
            itemId: 'auditId',
            name: 'auditId',
            readOnly : true,
            allowBlank: false
        }]
    },{

    	xtype: 'fieldcontainer',
        layout: 'hbox',
        defaults: {
            labelAlign: 'top',
            width: 260
        },
        items: [{
        	xtype: 'customcombobox',
			fieldLabel: getCommonTranslation('PROGRESS_REPORT_RATING'),
			store: 'common.ReportRatingStore',
			itemId: 'reportRating',
			name: 'reportRating',
			valueField: 'id',
			displayField: 'value',
			editable: false,
			allowBlank: true
        }]
    },{
		xtype: 'fieldcontainer',    
		layout : {
			type : 'vbox'
		},
		cls:'horizontal-scrolling-fix',
		defaults : {
			width : 460,
			labelAlign : 'top'
		},
		items : [{
			xtype:'functionaryprogressreportdocumentgrid',
			itemId:'functionaryprogressreportdocumentgridId',
			hidden:true,
			style:{
				marginLeft:'0px',
			},
			flex:.1
		}]
	
	},{ 
		xtype:'fieldcontainer',
    	width:'auto',
		layout : 'hbox',
		items: [{
            xtype: 'button',
            text: getCommonTranslation('SUBMIT'),
            itemId: 'submitButtonId',
            buttonAlign: 'right',
            ui: 'CustomBtnSubmit',
            scale: CONSTANTS.BUTTONSIZE,
            formBind: true
        },{
            xtype: 'button',
            text: getCommonTranslation('CANCEL'),
            ui: 'CustomBtnCancel',
            itemId: 'cancelButtonId',
            scale: CONSTANTS.BUTTONSIZE

        },{
			 xtype: 'button',
			 name: 'courseSyllabus',
			 text:getCommonTranslation('UPLOAD_DOC'),
			 itemId: 'uploadFunctionaryProgressReportItemId',
			 ui: 'CustomBtnThird',
		   	 scale : CONSTANTS.BUTTONSIZE
		}]
    }]
});
