/**
 *  @author Priyanshi sharma
 */

Ext.define('Academia.view.personinfo.student.ManageHoldsMappedProgramWindowGrid', {
	extend: 'Academia.view.facilitiesresources.resourcebooking.StaticGridExcelExport',
	alias: 'widget.manageholdsmappedprogramwindowgrid',
	store: 'student.managehold.ManageHoldMappingGridStore',
	border: true,
	autoScroll: false,
	viewConfig: {
		stripeRows: CONSTANTS.STRIPEROWS
	},
	dockedItems: [{
		xtype : 'toolbar',
		dock : 'bottom',
		items : [ {
			xtype : 'custompagingtoolbar',
			plugins:['pagesize'],
			store : 'student.managehold.ManageHoldMappingGridStore',
			emptyMsg: getCommonTranslation('NORESULTSNMESSAGE'),
			displayInfo : true
		} ]
	}],
	columns: [{
		header:  getCommonTranslation('ACADEMY'),
		dataIndex: 'academyName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('LOCATION'),
		dataIndex: 'locationName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('PROGRAM'),
		dataIndex: 'programName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('BATCH'),
		dataIndex: 'batchName',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('PERIOD'),
		dataIndex: 'period',
		flex:1,
		sortable:true
	},{
		header:  getCommonTranslation('SEAT_NAME'),
		dataIndex: 'seatTypeName',
		flex:1,
		sortable:true
	}]
});