Ext.define('Academia.view.personinfo.student.StudentDownloadIdCardDashletWindow', {
	extend: 'Ext.window.Window',
	alias: 'widget.studentdownloadidcarddashletwindow',
	modal: true,
	frame: true,
	title:getCommonTranslation('DOWNLOAD_ID_CARD'),
	items: [{		
    xtype: 'form',
    defaults:{
    	labelAlign:'top',
    	width:226
    },
    standardSubmit: false,
    plugins:"formlabelrequired",    
    items:[{
        xtype: 'textfield',
        itemId: 'isSingleStudent',
        name: 'code',
        maxLength: 255,
        hidden:true
    },{
		xtype : 'customcombobox',
		name : 'studentAcademyLocation',
		itemId:'studentAcademyLocation',
		fieldLabel : getProgramandcourseTranslation('ACADEMY_LOCATION'),
		store:Ext.create('Academia.store.student.studentprofile.StudentsFindByAlStore'),
		valueField : 'id',
		displayField : 'value',
		minChars:3,
		typeAhead : false,
		forceSelection:true,
		hideTrigger:false,
		allowBlank:false,
		triggerAction: 'all',
		queryParam:'qry',
		//emptyText: getCommonTranslation('ENTER_THREE_CHAR'),
		listConfig: {
			listeners: {
				beforeshow: function(picker) {
					picker.minWidth = picker.up('combobox').getSize().width;
				}
			},
			loadingText: getCommonTranslation('SEARCHING'),
			emptyText: getCommonTranslation('NO_RECORDS_FOUND'),
			getInnerTpl: function() {
				return '<div class="search-item">' +
				'{value}' +
				'</div>';
			}
		}
	}/*,{
	    	xtype: 'customcombobox',
	    	fieldLabel: getCommonTranslation('TEMPLATE_ID_CARD'),
	    	itemId: 'templateNameStudent',
	    	name: 'templateNameStudent',
	    	store:Ext.create('Academia.store.setup.templatemapping.TemplateNameListStudentByCode'),
	    	valueField:'value',
	    	displayField:'code',
	    	disabled:true,
	    	allowBlank:false,
	    	editable: false,
	}*/,{
		xtype: 'fieldcontainer',
		width:'100%',
		items: [{
			xtype: 'button',
			itemId: 'btnDownload',
			text : getCommonTranslation('DOWNLOAD'),
			buttonAlign : 'left',
			ui : 'CustomBtnThird',
			scale : CONSTANTS.BUTTONSIZE,
			formBind : true
		}]	
	}]
	}]
});
