/**
 * @Author Ramkrishn yadav
 */
Ext.define('Academia.view.personinfo.student.StudentListApplyHolds', {
	extend:'Ext.window.Window',
	alias: 'widget.studentlistapplyholds',
	title : getCommonTranslation('APPLY_HOLD'),
	border : false,
	frame : false,
	modal: true,
	items: [{
		xtype: 'form',
		method : 'POST',
		itemId:'studentlistapplyhold',
		plugins : "formlabelrequired",
		defaults: {
			labelAlign: 'top',
			width:226
		},
		standardSubmit : false,
	items: [ {
        xtype: 'hidden',
        itemId: 'id',
        name: 'id'
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 226
    	},
    	layout: {
    		type: 'hbox'
    	},
    	items: [{
			xtype: 'customcombobox',
			name: 'holdCatStudent',
			itemId:'holdCatStudent',
			fieldLabel: getCommonTranslation('HOLD_CATEGORY_NAME'),
			allowBlank: false,
			valueField: 'id',
			displayField: 'value',
			store:'student.managehold.StudentHoldCategoryNameStore',
			typeAhead:true,
			forceSelection:true,
		},{
			xtype: 'customcombobox',
			name: 'subHoldCatStudent',
			itemId:'subHoldCatStudent',
			fieldLabel: getCommonTranslation('HOLD_SUB_CATEGORY_NAME'),
			allowBlank: false,
			valueField: 'id',
			displayField: 'valueCode',
			store:'student.managehold.StudentSubHoldCategoryNameStore',
			typeAhead:true,
			forceSelection:true,
			disabled:true
		}]
    }, {
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 226
    	},
    	layout: {
    		type: 'hbox'
    	},
    	items: [ {
    		xtype: 'datefield',
    		name: 'applyDate',
    		itemId:'applyDateItemId',
    		  readOnly: false,
    		  maxValue: new Date(),
    		  editable:false,
    		  allowBlank: false,
    		fieldLabel: getCommonTranslation('APPLIED_DATE'),
    		listeners: {
    			 render: function(obj) {
                     obj = dateFormatRender(obj);
                     obj.setValue(new Date());
                 }
    		}
   
    	},{

			xtype: 'customcombobox',
			name: 'applyBy',
			itemId:'applyById',
			fieldLabel: getCommonTranslation('APPLIED_BY'),
			store:'coursetransaction.sectionmanagement.FacultyIdValueSmartSearch',
			displayField: 'valueCode',
			valueField:'id',
			readOnly: true,
			forceSelection:true,
			allowBlank: false,
			
		}]

    },{
    	xtype: 'fieldcontainer',
    	width: '100%',
    	defaults: {
			xtype: 'displayfield',
    	},
    	items: [{
    		name: 'applyHoldAt',
			itemId:'applyHoldAtList',
			readOnly:true,
			cls:'applyHoldAt',
			labelWidth:'auto',
			fieldLabel: getCommonTranslation('APPLY_HOLD_AT')
		}]
    },{
    	xtype: 'fieldcontainer',
    	width: 'auto',
    	defaults: {
    		labelAlign: 'top',
    		width: 226
    	},
    	layout: {
    		type: 'hbox'
    	},
    	items: [{
			xtype: 'textarea',
			name: 'applyReason',
			maxLength : 5000,
			width: 465,
			itemId:'applyReasonItemId',
			fieldLabel: getCommonTranslation('REASON_FOR_APPLYING_HOLD'),
			allowBlank: false,
			style:{
				'margin-top':'-9px !important'
			}
			
		}]

    }, {
    	xtype: 'fieldcontainer',
    	items: [{
    		xtype: 'button',
    		text: getCommonTranslation('SUBMIT'),
    		itemId: 'submitButtonId',
    		buttonAlign: 'right',
    		ui: 'CustomBtnSubmit',
    		scale: CONSTANTS.BUTTONSIZE,
    		formBind: true
    	}, {
    		xtype: 'button',
    		text: getCommonTranslation('CANCEL'),
    		ui: 'CustomBtnCancel',
    		itemId: 'cancelButtonId',
    		scale: CONSTANTS.BUTTONSIZE
    	}]
    }]
}]
});